/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphIdentitySet;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.Map;

public final class MicrosoftGraphShared
implements JsonSerializable<MicrosoftGraphShared> {
    private MicrosoftGraphIdentitySet owner;
    private String scope;
    private MicrosoftGraphIdentitySet sharedBy;
    private OffsetDateTime sharedDateTime;
    private Map<String, Object> additionalProperties;

    public MicrosoftGraphIdentitySet owner() {
        return this.owner;
    }

    public MicrosoftGraphShared withOwner(MicrosoftGraphIdentitySet owner) {
        this.owner = owner;
        return this;
    }

    public String scope() {
        return this.scope;
    }

    public MicrosoftGraphShared withScope(String scope) {
        this.scope = scope;
        return this;
    }

    public MicrosoftGraphIdentitySet sharedBy() {
        return this.sharedBy;
    }

    public MicrosoftGraphShared withSharedBy(MicrosoftGraphIdentitySet sharedBy) {
        this.sharedBy = sharedBy;
        return this;
    }

    public OffsetDateTime sharedDateTime() {
        return this.sharedDateTime;
    }

    public MicrosoftGraphShared withSharedDateTime(OffsetDateTime sharedDateTime) {
        this.sharedDateTime = sharedDateTime;
        return this;
    }

    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    public MicrosoftGraphShared withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    public void validate() {
        if (this.owner() != null) {
            this.owner().validate();
        }
        if (this.sharedBy() != null) {
            this.sharedBy().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("owner", (JsonSerializable)this.owner);
        jsonWriter.writeStringField("scope", this.scope);
        jsonWriter.writeJsonField("sharedBy", (JsonSerializable)this.sharedBy);
        jsonWriter.writeStringField("sharedDateTime", this.sharedDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.sharedDateTime));
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static MicrosoftGraphShared fromJson(JsonReader jsonReader) throws IOException {
        return (MicrosoftGraphShared)jsonReader.readObject(reader -> {
            MicrosoftGraphShared deserializedMicrosoftGraphShared = new MicrosoftGraphShared();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("owner".equals(fieldName)) {
                    deserializedMicrosoftGraphShared.owner = MicrosoftGraphIdentitySet.fromJson(reader);
                    continue;
                }
                if ("scope".equals(fieldName)) {
                    deserializedMicrosoftGraphShared.scope = reader.getString();
                    continue;
                }
                if ("sharedBy".equals(fieldName)) {
                    deserializedMicrosoftGraphShared.sharedBy = MicrosoftGraphIdentitySet.fromJson(reader);
                    continue;
                }
                if ("sharedDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphShared.sharedDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedMicrosoftGraphShared.additionalProperties = additionalProperties;
            return deserializedMicrosoftGraphShared;
        });
    }
}

