/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphPatternedRecurrence;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphTimeRange;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class MicrosoftGraphShiftAvailability
implements JsonSerializable<MicrosoftGraphShiftAvailability> {
    private MicrosoftGraphPatternedRecurrence recurrence;
    private List<MicrosoftGraphTimeRange> timeSlots;
    private String timeZone;
    private Map<String, Object> additionalProperties;

    public MicrosoftGraphPatternedRecurrence recurrence() {
        return this.recurrence;
    }

    public MicrosoftGraphShiftAvailability withRecurrence(MicrosoftGraphPatternedRecurrence recurrence) {
        this.recurrence = recurrence;
        return this;
    }

    public List<MicrosoftGraphTimeRange> timeSlots() {
        return this.timeSlots;
    }

    public MicrosoftGraphShiftAvailability withTimeSlots(List<MicrosoftGraphTimeRange> timeSlots) {
        this.timeSlots = timeSlots;
        return this;
    }

    public String timeZone() {
        return this.timeZone;
    }

    public MicrosoftGraphShiftAvailability withTimeZone(String timeZone) {
        this.timeZone = timeZone;
        return this;
    }

    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    public MicrosoftGraphShiftAvailability withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    public void validate() {
        if (this.recurrence() != null) {
            this.recurrence().validate();
        }
        if (this.timeSlots() != null) {
            this.timeSlots().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("recurrence", (JsonSerializable)this.recurrence);
        jsonWriter.writeArrayField("timeSlots", this.timeSlots, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("timeZone", this.timeZone);
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static MicrosoftGraphShiftAvailability fromJson(JsonReader jsonReader) throws IOException {
        return (MicrosoftGraphShiftAvailability)jsonReader.readObject(reader -> {
            MicrosoftGraphShiftAvailability deserializedMicrosoftGraphShiftAvailability = new MicrosoftGraphShiftAvailability();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("recurrence".equals(fieldName)) {
                    deserializedMicrosoftGraphShiftAvailability.recurrence = MicrosoftGraphPatternedRecurrence.fromJson(reader);
                    continue;
                }
                if ("timeSlots".equals(fieldName)) {
                    List timeSlots;
                    deserializedMicrosoftGraphShiftAvailability.timeSlots = timeSlots = reader.readArray(reader1 -> MicrosoftGraphTimeRange.fromJson(reader1));
                    continue;
                }
                if ("timeZone".equals(fieldName)) {
                    deserializedMicrosoftGraphShiftAvailability.timeZone = reader.getString();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedMicrosoftGraphShiftAvailability.additionalProperties = additionalProperties;
            return deserializedMicrosoftGraphShiftAvailability;
        });
    }
}

