/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphLocationType;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphLocationUniqueIdType;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphOutlookGeoCoordinates;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphPhysicalAddress;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class MicrosoftGraphLocation
implements JsonSerializable<MicrosoftGraphLocation> {
    private MicrosoftGraphPhysicalAddress address;
    private MicrosoftGraphOutlookGeoCoordinates coordinates;
    private String displayName;
    private String locationEmailAddress;
    private MicrosoftGraphLocationType locationType;
    private String locationUri;
    private String uniqueId;
    private MicrosoftGraphLocationUniqueIdType uniqueIdType;
    private Map<String, Object> additionalProperties;

    public MicrosoftGraphPhysicalAddress address() {
        return this.address;
    }

    public MicrosoftGraphLocation withAddress(MicrosoftGraphPhysicalAddress address) {
        this.address = address;
        return this;
    }

    public MicrosoftGraphOutlookGeoCoordinates coordinates() {
        return this.coordinates;
    }

    public MicrosoftGraphLocation withCoordinates(MicrosoftGraphOutlookGeoCoordinates coordinates) {
        this.coordinates = coordinates;
        return this;
    }

    public String displayName() {
        return this.displayName;
    }

    public MicrosoftGraphLocation withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public String locationEmailAddress() {
        return this.locationEmailAddress;
    }

    public MicrosoftGraphLocation withLocationEmailAddress(String locationEmailAddress) {
        this.locationEmailAddress = locationEmailAddress;
        return this;
    }

    public MicrosoftGraphLocationType locationType() {
        return this.locationType;
    }

    public MicrosoftGraphLocation withLocationType(MicrosoftGraphLocationType locationType) {
        this.locationType = locationType;
        return this;
    }

    public String locationUri() {
        return this.locationUri;
    }

    public MicrosoftGraphLocation withLocationUri(String locationUri) {
        this.locationUri = locationUri;
        return this;
    }

    public String uniqueId() {
        return this.uniqueId;
    }

    public MicrosoftGraphLocation withUniqueId(String uniqueId) {
        this.uniqueId = uniqueId;
        return this;
    }

    public MicrosoftGraphLocationUniqueIdType uniqueIdType() {
        return this.uniqueIdType;
    }

    public MicrosoftGraphLocation withUniqueIdType(MicrosoftGraphLocationUniqueIdType uniqueIdType) {
        this.uniqueIdType = uniqueIdType;
        return this;
    }

    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    public MicrosoftGraphLocation withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    public void validate() {
        if (this.address() != null) {
            this.address().validate();
        }
        if (this.coordinates() != null) {
            this.coordinates().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("address", (JsonSerializable)this.address);
        jsonWriter.writeJsonField("coordinates", (JsonSerializable)this.coordinates);
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("locationEmailAddress", this.locationEmailAddress);
        jsonWriter.writeStringField("locationType", this.locationType == null ? null : this.locationType.toString());
        jsonWriter.writeStringField("locationUri", this.locationUri);
        jsonWriter.writeStringField("uniqueId", this.uniqueId);
        jsonWriter.writeStringField("uniqueIdType", this.uniqueIdType == null ? null : this.uniqueIdType.toString());
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static MicrosoftGraphLocation fromJson(JsonReader jsonReader) throws IOException {
        return (MicrosoftGraphLocation)jsonReader.readObject(reader -> {
            MicrosoftGraphLocation deserializedMicrosoftGraphLocation = new MicrosoftGraphLocation();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("address".equals(fieldName)) {
                    deserializedMicrosoftGraphLocation.address = MicrosoftGraphPhysicalAddress.fromJson(reader);
                    continue;
                }
                if ("coordinates".equals(fieldName)) {
                    deserializedMicrosoftGraphLocation.coordinates = MicrosoftGraphOutlookGeoCoordinates.fromJson(reader);
                    continue;
                }
                if ("displayName".equals(fieldName)) {
                    deserializedMicrosoftGraphLocation.displayName = reader.getString();
                    continue;
                }
                if ("locationEmailAddress".equals(fieldName)) {
                    deserializedMicrosoftGraphLocation.locationEmailAddress = reader.getString();
                    continue;
                }
                if ("locationType".equals(fieldName)) {
                    deserializedMicrosoftGraphLocation.locationType = MicrosoftGraphLocationType.fromString(reader.getString());
                    continue;
                }
                if ("locationUri".equals(fieldName)) {
                    deserializedMicrosoftGraphLocation.locationUri = reader.getString();
                    continue;
                }
                if ("uniqueId".equals(fieldName)) {
                    deserializedMicrosoftGraphLocation.uniqueId = reader.getString();
                    continue;
                }
                if ("uniqueIdType".equals(fieldName)) {
                    deserializedMicrosoftGraphLocation.uniqueIdType = MicrosoftGraphLocationUniqueIdType.fromString(reader.getString());
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedMicrosoftGraphLocation.additionalProperties = additionalProperties;
            return deserializedMicrosoftGraphLocation;
        });
    }
}

