/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphEntity;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphServicePlanInfo;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;

public final class MicrosoftGraphLicenseDetails
extends MicrosoftGraphEntity {
    private List<MicrosoftGraphServicePlanInfo> servicePlans;
    private UUID skuId;
    private String skuPartNumber;
    private Map<String, Object> additionalProperties;

    public List<MicrosoftGraphServicePlanInfo> servicePlans() {
        return this.servicePlans;
    }

    public MicrosoftGraphLicenseDetails withServicePlans(List<MicrosoftGraphServicePlanInfo> servicePlans) {
        this.servicePlans = servicePlans;
        return this;
    }

    public UUID skuId() {
        return this.skuId;
    }

    public MicrosoftGraphLicenseDetails withSkuId(UUID skuId) {
        this.skuId = skuId;
        return this;
    }

    public String skuPartNumber() {
        return this.skuPartNumber;
    }

    public MicrosoftGraphLicenseDetails withSkuPartNumber(String skuPartNumber) {
        this.skuPartNumber = skuPartNumber;
        return this;
    }

    @Override
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public MicrosoftGraphLicenseDetails withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @Override
    public MicrosoftGraphLicenseDetails withId(String id) {
        super.withId(id);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.servicePlans() != null) {
            this.servicePlans().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeArrayField("servicePlans", this.servicePlans, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("skuId", Objects.toString(this.skuId, null));
        jsonWriter.writeStringField("skuPartNumber", this.skuPartNumber);
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static MicrosoftGraphLicenseDetails fromJson(JsonReader jsonReader) throws IOException {
        return (MicrosoftGraphLicenseDetails)jsonReader.readObject(reader -> {
            MicrosoftGraphLicenseDetails deserializedMicrosoftGraphLicenseDetails = new MicrosoftGraphLicenseDetails();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphLicenseDetails.withId(reader.getString());
                    continue;
                }
                if ("servicePlans".equals(fieldName)) {
                    List servicePlans;
                    deserializedMicrosoftGraphLicenseDetails.servicePlans = servicePlans = reader.readArray(reader1 -> MicrosoftGraphServicePlanInfo.fromJson(reader1));
                    continue;
                }
                if ("skuId".equals(fieldName)) {
                    deserializedMicrosoftGraphLicenseDetails.skuId = (UUID)reader.getNullable(nonNullReader -> UUID.fromString(nonNullReader.getString()));
                    continue;
                }
                if ("skuPartNumber".equals(fieldName)) {
                    deserializedMicrosoftGraphLicenseDetails.skuPartNumber = reader.getString();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedMicrosoftGraphLicenseDetails.additionalProperties = additionalProperties;
            return deserializedMicrosoftGraphLicenseDetails;
        });
    }
}

