/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphAttendeeBase;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphAttendeeType;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphEmailAddress;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphResponseStatus;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphTimeSlot;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class MicrosoftGraphAttendee
extends MicrosoftGraphAttendeeBase {
    private MicrosoftGraphTimeSlot proposedNewTime;
    private MicrosoftGraphResponseStatus status;
    private Map<String, Object> additionalProperties;

    public MicrosoftGraphTimeSlot proposedNewTime() {
        return this.proposedNewTime;
    }

    public MicrosoftGraphAttendee withProposedNewTime(MicrosoftGraphTimeSlot proposedNewTime) {
        this.proposedNewTime = proposedNewTime;
        return this;
    }

    public MicrosoftGraphResponseStatus status() {
        return this.status;
    }

    public MicrosoftGraphAttendee withStatus(MicrosoftGraphResponseStatus status) {
        this.status = status;
        return this;
    }

    @Override
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public MicrosoftGraphAttendee withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @Override
    public MicrosoftGraphAttendee withType(MicrosoftGraphAttendeeType type) {
        super.withType(type);
        return this;
    }

    @Override
    public MicrosoftGraphAttendee withEmailAddress(MicrosoftGraphEmailAddress emailAddress) {
        super.withEmailAddress(emailAddress);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.proposedNewTime() != null) {
            this.proposedNewTime().validate();
        }
        if (this.status() != null) {
            this.status().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("emailAddress", (JsonSerializable)this.emailAddress());
        jsonWriter.writeStringField("type", this.type() == null ? null : this.type().toString());
        jsonWriter.writeJsonField("proposedNewTime", (JsonSerializable)this.proposedNewTime);
        jsonWriter.writeJsonField("status", (JsonSerializable)this.status);
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static MicrosoftGraphAttendee fromJson(JsonReader jsonReader) throws IOException {
        return (MicrosoftGraphAttendee)jsonReader.readObject(reader -> {
            MicrosoftGraphAttendee deserializedMicrosoftGraphAttendee = new MicrosoftGraphAttendee();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("emailAddress".equals(fieldName)) {
                    deserializedMicrosoftGraphAttendee.withEmailAddress(MicrosoftGraphEmailAddress.fromJson(reader));
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedMicrosoftGraphAttendee.withType(MicrosoftGraphAttendeeType.fromString(reader.getString()));
                    continue;
                }
                if ("proposedNewTime".equals(fieldName)) {
                    deserializedMicrosoftGraphAttendee.proposedNewTime = MicrosoftGraphTimeSlot.fromJson(reader);
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedMicrosoftGraphAttendee.status = MicrosoftGraphResponseStatus.fromJson(reader);
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedMicrosoftGraphAttendee.additionalProperties = additionalProperties;
            return deserializedMicrosoftGraphAttendee;
        });
    }
}

