/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.authorization.models.UserType;
import java.io.IOException;

public final class UserSet
implements JsonSerializable<UserSet> {
    private UserType userType;
    private Boolean isBackup;
    private String id;
    private String description;

    public UserType userType() {
        return this.userType;
    }

    public UserSet withUserType(UserType userType) {
        this.userType = userType;
        return this;
    }

    public Boolean isBackup() {
        return this.isBackup;
    }

    public UserSet withIsBackup(Boolean isBackup) {
        this.isBackup = isBackup;
        return this;
    }

    public String id() {
        return this.id;
    }

    public UserSet withId(String id) {
        this.id = id;
        return this;
    }

    public String description() {
        return this.description;
    }

    public UserSet withDescription(String description) {
        this.description = description;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("userType", this.userType == null ? null : this.userType.toString());
        jsonWriter.writeBooleanField("isBackup", this.isBackup);
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("description", this.description);
        return jsonWriter.writeEndObject();
    }

    public static UserSet fromJson(JsonReader jsonReader) throws IOException {
        return (UserSet)jsonReader.readObject(reader -> {
            UserSet deserializedUserSet = new UserSet();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("userType".equals(fieldName)) {
                    deserializedUserSet.userType = UserType.fromString(reader.getString());
                    continue;
                }
                if ("isBackup".equals(fieldName)) {
                    deserializedUserSet.isBackup = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("id".equals(fieldName)) {
                    deserializedUserSet.id = reader.getString();
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedUserSet.description = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedUserSet;
        });
    }
}

