/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphEntity;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphNotebook;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphOnenoteOperation;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphOnenotePage;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphOnenoteResource;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphOnenoteSection;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphSectionGroup;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class MicrosoftGraphOnenote
extends MicrosoftGraphEntity {
    private List<MicrosoftGraphNotebook> notebooks;
    private List<MicrosoftGraphOnenoteOperation> operations;
    private List<MicrosoftGraphOnenotePage> pages;
    private List<MicrosoftGraphOnenoteResource> resources;
    private List<MicrosoftGraphSectionGroup> sectionGroups;
    private List<MicrosoftGraphOnenoteSection> sections;
    private Map<String, Object> additionalProperties;

    public List<MicrosoftGraphNotebook> notebooks() {
        return this.notebooks;
    }

    public MicrosoftGraphOnenote withNotebooks(List<MicrosoftGraphNotebook> notebooks) {
        this.notebooks = notebooks;
        return this;
    }

    public List<MicrosoftGraphOnenoteOperation> operations() {
        return this.operations;
    }

    public MicrosoftGraphOnenote withOperations(List<MicrosoftGraphOnenoteOperation> operations) {
        this.operations = operations;
        return this;
    }

    public List<MicrosoftGraphOnenotePage> pages() {
        return this.pages;
    }

    public MicrosoftGraphOnenote withPages(List<MicrosoftGraphOnenotePage> pages) {
        this.pages = pages;
        return this;
    }

    public List<MicrosoftGraphOnenoteResource> resources() {
        return this.resources;
    }

    public MicrosoftGraphOnenote withResources(List<MicrosoftGraphOnenoteResource> resources) {
        this.resources = resources;
        return this;
    }

    public List<MicrosoftGraphSectionGroup> sectionGroups() {
        return this.sectionGroups;
    }

    public MicrosoftGraphOnenote withSectionGroups(List<MicrosoftGraphSectionGroup> sectionGroups) {
        this.sectionGroups = sectionGroups;
        return this;
    }

    public List<MicrosoftGraphOnenoteSection> sections() {
        return this.sections;
    }

    public MicrosoftGraphOnenote withSections(List<MicrosoftGraphOnenoteSection> sections) {
        this.sections = sections;
        return this;
    }

    @Override
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public MicrosoftGraphOnenote withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @Override
    public MicrosoftGraphOnenote withId(String id) {
        super.withId(id);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.notebooks() != null) {
            this.notebooks().forEach(e -> e.validate());
        }
        if (this.operations() != null) {
            this.operations().forEach(e -> e.validate());
        }
        if (this.pages() != null) {
            this.pages().forEach(e -> e.validate());
        }
        if (this.resources() != null) {
            this.resources().forEach(e -> e.validate());
        }
        if (this.sectionGroups() != null) {
            this.sectionGroups().forEach(e -> e.validate());
        }
        if (this.sections() != null) {
            this.sections().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeArrayField("notebooks", this.notebooks, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("operations", this.operations, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("pages", this.pages, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("resources", this.resources, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("sectionGroups", this.sectionGroups, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("sections", this.sections, (writer, element) -> writer.writeJson((JsonSerializable)element));
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static MicrosoftGraphOnenote fromJson(JsonReader jsonReader) throws IOException {
        return (MicrosoftGraphOnenote)jsonReader.readObject(reader -> {
            MicrosoftGraphOnenote deserializedMicrosoftGraphOnenote = new MicrosoftGraphOnenote();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphOnenote.withId(reader.getString());
                    continue;
                }
                if ("notebooks".equals(fieldName)) {
                    List notebooks;
                    deserializedMicrosoftGraphOnenote.notebooks = notebooks = reader.readArray(reader1 -> MicrosoftGraphNotebook.fromJson(reader1));
                    continue;
                }
                if ("operations".equals(fieldName)) {
                    List operations;
                    deserializedMicrosoftGraphOnenote.operations = operations = reader.readArray(reader1 -> MicrosoftGraphOnenoteOperation.fromJson(reader1));
                    continue;
                }
                if ("pages".equals(fieldName)) {
                    List pages;
                    deserializedMicrosoftGraphOnenote.pages = pages = reader.readArray(reader1 -> MicrosoftGraphOnenotePage.fromJson(reader1));
                    continue;
                }
                if ("resources".equals(fieldName)) {
                    List resources;
                    deserializedMicrosoftGraphOnenote.resources = resources = reader.readArray(reader1 -> MicrosoftGraphOnenoteResource.fromJson(reader1));
                    continue;
                }
                if ("sectionGroups".equals(fieldName)) {
                    List sectionGroups;
                    deserializedMicrosoftGraphOnenote.sectionGroups = sectionGroups = reader.readArray(reader1 -> MicrosoftGraphSectionGroup.fromJson(reader1));
                    continue;
                }
                if ("sections".equals(fieldName)) {
                    List sections;
                    deserializedMicrosoftGraphOnenote.sections = sections = reader.readArray(reader1 -> MicrosoftGraphOnenoteSection.fromJson(reader1));
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedMicrosoftGraphOnenote.additionalProperties = additionalProperties;
            return deserializedMicrosoftGraphOnenote;
        });
    }
}

