/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.authorization.models.Principal;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class PolicyAssignmentPropertiesPolicy
implements JsonSerializable<PolicyAssignmentPropertiesPolicy> {
    private String id;
    private Principal lastModifiedBy;
    private OffsetDateTime lastModifiedDateTime;

    public String id() {
        return this.id;
    }

    public PolicyAssignmentPropertiesPolicy withId(String id) {
        this.id = id;
        return this;
    }

    public Principal lastModifiedBy() {
        return this.lastModifiedBy;
    }

    public OffsetDateTime lastModifiedDateTime() {
        return this.lastModifiedDateTime;
    }

    public PolicyAssignmentPropertiesPolicy withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        this.lastModifiedDateTime = lastModifiedDateTime;
        return this;
    }

    public void validate() {
        if (this.lastModifiedBy() != null) {
            this.lastModifiedBy().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("lastModifiedDateTime", this.lastModifiedDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastModifiedDateTime));
        return jsonWriter.writeEndObject();
    }

    public static PolicyAssignmentPropertiesPolicy fromJson(JsonReader jsonReader) throws IOException {
        return (PolicyAssignmentPropertiesPolicy)jsonReader.readObject(reader -> {
            PolicyAssignmentPropertiesPolicy deserializedPolicyAssignmentPropertiesPolicy = new PolicyAssignmentPropertiesPolicy();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedPolicyAssignmentPropertiesPolicy.id = reader.getString();
                    continue;
                }
                if ("lastModifiedBy".equals(fieldName)) {
                    deserializedPolicyAssignmentPropertiesPolicy.lastModifiedBy = Principal.fromJson(reader);
                    continue;
                }
                if ("lastModifiedDateTime".equals(fieldName)) {
                    deserializedPolicyAssignmentPropertiesPolicy.lastModifiedDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPolicyAssignmentPropertiesPolicy;
        });
    }
}

