/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphScheduleEntityTheme;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.Map;

public final class MicrosoftGraphShiftActivity
implements JsonSerializable<MicrosoftGraphShiftActivity> {
    private String code;
    private String displayName;
    private OffsetDateTime endDateTime;
    private Boolean isPaid;
    private OffsetDateTime startDateTime;
    private MicrosoftGraphScheduleEntityTheme theme;
    private Map<String, Object> additionalProperties;

    public String code() {
        return this.code;
    }

    public MicrosoftGraphShiftActivity withCode(String code) {
        this.code = code;
        return this;
    }

    public String displayName() {
        return this.displayName;
    }

    public MicrosoftGraphShiftActivity withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public OffsetDateTime endDateTime() {
        return this.endDateTime;
    }

    public MicrosoftGraphShiftActivity withEndDateTime(OffsetDateTime endDateTime) {
        this.endDateTime = endDateTime;
        return this;
    }

    public Boolean isPaid() {
        return this.isPaid;
    }

    public MicrosoftGraphShiftActivity withIsPaid(Boolean isPaid) {
        this.isPaid = isPaid;
        return this;
    }

    public OffsetDateTime startDateTime() {
        return this.startDateTime;
    }

    public MicrosoftGraphShiftActivity withStartDateTime(OffsetDateTime startDateTime) {
        this.startDateTime = startDateTime;
        return this;
    }

    public MicrosoftGraphScheduleEntityTheme theme() {
        return this.theme;
    }

    public MicrosoftGraphShiftActivity withTheme(MicrosoftGraphScheduleEntityTheme theme) {
        this.theme = theme;
        return this;
    }

    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    public MicrosoftGraphShiftActivity withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("code", this.code);
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("endDateTime", this.endDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.endDateTime));
        jsonWriter.writeBooleanField("isPaid", this.isPaid);
        jsonWriter.writeStringField("startDateTime", this.startDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startDateTime));
        jsonWriter.writeStringField("theme", this.theme == null ? null : this.theme.toString());
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static MicrosoftGraphShiftActivity fromJson(JsonReader jsonReader) throws IOException {
        return (MicrosoftGraphShiftActivity)jsonReader.readObject(reader -> {
            MicrosoftGraphShiftActivity deserializedMicrosoftGraphShiftActivity = new MicrosoftGraphShiftActivity();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("code".equals(fieldName)) {
                    deserializedMicrosoftGraphShiftActivity.code = reader.getString();
                    continue;
                }
                if ("displayName".equals(fieldName)) {
                    deserializedMicrosoftGraphShiftActivity.displayName = reader.getString();
                    continue;
                }
                if ("endDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphShiftActivity.endDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("isPaid".equals(fieldName)) {
                    deserializedMicrosoftGraphShiftActivity.isPaid = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("startDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphShiftActivity.startDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("theme".equals(fieldName)) {
                    deserializedMicrosoftGraphShiftActivity.theme = MicrosoftGraphScheduleEntityTheme.fromString(reader.getString());
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedMicrosoftGraphShiftActivity.additionalProperties = additionalProperties;
            return deserializedMicrosoftGraphShiftActivity;
        });
    }
}

