/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.authorization.models.DenyAssignmentPermission;
import com.azure.resourcemanager.authorization.models.Principal;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

public final class DenyAssignmentProperties
implements JsonSerializable<DenyAssignmentProperties> {
    private String denyAssignmentName;
    private String description;
    private List<DenyAssignmentPermission> permissions;
    private String scope;
    private Boolean doNotApplyToChildScopes;
    private List<Principal> principals;
    private List<Principal> excludePrincipals;
    private Boolean isSystemProtected;
    private String condition;
    private String conditionVersion;
    private OffsetDateTime createdOn;
    private OffsetDateTime updatedOn;
    private String createdBy;
    private String updatedBy;

    public String denyAssignmentName() {
        return this.denyAssignmentName;
    }

    public DenyAssignmentProperties withDenyAssignmentName(String denyAssignmentName) {
        this.denyAssignmentName = denyAssignmentName;
        return this;
    }

    public String description() {
        return this.description;
    }

    public DenyAssignmentProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    public List<DenyAssignmentPermission> permissions() {
        return this.permissions;
    }

    public DenyAssignmentProperties withPermissions(List<DenyAssignmentPermission> permissions) {
        this.permissions = permissions;
        return this;
    }

    public String scope() {
        return this.scope;
    }

    public DenyAssignmentProperties withScope(String scope) {
        this.scope = scope;
        return this;
    }

    public Boolean doNotApplyToChildScopes() {
        return this.doNotApplyToChildScopes;
    }

    public DenyAssignmentProperties withDoNotApplyToChildScopes(Boolean doNotApplyToChildScopes) {
        this.doNotApplyToChildScopes = doNotApplyToChildScopes;
        return this;
    }

    public List<Principal> principals() {
        return this.principals;
    }

    public DenyAssignmentProperties withPrincipals(List<Principal> principals) {
        this.principals = principals;
        return this;
    }

    public List<Principal> excludePrincipals() {
        return this.excludePrincipals;
    }

    public DenyAssignmentProperties withExcludePrincipals(List<Principal> excludePrincipals) {
        this.excludePrincipals = excludePrincipals;
        return this;
    }

    public Boolean isSystemProtected() {
        return this.isSystemProtected;
    }

    public DenyAssignmentProperties withIsSystemProtected(Boolean isSystemProtected) {
        this.isSystemProtected = isSystemProtected;
        return this;
    }

    public String condition() {
        return this.condition;
    }

    public DenyAssignmentProperties withCondition(String condition) {
        this.condition = condition;
        return this;
    }

    public String conditionVersion() {
        return this.conditionVersion;
    }

    public DenyAssignmentProperties withConditionVersion(String conditionVersion) {
        this.conditionVersion = conditionVersion;
        return this;
    }

    public OffsetDateTime createdOn() {
        return this.createdOn;
    }

    public OffsetDateTime updatedOn() {
        return this.updatedOn;
    }

    public String createdBy() {
        return this.createdBy;
    }

    public String updatedBy() {
        return this.updatedBy;
    }

    public void validate() {
        if (this.permissions() != null) {
            this.permissions().forEach(e -> e.validate());
        }
        if (this.principals() != null) {
            this.principals().forEach(e -> e.validate());
        }
        if (this.excludePrincipals() != null) {
            this.excludePrincipals().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("denyAssignmentName", this.denyAssignmentName);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeArrayField("permissions", this.permissions, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("scope", this.scope);
        jsonWriter.writeBooleanField("doNotApplyToChildScopes", this.doNotApplyToChildScopes);
        jsonWriter.writeArrayField("principals", this.principals, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("excludePrincipals", this.excludePrincipals, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeBooleanField("isSystemProtected", this.isSystemProtected);
        jsonWriter.writeStringField("condition", this.condition);
        jsonWriter.writeStringField("conditionVersion", this.conditionVersion);
        return jsonWriter.writeEndObject();
    }

    public static DenyAssignmentProperties fromJson(JsonReader jsonReader) throws IOException {
        return (DenyAssignmentProperties)jsonReader.readObject(reader -> {
            DenyAssignmentProperties deserializedDenyAssignmentProperties = new DenyAssignmentProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("denyAssignmentName".equals(fieldName)) {
                    deserializedDenyAssignmentProperties.denyAssignmentName = reader.getString();
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedDenyAssignmentProperties.description = reader.getString();
                    continue;
                }
                if ("permissions".equals(fieldName)) {
                    List permissions;
                    deserializedDenyAssignmentProperties.permissions = permissions = reader.readArray(reader1 -> DenyAssignmentPermission.fromJson(reader1));
                    continue;
                }
                if ("scope".equals(fieldName)) {
                    deserializedDenyAssignmentProperties.scope = reader.getString();
                    continue;
                }
                if ("doNotApplyToChildScopes".equals(fieldName)) {
                    deserializedDenyAssignmentProperties.doNotApplyToChildScopes = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("principals".equals(fieldName)) {
                    List principals;
                    deserializedDenyAssignmentProperties.principals = principals = reader.readArray(reader1 -> Principal.fromJson(reader1));
                    continue;
                }
                if ("excludePrincipals".equals(fieldName)) {
                    List excludePrincipals;
                    deserializedDenyAssignmentProperties.excludePrincipals = excludePrincipals = reader.readArray(reader1 -> Principal.fromJson(reader1));
                    continue;
                }
                if ("isSystemProtected".equals(fieldName)) {
                    deserializedDenyAssignmentProperties.isSystemProtected = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("condition".equals(fieldName)) {
                    deserializedDenyAssignmentProperties.condition = reader.getString();
                    continue;
                }
                if ("conditionVersion".equals(fieldName)) {
                    deserializedDenyAssignmentProperties.conditionVersion = reader.getString();
                    continue;
                }
                if ("createdOn".equals(fieldName)) {
                    deserializedDenyAssignmentProperties.createdOn = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("updatedOn".equals(fieldName)) {
                    deserializedDenyAssignmentProperties.updatedOn = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("createdBy".equals(fieldName)) {
                    deserializedDenyAssignmentProperties.createdBy = reader.getString();
                    continue;
                }
                if ("updatedBy".equals(fieldName)) {
                    deserializedDenyAssignmentProperties.updatedBy = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDenyAssignmentProperties;
        });
    }
}

