/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.implementation;

import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.resourcemanager.authorization.AuthorizationManager;
import com.azure.resourcemanager.authorization.fluent.RoleAssignmentsClient;
import com.azure.resourcemanager.authorization.fluent.models.RoleAssignmentInner;
import com.azure.resourcemanager.authorization.implementation.PercentEscaper;
import com.azure.resourcemanager.authorization.implementation.RoleAssignmentImpl;
import com.azure.resourcemanager.authorization.models.RoleAssignment;
import com.azure.resourcemanager.authorization.models.RoleAssignments;
import com.azure.resourcemanager.authorization.models.ServicePrincipal;
import com.azure.resourcemanager.resources.fluentcore.arm.collection.implementation.CreatableResourcesImpl;
import com.azure.resourcemanager.resources.fluentcore.utils.PagedConverter;
import java.util.Objects;
import reactor.core.publisher.Mono;

public class RoleAssignmentsImpl
extends CreatableResourcesImpl<RoleAssignment, RoleAssignmentImpl, RoleAssignmentInner>
implements RoleAssignments {
    private final AuthorizationManager manager;

    public RoleAssignmentsImpl(AuthorizationManager manager) {
        this.manager = manager;
    }

    protected RoleAssignmentImpl wrapModel(RoleAssignmentInner roleAssignmentInner) {
        if (roleAssignmentInner == null) {
            return null;
        }
        return new RoleAssignmentImpl(roleAssignmentInner.name(), roleAssignmentInner, this.manager());
    }

    public RoleAssignmentImpl getById(String objectId) {
        return (RoleAssignmentImpl)this.getByIdAsync(objectId).block();
    }

    public Mono<RoleAssignment> getByIdAsync(String id) {
        return this.inner().getByIdAsync(id).map(roleAssignmentInner -> new RoleAssignmentImpl(roleAssignmentInner.name(), (RoleAssignmentInner)((Object)roleAssignmentInner), this.manager()));
    }

    @Override
    public RoleAssignmentImpl getByScope(String scope, String name) {
        return (RoleAssignmentImpl)this.getByScopeAsync(scope, name).block();
    }

    @Override
    public PagedFlux<RoleAssignment> listByScopeAsync(String scope) {
        return PagedConverter.mapPage(this.inner().listForScopeAsync(scope), this::wrapModel);
    }

    @Override
    public PagedIterable<RoleAssignment> listByScope(String scope) {
        return this.wrapList(this.inner().listForScope(scope));
    }

    @Override
    public PagedFlux<RoleAssignment> listByServicePrincipalAsync(ServicePrincipal servicePrincipal) {
        return this.listByServicePrincipalAsync(Objects.requireNonNull(servicePrincipal).id());
    }

    @Override
    public PagedIterable<RoleAssignment> listByServicePrincipal(ServicePrincipal servicePrincipal) {
        return new PagedIterable(this.listByServicePrincipalAsync(servicePrincipal));
    }

    @Override
    public PagedFlux<RoleAssignment> listByServicePrincipalAsync(String principalId) {
        PercentEscaper percentEscaper = new PercentEscaper("-._~/?", false);
        String filterStr = percentEscaper.escape(String.format("principalId eq '%s'", Objects.requireNonNull(principalId)));
        return PagedConverter.mapPage(this.inner().listAsync(filterStr, null), this::wrapModel);
    }

    @Override
    public PagedIterable<RoleAssignment> listByServicePrincipal(String principalId) {
        return new PagedIterable(this.listByServicePrincipalAsync(principalId));
    }

    @Override
    public Mono<RoleAssignment> getByScopeAsync(String scope, String name) {
        return this.inner().getAsync(scope, name).map(roleAssignmentInner -> new RoleAssignmentImpl(roleAssignmentInner.name(), (RoleAssignmentInner)((Object)roleAssignmentInner), this.manager()));
    }

    protected RoleAssignmentImpl wrapModel(String name) {
        return new RoleAssignmentImpl(name, new RoleAssignmentInner(), this.manager());
    }

    public Mono<Void> deleteByIdAsync(String id) {
        return this.inner().deleteByIdAsync(id).then();
    }

    public RoleAssignmentImpl define(String name) {
        return this.wrapModel(name);
    }

    public AuthorizationManager manager() {
        return this.manager;
    }

    public RoleAssignmentsClient inner() {
        return this.manager().roleServiceClient().getRoleAssignments();
    }
}

