/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.authorization.models.ExpandedProperties;
import com.azure.resourcemanager.authorization.models.PrincipalType;
import com.azure.resourcemanager.authorization.models.RequestType;
import com.azure.resourcemanager.authorization.models.RoleAssignmentScheduleRequestPropertiesScheduleInfo;
import com.azure.resourcemanager.authorization.models.RoleAssignmentScheduleRequestPropertiesTicketInfo;
import com.azure.resourcemanager.authorization.models.Status;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class RoleAssignmentScheduleRequestProperties
implements JsonSerializable<RoleAssignmentScheduleRequestProperties> {
    private String scope;
    private String roleDefinitionId;
    private String principalId;
    private PrincipalType principalType;
    private RequestType requestType;
    private Status status;
    private String approvalId;
    private String targetRoleAssignmentScheduleId;
    private String targetRoleAssignmentScheduleInstanceId;
    private RoleAssignmentScheduleRequestPropertiesScheduleInfo scheduleInfo;
    private String linkedRoleEligibilityScheduleId;
    private String justification;
    private RoleAssignmentScheduleRequestPropertiesTicketInfo ticketInfo;
    private String condition;
    private String conditionVersion;
    private OffsetDateTime createdOn;
    private String requestorId;
    private ExpandedProperties expandedProperties;
    private static final ClientLogger LOGGER = new ClientLogger(RoleAssignmentScheduleRequestProperties.class);

    public String scope() {
        return this.scope;
    }

    public String roleDefinitionId() {
        return this.roleDefinitionId;
    }

    public RoleAssignmentScheduleRequestProperties withRoleDefinitionId(String roleDefinitionId) {
        this.roleDefinitionId = roleDefinitionId;
        return this;
    }

    public String principalId() {
        return this.principalId;
    }

    public RoleAssignmentScheduleRequestProperties withPrincipalId(String principalId) {
        this.principalId = principalId;
        return this;
    }

    public PrincipalType principalType() {
        return this.principalType;
    }

    public RequestType requestType() {
        return this.requestType;
    }

    public RoleAssignmentScheduleRequestProperties withRequestType(RequestType requestType) {
        this.requestType = requestType;
        return this;
    }

    public Status status() {
        return this.status;
    }

    public String approvalId() {
        return this.approvalId;
    }

    public String targetRoleAssignmentScheduleId() {
        return this.targetRoleAssignmentScheduleId;
    }

    public RoleAssignmentScheduleRequestProperties withTargetRoleAssignmentScheduleId(String targetRoleAssignmentScheduleId) {
        this.targetRoleAssignmentScheduleId = targetRoleAssignmentScheduleId;
        return this;
    }

    public String targetRoleAssignmentScheduleInstanceId() {
        return this.targetRoleAssignmentScheduleInstanceId;
    }

    public RoleAssignmentScheduleRequestProperties withTargetRoleAssignmentScheduleInstanceId(String targetRoleAssignmentScheduleInstanceId) {
        this.targetRoleAssignmentScheduleInstanceId = targetRoleAssignmentScheduleInstanceId;
        return this;
    }

    public RoleAssignmentScheduleRequestPropertiesScheduleInfo scheduleInfo() {
        return this.scheduleInfo;
    }

    public RoleAssignmentScheduleRequestProperties withScheduleInfo(RoleAssignmentScheduleRequestPropertiesScheduleInfo scheduleInfo) {
        this.scheduleInfo = scheduleInfo;
        return this;
    }

    public String linkedRoleEligibilityScheduleId() {
        return this.linkedRoleEligibilityScheduleId;
    }

    public RoleAssignmentScheduleRequestProperties withLinkedRoleEligibilityScheduleId(String linkedRoleEligibilityScheduleId) {
        this.linkedRoleEligibilityScheduleId = linkedRoleEligibilityScheduleId;
        return this;
    }

    public String justification() {
        return this.justification;
    }

    public RoleAssignmentScheduleRequestProperties withJustification(String justification) {
        this.justification = justification;
        return this;
    }

    public RoleAssignmentScheduleRequestPropertiesTicketInfo ticketInfo() {
        return this.ticketInfo;
    }

    public RoleAssignmentScheduleRequestProperties withTicketInfo(RoleAssignmentScheduleRequestPropertiesTicketInfo ticketInfo) {
        this.ticketInfo = ticketInfo;
        return this;
    }

    public String condition() {
        return this.condition;
    }

    public RoleAssignmentScheduleRequestProperties withCondition(String condition) {
        this.condition = condition;
        return this;
    }

    public String conditionVersion() {
        return this.conditionVersion;
    }

    public RoleAssignmentScheduleRequestProperties withConditionVersion(String conditionVersion) {
        this.conditionVersion = conditionVersion;
        return this;
    }

    public OffsetDateTime createdOn() {
        return this.createdOn;
    }

    public String requestorId() {
        return this.requestorId;
    }

    public ExpandedProperties expandedProperties() {
        return this.expandedProperties;
    }

    public void validate() {
        if (this.roleDefinitionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property roleDefinitionId in model RoleAssignmentScheduleRequestProperties"));
        }
        if (this.principalId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property principalId in model RoleAssignmentScheduleRequestProperties"));
        }
        if (this.requestType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property requestType in model RoleAssignmentScheduleRequestProperties"));
        }
        if (this.scheduleInfo() != null) {
            this.scheduleInfo().validate();
        }
        if (this.ticketInfo() != null) {
            this.ticketInfo().validate();
        }
        if (this.expandedProperties() != null) {
            this.expandedProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("roleDefinitionId", this.roleDefinitionId);
        jsonWriter.writeStringField("principalId", this.principalId);
        jsonWriter.writeStringField("requestType", this.requestType == null ? null : this.requestType.toString());
        jsonWriter.writeStringField("targetRoleAssignmentScheduleId", this.targetRoleAssignmentScheduleId);
        jsonWriter.writeStringField("targetRoleAssignmentScheduleInstanceId", this.targetRoleAssignmentScheduleInstanceId);
        jsonWriter.writeJsonField("scheduleInfo", (JsonSerializable)this.scheduleInfo);
        jsonWriter.writeStringField("linkedRoleEligibilityScheduleId", this.linkedRoleEligibilityScheduleId);
        jsonWriter.writeStringField("justification", this.justification);
        jsonWriter.writeJsonField("ticketInfo", (JsonSerializable)this.ticketInfo);
        jsonWriter.writeStringField("condition", this.condition);
        jsonWriter.writeStringField("conditionVersion", this.conditionVersion);
        return jsonWriter.writeEndObject();
    }

    public static RoleAssignmentScheduleRequestProperties fromJson(JsonReader jsonReader) throws IOException {
        return (RoleAssignmentScheduleRequestProperties)jsonReader.readObject(reader -> {
            RoleAssignmentScheduleRequestProperties deserializedRoleAssignmentScheduleRequestProperties = new RoleAssignmentScheduleRequestProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("roleDefinitionId".equals(fieldName)) {
                    deserializedRoleAssignmentScheduleRequestProperties.roleDefinitionId = reader.getString();
                    continue;
                }
                if ("principalId".equals(fieldName)) {
                    deserializedRoleAssignmentScheduleRequestProperties.principalId = reader.getString();
                    continue;
                }
                if ("requestType".equals(fieldName)) {
                    deserializedRoleAssignmentScheduleRequestProperties.requestType = RequestType.fromString(reader.getString());
                    continue;
                }
                if ("scope".equals(fieldName)) {
                    deserializedRoleAssignmentScheduleRequestProperties.scope = reader.getString();
                    continue;
                }
                if ("principalType".equals(fieldName)) {
                    deserializedRoleAssignmentScheduleRequestProperties.principalType = PrincipalType.fromString(reader.getString());
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedRoleAssignmentScheduleRequestProperties.status = Status.fromString(reader.getString());
                    continue;
                }
                if ("approvalId".equals(fieldName)) {
                    deserializedRoleAssignmentScheduleRequestProperties.approvalId = reader.getString();
                    continue;
                }
                if ("targetRoleAssignmentScheduleId".equals(fieldName)) {
                    deserializedRoleAssignmentScheduleRequestProperties.targetRoleAssignmentScheduleId = reader.getString();
                    continue;
                }
                if ("targetRoleAssignmentScheduleInstanceId".equals(fieldName)) {
                    deserializedRoleAssignmentScheduleRequestProperties.targetRoleAssignmentScheduleInstanceId = reader.getString();
                    continue;
                }
                if ("scheduleInfo".equals(fieldName)) {
                    deserializedRoleAssignmentScheduleRequestProperties.scheduleInfo = RoleAssignmentScheduleRequestPropertiesScheduleInfo.fromJson(reader);
                    continue;
                }
                if ("linkedRoleEligibilityScheduleId".equals(fieldName)) {
                    deserializedRoleAssignmentScheduleRequestProperties.linkedRoleEligibilityScheduleId = reader.getString();
                    continue;
                }
                if ("justification".equals(fieldName)) {
                    deserializedRoleAssignmentScheduleRequestProperties.justification = reader.getString();
                    continue;
                }
                if ("ticketInfo".equals(fieldName)) {
                    deserializedRoleAssignmentScheduleRequestProperties.ticketInfo = RoleAssignmentScheduleRequestPropertiesTicketInfo.fromJson(reader);
                    continue;
                }
                if ("condition".equals(fieldName)) {
                    deserializedRoleAssignmentScheduleRequestProperties.condition = reader.getString();
                    continue;
                }
                if ("conditionVersion".equals(fieldName)) {
                    deserializedRoleAssignmentScheduleRequestProperties.conditionVersion = reader.getString();
                    continue;
                }
                if ("createdOn".equals(fieldName)) {
                    deserializedRoleAssignmentScheduleRequestProperties.createdOn = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("requestorId".equals(fieldName)) {
                    deserializedRoleAssignmentScheduleRequestProperties.requestorId = reader.getString();
                    continue;
                }
                if ("expandedProperties".equals(fieldName)) {
                    deserializedRoleAssignmentScheduleRequestProperties.expandedProperties = ExpandedProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRoleAssignmentScheduleRequestProperties;
        });
    }
}

