/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphAttachment;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphAttendee;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphCalendar;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphDateTimeZone;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphEventType;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphExtension;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphFreeBusyStatus;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphImportance;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphItemBody;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphLocation;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphMultiValueLegacyExtendedProperty;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphOnlineMeetingInfo;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphOnlineMeetingProviderType;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphOutlookItem;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphPatternedRecurrence;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphRecipient;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphResponseStatus;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphSensitivity;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphSingleValueLegacyExtendedProperty;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class MicrosoftGraphEvent
extends MicrosoftGraphOutlookItem {
    private Boolean allowNewTimeProposals;
    private List<MicrosoftGraphAttendee> attendees;
    private MicrosoftGraphItemBody body;
    private String bodyPreview;
    private MicrosoftGraphDateTimeZone end;
    private Boolean hasAttachments;
    private Boolean hideAttendees;
    private String iCalUId;
    private MicrosoftGraphImportance importance;
    private Boolean isAllDay;
    private Boolean isCancelled;
    private Boolean isDraft;
    private Boolean isOnlineMeeting;
    private Boolean isOrganizer;
    private Boolean isReminderOn;
    private MicrosoftGraphLocation location;
    private List<MicrosoftGraphLocation> locations;
    private MicrosoftGraphOnlineMeetingInfo onlineMeeting;
    private MicrosoftGraphOnlineMeetingProviderType onlineMeetingProvider;
    private String onlineMeetingUrl;
    private MicrosoftGraphRecipient organizer;
    private String originalEndTimeZone;
    private OffsetDateTime originalStart;
    private String originalStartTimeZone;
    private MicrosoftGraphPatternedRecurrence recurrence;
    private Integer reminderMinutesBeforeStart;
    private Boolean responseRequested;
    private MicrosoftGraphResponseStatus responseStatus;
    private MicrosoftGraphSensitivity sensitivity;
    private String seriesMasterId;
    private MicrosoftGraphFreeBusyStatus showAs;
    private MicrosoftGraphDateTimeZone start;
    private String subject;
    private String transactionId;
    private MicrosoftGraphEventType type;
    private String webLink;
    private List<MicrosoftGraphAttachment> attachments;
    private MicrosoftGraphCalendar calendar;
    private List<MicrosoftGraphExtension> extensions;
    private List<MicrosoftGraphEvent> instances;
    private List<MicrosoftGraphMultiValueLegacyExtendedProperty> multiValueExtendedProperties;
    private List<MicrosoftGraphSingleValueLegacyExtendedProperty> singleValueExtendedProperties;
    private Map<String, Object> additionalProperties;

    public Boolean allowNewTimeProposals() {
        return this.allowNewTimeProposals;
    }

    public MicrosoftGraphEvent withAllowNewTimeProposals(Boolean allowNewTimeProposals) {
        this.allowNewTimeProposals = allowNewTimeProposals;
        return this;
    }

    public List<MicrosoftGraphAttendee> attendees() {
        return this.attendees;
    }

    public MicrosoftGraphEvent withAttendees(List<MicrosoftGraphAttendee> attendees) {
        this.attendees = attendees;
        return this;
    }

    public MicrosoftGraphItemBody body() {
        return this.body;
    }

    public MicrosoftGraphEvent withBody(MicrosoftGraphItemBody body) {
        this.body = body;
        return this;
    }

    public String bodyPreview() {
        return this.bodyPreview;
    }

    public MicrosoftGraphEvent withBodyPreview(String bodyPreview) {
        this.bodyPreview = bodyPreview;
        return this;
    }

    public MicrosoftGraphDateTimeZone end() {
        return this.end;
    }

    public MicrosoftGraphEvent withEnd(MicrosoftGraphDateTimeZone end) {
        this.end = end;
        return this;
    }

    public Boolean hasAttachments() {
        return this.hasAttachments;
    }

    public MicrosoftGraphEvent withHasAttachments(Boolean hasAttachments) {
        this.hasAttachments = hasAttachments;
        return this;
    }

    public Boolean hideAttendees() {
        return this.hideAttendees;
    }

    public MicrosoftGraphEvent withHideAttendees(Boolean hideAttendees) {
        this.hideAttendees = hideAttendees;
        return this;
    }

    public String iCalUId() {
        return this.iCalUId;
    }

    public MicrosoftGraphEvent withICalUId(String iCalUId) {
        this.iCalUId = iCalUId;
        return this;
    }

    public MicrosoftGraphImportance importance() {
        return this.importance;
    }

    public MicrosoftGraphEvent withImportance(MicrosoftGraphImportance importance) {
        this.importance = importance;
        return this;
    }

    public Boolean isAllDay() {
        return this.isAllDay;
    }

    public MicrosoftGraphEvent withIsAllDay(Boolean isAllDay) {
        this.isAllDay = isAllDay;
        return this;
    }

    public Boolean isCancelled() {
        return this.isCancelled;
    }

    public MicrosoftGraphEvent withIsCancelled(Boolean isCancelled) {
        this.isCancelled = isCancelled;
        return this;
    }

    public Boolean isDraft() {
        return this.isDraft;
    }

    public MicrosoftGraphEvent withIsDraft(Boolean isDraft) {
        this.isDraft = isDraft;
        return this;
    }

    public Boolean isOnlineMeeting() {
        return this.isOnlineMeeting;
    }

    public MicrosoftGraphEvent withIsOnlineMeeting(Boolean isOnlineMeeting) {
        this.isOnlineMeeting = isOnlineMeeting;
        return this;
    }

    public Boolean isOrganizer() {
        return this.isOrganizer;
    }

    public MicrosoftGraphEvent withIsOrganizer(Boolean isOrganizer) {
        this.isOrganizer = isOrganizer;
        return this;
    }

    public Boolean isReminderOn() {
        return this.isReminderOn;
    }

    public MicrosoftGraphEvent withIsReminderOn(Boolean isReminderOn) {
        this.isReminderOn = isReminderOn;
        return this;
    }

    public MicrosoftGraphLocation location() {
        return this.location;
    }

    public MicrosoftGraphEvent withLocation(MicrosoftGraphLocation location) {
        this.location = location;
        return this;
    }

    public List<MicrosoftGraphLocation> locations() {
        return this.locations;
    }

    public MicrosoftGraphEvent withLocations(List<MicrosoftGraphLocation> locations) {
        this.locations = locations;
        return this;
    }

    public MicrosoftGraphOnlineMeetingInfo onlineMeeting() {
        return this.onlineMeeting;
    }

    public MicrosoftGraphEvent withOnlineMeeting(MicrosoftGraphOnlineMeetingInfo onlineMeeting) {
        this.onlineMeeting = onlineMeeting;
        return this;
    }

    public MicrosoftGraphOnlineMeetingProviderType onlineMeetingProvider() {
        return this.onlineMeetingProvider;
    }

    public MicrosoftGraphEvent withOnlineMeetingProvider(MicrosoftGraphOnlineMeetingProviderType onlineMeetingProvider) {
        this.onlineMeetingProvider = onlineMeetingProvider;
        return this;
    }

    public String onlineMeetingUrl() {
        return this.onlineMeetingUrl;
    }

    public MicrosoftGraphEvent withOnlineMeetingUrl(String onlineMeetingUrl) {
        this.onlineMeetingUrl = onlineMeetingUrl;
        return this;
    }

    public MicrosoftGraphRecipient organizer() {
        return this.organizer;
    }

    public MicrosoftGraphEvent withOrganizer(MicrosoftGraphRecipient organizer) {
        this.organizer = organizer;
        return this;
    }

    public String originalEndTimeZone() {
        return this.originalEndTimeZone;
    }

    public MicrosoftGraphEvent withOriginalEndTimeZone(String originalEndTimeZone) {
        this.originalEndTimeZone = originalEndTimeZone;
        return this;
    }

    public OffsetDateTime originalStart() {
        return this.originalStart;
    }

    public MicrosoftGraphEvent withOriginalStart(OffsetDateTime originalStart) {
        this.originalStart = originalStart;
        return this;
    }

    public String originalStartTimeZone() {
        return this.originalStartTimeZone;
    }

    public MicrosoftGraphEvent withOriginalStartTimeZone(String originalStartTimeZone) {
        this.originalStartTimeZone = originalStartTimeZone;
        return this;
    }

    public MicrosoftGraphPatternedRecurrence recurrence() {
        return this.recurrence;
    }

    public MicrosoftGraphEvent withRecurrence(MicrosoftGraphPatternedRecurrence recurrence) {
        this.recurrence = recurrence;
        return this;
    }

    public Integer reminderMinutesBeforeStart() {
        return this.reminderMinutesBeforeStart;
    }

    public MicrosoftGraphEvent withReminderMinutesBeforeStart(Integer reminderMinutesBeforeStart) {
        this.reminderMinutesBeforeStart = reminderMinutesBeforeStart;
        return this;
    }

    public Boolean responseRequested() {
        return this.responseRequested;
    }

    public MicrosoftGraphEvent withResponseRequested(Boolean responseRequested) {
        this.responseRequested = responseRequested;
        return this;
    }

    public MicrosoftGraphResponseStatus responseStatus() {
        return this.responseStatus;
    }

    public MicrosoftGraphEvent withResponseStatus(MicrosoftGraphResponseStatus responseStatus) {
        this.responseStatus = responseStatus;
        return this;
    }

    public MicrosoftGraphSensitivity sensitivity() {
        return this.sensitivity;
    }

    public MicrosoftGraphEvent withSensitivity(MicrosoftGraphSensitivity sensitivity) {
        this.sensitivity = sensitivity;
        return this;
    }

    public String seriesMasterId() {
        return this.seriesMasterId;
    }

    public MicrosoftGraphEvent withSeriesMasterId(String seriesMasterId) {
        this.seriesMasterId = seriesMasterId;
        return this;
    }

    public MicrosoftGraphFreeBusyStatus showAs() {
        return this.showAs;
    }

    public MicrosoftGraphEvent withShowAs(MicrosoftGraphFreeBusyStatus showAs) {
        this.showAs = showAs;
        return this;
    }

    public MicrosoftGraphDateTimeZone start() {
        return this.start;
    }

    public MicrosoftGraphEvent withStart(MicrosoftGraphDateTimeZone start) {
        this.start = start;
        return this;
    }

    public String subject() {
        return this.subject;
    }

    public MicrosoftGraphEvent withSubject(String subject) {
        this.subject = subject;
        return this;
    }

    public String transactionId() {
        return this.transactionId;
    }

    public MicrosoftGraphEvent withTransactionId(String transactionId) {
        this.transactionId = transactionId;
        return this;
    }

    public MicrosoftGraphEventType type() {
        return this.type;
    }

    public MicrosoftGraphEvent withType(MicrosoftGraphEventType type) {
        this.type = type;
        return this;
    }

    public String webLink() {
        return this.webLink;
    }

    public MicrosoftGraphEvent withWebLink(String webLink) {
        this.webLink = webLink;
        return this;
    }

    public List<MicrosoftGraphAttachment> attachments() {
        return this.attachments;
    }

    public MicrosoftGraphEvent withAttachments(List<MicrosoftGraphAttachment> attachments) {
        this.attachments = attachments;
        return this;
    }

    public MicrosoftGraphCalendar calendar() {
        return this.calendar;
    }

    public MicrosoftGraphEvent withCalendar(MicrosoftGraphCalendar calendar) {
        this.calendar = calendar;
        return this;
    }

    public List<MicrosoftGraphExtension> extensions() {
        return this.extensions;
    }

    public MicrosoftGraphEvent withExtensions(List<MicrosoftGraphExtension> extensions) {
        this.extensions = extensions;
        return this;
    }

    public List<MicrosoftGraphEvent> instances() {
        return this.instances;
    }

    public MicrosoftGraphEvent withInstances(List<MicrosoftGraphEvent> instances) {
        this.instances = instances;
        return this;
    }

    public List<MicrosoftGraphMultiValueLegacyExtendedProperty> multiValueExtendedProperties() {
        return this.multiValueExtendedProperties;
    }

    public MicrosoftGraphEvent withMultiValueExtendedProperties(List<MicrosoftGraphMultiValueLegacyExtendedProperty> multiValueExtendedProperties) {
        this.multiValueExtendedProperties = multiValueExtendedProperties;
        return this;
    }

    public List<MicrosoftGraphSingleValueLegacyExtendedProperty> singleValueExtendedProperties() {
        return this.singleValueExtendedProperties;
    }

    public MicrosoftGraphEvent withSingleValueExtendedProperties(List<MicrosoftGraphSingleValueLegacyExtendedProperty> singleValueExtendedProperties) {
        this.singleValueExtendedProperties = singleValueExtendedProperties;
        return this;
    }

    @Override
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public MicrosoftGraphEvent withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @Override
    public MicrosoftGraphEvent withCategories(List<String> categories) {
        super.withCategories(categories);
        return this;
    }

    @Override
    public MicrosoftGraphEvent withChangeKey(String changeKey) {
        super.withChangeKey(changeKey);
        return this;
    }

    @Override
    public MicrosoftGraphEvent withCreatedDateTime(OffsetDateTime createdDateTime) {
        super.withCreatedDateTime(createdDateTime);
        return this;
    }

    @Override
    public MicrosoftGraphEvent withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        super.withLastModifiedDateTime(lastModifiedDateTime);
        return this;
    }

    @Override
    public MicrosoftGraphEvent withId(String id) {
        super.withId(id);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.attendees() != null) {
            this.attendees().forEach(e -> e.validate());
        }
        if (this.body() != null) {
            this.body().validate();
        }
        if (this.end() != null) {
            this.end().validate();
        }
        if (this.location() != null) {
            this.location().validate();
        }
        if (this.locations() != null) {
            this.locations().forEach(e -> e.validate());
        }
        if (this.onlineMeeting() != null) {
            this.onlineMeeting().validate();
        }
        if (this.organizer() != null) {
            this.organizer().validate();
        }
        if (this.recurrence() != null) {
            this.recurrence().validate();
        }
        if (this.responseStatus() != null) {
            this.responseStatus().validate();
        }
        if (this.start() != null) {
            this.start().validate();
        }
        if (this.attachments() != null) {
            this.attachments().forEach(e -> e.validate());
        }
        if (this.calendar() != null) {
            this.calendar().validate();
        }
        if (this.extensions() != null) {
            this.extensions().forEach(e -> e.validate());
        }
        if (this.instances() != null) {
            this.instances().forEach(e -> e.validate());
        }
        if (this.multiValueExtendedProperties() != null) {
            this.multiValueExtendedProperties().forEach(e -> e.validate());
        }
        if (this.singleValueExtendedProperties() != null) {
            this.singleValueExtendedProperties().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeArrayField("categories", this.categories(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("changeKey", this.changeKey());
        jsonWriter.writeStringField("createdDateTime", this.createdDateTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.createdDateTime()));
        jsonWriter.writeStringField("lastModifiedDateTime", this.lastModifiedDateTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastModifiedDateTime()));
        jsonWriter.writeBooleanField("allowNewTimeProposals", this.allowNewTimeProposals);
        jsonWriter.writeArrayField("attendees", this.attendees, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("body", (JsonSerializable)this.body);
        jsonWriter.writeStringField("bodyPreview", this.bodyPreview);
        jsonWriter.writeJsonField("end", (JsonSerializable)this.end);
        jsonWriter.writeBooleanField("hasAttachments", this.hasAttachments);
        jsonWriter.writeBooleanField("hideAttendees", this.hideAttendees);
        jsonWriter.writeStringField("iCalUId", this.iCalUId);
        jsonWriter.writeStringField("importance", this.importance == null ? null : this.importance.toString());
        jsonWriter.writeBooleanField("isAllDay", this.isAllDay);
        jsonWriter.writeBooleanField("isCancelled", this.isCancelled);
        jsonWriter.writeBooleanField("isDraft", this.isDraft);
        jsonWriter.writeBooleanField("isOnlineMeeting", this.isOnlineMeeting);
        jsonWriter.writeBooleanField("isOrganizer", this.isOrganizer);
        jsonWriter.writeBooleanField("isReminderOn", this.isReminderOn);
        jsonWriter.writeJsonField("location", (JsonSerializable)this.location);
        jsonWriter.writeArrayField("locations", this.locations, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("onlineMeeting", (JsonSerializable)this.onlineMeeting);
        jsonWriter.writeStringField("onlineMeetingProvider", this.onlineMeetingProvider == null ? null : this.onlineMeetingProvider.toString());
        jsonWriter.writeStringField("onlineMeetingUrl", this.onlineMeetingUrl);
        jsonWriter.writeJsonField("organizer", (JsonSerializable)this.organizer);
        jsonWriter.writeStringField("originalEndTimeZone", this.originalEndTimeZone);
        jsonWriter.writeStringField("originalStart", this.originalStart == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.originalStart));
        jsonWriter.writeStringField("originalStartTimeZone", this.originalStartTimeZone);
        jsonWriter.writeJsonField("recurrence", (JsonSerializable)this.recurrence);
        jsonWriter.writeNumberField("reminderMinutesBeforeStart", (Number)this.reminderMinutesBeforeStart);
        jsonWriter.writeBooleanField("responseRequested", this.responseRequested);
        jsonWriter.writeJsonField("responseStatus", (JsonSerializable)this.responseStatus);
        jsonWriter.writeStringField("sensitivity", this.sensitivity == null ? null : this.sensitivity.toString());
        jsonWriter.writeStringField("seriesMasterId", this.seriesMasterId);
        jsonWriter.writeStringField("showAs", this.showAs == null ? null : this.showAs.toString());
        jsonWriter.writeJsonField("start", (JsonSerializable)this.start);
        jsonWriter.writeStringField("subject", this.subject);
        jsonWriter.writeStringField("transactionId", this.transactionId);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeStringField("webLink", this.webLink);
        jsonWriter.writeArrayField("attachments", this.attachments, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("calendar", (JsonSerializable)this.calendar);
        jsonWriter.writeArrayField("extensions", this.extensions, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("instances", this.instances, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("multiValueExtendedProperties", this.multiValueExtendedProperties, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("singleValueExtendedProperties", this.singleValueExtendedProperties, (writer, element) -> writer.writeJson((JsonSerializable)element));
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static MicrosoftGraphEvent fromJson(JsonReader jsonReader) throws IOException {
        return (MicrosoftGraphEvent)jsonReader.readObject(reader -> {
            MicrosoftGraphEvent deserializedMicrosoftGraphEvent = new MicrosoftGraphEvent();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphEvent.withId(reader.getString());
                    continue;
                }
                if ("categories".equals(fieldName)) {
                    List categories = reader.readArray(reader1 -> reader1.getString());
                    deserializedMicrosoftGraphEvent.withCategories(categories);
                    continue;
                }
                if ("changeKey".equals(fieldName)) {
                    deserializedMicrosoftGraphEvent.withChangeKey(reader.getString());
                    continue;
                }
                if ("createdDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphEvent.withCreatedDateTime((OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString())));
                    continue;
                }
                if ("lastModifiedDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphEvent.withLastModifiedDateTime((OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString())));
                    continue;
                }
                if ("allowNewTimeProposals".equals(fieldName)) {
                    deserializedMicrosoftGraphEvent.allowNewTimeProposals = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("attendees".equals(fieldName)) {
                    List attendees;
                    deserializedMicrosoftGraphEvent.attendees = attendees = reader.readArray(reader1 -> MicrosoftGraphAttendee.fromJson(reader1));
                    continue;
                }
                if ("body".equals(fieldName)) {
                    deserializedMicrosoftGraphEvent.body = MicrosoftGraphItemBody.fromJson(reader);
                    continue;
                }
                if ("bodyPreview".equals(fieldName)) {
                    deserializedMicrosoftGraphEvent.bodyPreview = reader.getString();
                    continue;
                }
                if ("end".equals(fieldName)) {
                    deserializedMicrosoftGraphEvent.end = MicrosoftGraphDateTimeZone.fromJson(reader);
                    continue;
                }
                if ("hasAttachments".equals(fieldName)) {
                    deserializedMicrosoftGraphEvent.hasAttachments = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("hideAttendees".equals(fieldName)) {
                    deserializedMicrosoftGraphEvent.hideAttendees = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("iCalUId".equals(fieldName)) {
                    deserializedMicrosoftGraphEvent.iCalUId = reader.getString();
                    continue;
                }
                if ("importance".equals(fieldName)) {
                    deserializedMicrosoftGraphEvent.importance = MicrosoftGraphImportance.fromString(reader.getString());
                    continue;
                }
                if ("isAllDay".equals(fieldName)) {
                    deserializedMicrosoftGraphEvent.isAllDay = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("isCancelled".equals(fieldName)) {
                    deserializedMicrosoftGraphEvent.isCancelled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("isDraft".equals(fieldName)) {
                    deserializedMicrosoftGraphEvent.isDraft = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("isOnlineMeeting".equals(fieldName)) {
                    deserializedMicrosoftGraphEvent.isOnlineMeeting = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("isOrganizer".equals(fieldName)) {
                    deserializedMicrosoftGraphEvent.isOrganizer = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("isReminderOn".equals(fieldName)) {
                    deserializedMicrosoftGraphEvent.isReminderOn = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedMicrosoftGraphEvent.location = MicrosoftGraphLocation.fromJson(reader);
                    continue;
                }
                if ("locations".equals(fieldName)) {
                    List locations;
                    deserializedMicrosoftGraphEvent.locations = locations = reader.readArray(reader1 -> MicrosoftGraphLocation.fromJson(reader1));
                    continue;
                }
                if ("onlineMeeting".equals(fieldName)) {
                    deserializedMicrosoftGraphEvent.onlineMeeting = MicrosoftGraphOnlineMeetingInfo.fromJson(reader);
                    continue;
                }
                if ("onlineMeetingProvider".equals(fieldName)) {
                    deserializedMicrosoftGraphEvent.onlineMeetingProvider = MicrosoftGraphOnlineMeetingProviderType.fromString(reader.getString());
                    continue;
                }
                if ("onlineMeetingUrl".equals(fieldName)) {
                    deserializedMicrosoftGraphEvent.onlineMeetingUrl = reader.getString();
                    continue;
                }
                if ("organizer".equals(fieldName)) {
                    deserializedMicrosoftGraphEvent.organizer = MicrosoftGraphRecipient.fromJson(reader);
                    continue;
                }
                if ("originalEndTimeZone".equals(fieldName)) {
                    deserializedMicrosoftGraphEvent.originalEndTimeZone = reader.getString();
                    continue;
                }
                if ("originalStart".equals(fieldName)) {
                    deserializedMicrosoftGraphEvent.originalStart = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("originalStartTimeZone".equals(fieldName)) {
                    deserializedMicrosoftGraphEvent.originalStartTimeZone = reader.getString();
                    continue;
                }
                if ("recurrence".equals(fieldName)) {
                    deserializedMicrosoftGraphEvent.recurrence = MicrosoftGraphPatternedRecurrence.fromJson(reader);
                    continue;
                }
                if ("reminderMinutesBeforeStart".equals(fieldName)) {
                    deserializedMicrosoftGraphEvent.reminderMinutesBeforeStart = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("responseRequested".equals(fieldName)) {
                    deserializedMicrosoftGraphEvent.responseRequested = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("responseStatus".equals(fieldName)) {
                    deserializedMicrosoftGraphEvent.responseStatus = MicrosoftGraphResponseStatus.fromJson(reader);
                    continue;
                }
                if ("sensitivity".equals(fieldName)) {
                    deserializedMicrosoftGraphEvent.sensitivity = MicrosoftGraphSensitivity.fromString(reader.getString());
                    continue;
                }
                if ("seriesMasterId".equals(fieldName)) {
                    deserializedMicrosoftGraphEvent.seriesMasterId = reader.getString();
                    continue;
                }
                if ("showAs".equals(fieldName)) {
                    deserializedMicrosoftGraphEvent.showAs = MicrosoftGraphFreeBusyStatus.fromString(reader.getString());
                    continue;
                }
                if ("start".equals(fieldName)) {
                    deserializedMicrosoftGraphEvent.start = MicrosoftGraphDateTimeZone.fromJson(reader);
                    continue;
                }
                if ("subject".equals(fieldName)) {
                    deserializedMicrosoftGraphEvent.subject = reader.getString();
                    continue;
                }
                if ("transactionId".equals(fieldName)) {
                    deserializedMicrosoftGraphEvent.transactionId = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedMicrosoftGraphEvent.type = MicrosoftGraphEventType.fromString(reader.getString());
                    continue;
                }
                if ("webLink".equals(fieldName)) {
                    deserializedMicrosoftGraphEvent.webLink = reader.getString();
                    continue;
                }
                if ("attachments".equals(fieldName)) {
                    List attachments;
                    deserializedMicrosoftGraphEvent.attachments = attachments = reader.readArray(reader1 -> MicrosoftGraphAttachment.fromJson(reader1));
                    continue;
                }
                if ("calendar".equals(fieldName)) {
                    deserializedMicrosoftGraphEvent.calendar = MicrosoftGraphCalendar.fromJson(reader);
                    continue;
                }
                if ("extensions".equals(fieldName)) {
                    List extensions;
                    deserializedMicrosoftGraphEvent.extensions = extensions = reader.readArray(reader1 -> MicrosoftGraphExtension.fromJson(reader1));
                    continue;
                }
                if ("instances".equals(fieldName)) {
                    List instances;
                    deserializedMicrosoftGraphEvent.instances = instances = reader.readArray(reader1 -> MicrosoftGraphEvent.fromJson(reader1));
                    continue;
                }
                if ("multiValueExtendedProperties".equals(fieldName)) {
                    List multiValueExtendedProperties;
                    deserializedMicrosoftGraphEvent.multiValueExtendedProperties = multiValueExtendedProperties = reader.readArray(reader1 -> MicrosoftGraphMultiValueLegacyExtendedProperty.fromJson(reader1));
                    continue;
                }
                if ("singleValueExtendedProperties".equals(fieldName)) {
                    List singleValueExtendedProperties;
                    deserializedMicrosoftGraphEvent.singleValueExtendedProperties = singleValueExtendedProperties = reader.readArray(reader1 -> MicrosoftGraphSingleValueLegacyExtendedProperty.fromJson(reader1));
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedMicrosoftGraphEvent.additionalProperties = additionalProperties;
            return deserializedMicrosoftGraphEvent;
        });
    }
}

