/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.authorization.fluent.GroupsClient;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfDirectoryObject;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfDirectoryObject0;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfLinksOfDirectoryObject;
import com.azure.resourcemanager.authorization.fluent.models.GroupsOrderby;
import com.azure.resourcemanager.authorization.fluent.models.GroupsSelect;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphDirectoryObjectInner;
import com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException;
import com.azure.resourcemanager.authorization.implementation.MicrosoftGraphClientImpl;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

public final class GroupsClientImpl
implements GroupsClient {
    private final GroupsService service;
    private final MicrosoftGraphClientImpl client;

    GroupsClientImpl(MicrosoftGraphClientImpl client) {
        this.service = (GroupsService)RestProxy.create(GroupsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listAcceptedSendersSinglePageAsync(String groupId, Integer top, Integer skip, String search, String filter, Boolean count, List<GroupsOrderby> orderby, List<GroupsSelect> select, List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = orderby == null ? null : orderby.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
        String selectConverted = select == null ? null : select.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
        String expandConverted = expand == null ? null : expand.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
        return FluxUtil.withContext(context -> this.service.listAcceptedSenders(this.client.getEndpoint(), groupId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObject)res.getValue()).value(), ((CollectionOfDirectoryObject)res.getValue()).odataNextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listAcceptedSendersSinglePageAsync(String groupId, Integer top, Integer skip, String search, String filter, Boolean count, List<GroupsOrderby> orderby, List<GroupsSelect> select, List<String> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = orderby == null ? null : orderby.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
        String selectConverted = select == null ? null : select.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
        String expandConverted = expand == null ? null : expand.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
        context = this.client.mergeContext(context);
        return this.service.listAcceptedSenders(this.client.getEndpoint(), groupId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObject)res.getValue()).value(), ((CollectionOfDirectoryObject)res.getValue()).odataNextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphDirectoryObjectInner> listAcceptedSendersAsync(String groupId, Integer top, Integer skip, String search, String filter, Boolean count, List<GroupsOrderby> orderby, List<GroupsSelect> select, List<String> expand) {
        return new PagedFlux(() -> this.listAcceptedSendersSinglePageAsync(groupId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listMoreSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphDirectoryObjectInner> listAcceptedSendersAsync(String groupId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List orderby = null;
        List select = null;
        List expand = null;
        return new PagedFlux(() -> this.listAcceptedSendersSinglePageAsync(groupId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listMoreSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<MicrosoftGraphDirectoryObjectInner> listAcceptedSendersAsync(String groupId, Integer top, Integer skip, String search, String filter, Boolean count, List<GroupsOrderby> orderby, List<GroupsSelect> select, List<String> expand, Context context) {
        return new PagedFlux(() -> this.listAcceptedSendersSinglePageAsync(groupId, top, skip, search, filter, count, orderby, select, expand, context), nextLink -> this.listMoreSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphDirectoryObjectInner> listAcceptedSenders(String groupId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List<GroupsOrderby> orderby = null;
        List<GroupsSelect> select = null;
        List<String> expand = null;
        return new PagedIterable(this.listAcceptedSendersAsync(groupId, top, skip, search, filter, count, orderby, select, expand));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphDirectoryObjectInner> listAcceptedSenders(String groupId, Integer top, Integer skip, String search, String filter, Boolean count, List<GroupsOrderby> orderby, List<GroupsSelect> select, List<String> expand, Context context) {
        return new PagedIterable(this.listAcceptedSendersAsync(groupId, top, skip, search, filter, count, orderby, select, expand, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<MicrosoftGraphDirectoryObjectInner>> createAcceptedSendersWithResponseAsync(String groupId, MicrosoftGraphDirectoryObjectInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createAcceptedSenders(this.client.getEndpoint(), groupId, body, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<MicrosoftGraphDirectoryObjectInner>> createAcceptedSendersWithResponseAsync(String groupId, MicrosoftGraphDirectoryObjectInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createAcceptedSenders(this.client.getEndpoint(), groupId, body, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MicrosoftGraphDirectoryObjectInner> createAcceptedSendersAsync(String groupId, MicrosoftGraphDirectoryObjectInner body) {
        return this.createAcceptedSendersWithResponseAsync(groupId, body).flatMap(res -> Mono.justOrEmpty((Object)((MicrosoftGraphDirectoryObjectInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<MicrosoftGraphDirectoryObjectInner> createAcceptedSendersWithResponse(String groupId, MicrosoftGraphDirectoryObjectInner body, Context context) {
        return (Response)this.createAcceptedSendersWithResponseAsync(groupId, body, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public MicrosoftGraphDirectoryObjectInner createAcceptedSenders(String groupId, MicrosoftGraphDirectoryObjectInner body) {
        return (MicrosoftGraphDirectoryObjectInner)this.createAcceptedSendersWithResponse(groupId, body, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listMembersSinglePageAsync(String groupId, Integer top, Integer skip, String search, String filter, Boolean count, List<GroupsOrderby> orderby, List<GroupsSelect> select, List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = orderby == null ? null : orderby.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
        String selectConverted = select == null ? null : select.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
        String expandConverted = expand == null ? null : expand.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
        return FluxUtil.withContext(context -> this.service.listMembers(this.client.getEndpoint(), groupId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObject0)res.getValue()).value(), ((CollectionOfDirectoryObject0)res.getValue()).odataNextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listMembersSinglePageAsync(String groupId, Integer top, Integer skip, String search, String filter, Boolean count, List<GroupsOrderby> orderby, List<GroupsSelect> select, List<String> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = orderby == null ? null : orderby.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
        String selectConverted = select == null ? null : select.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
        String expandConverted = expand == null ? null : expand.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
        context = this.client.mergeContext(context);
        return this.service.listMembers(this.client.getEndpoint(), groupId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObject0)res.getValue()).value(), ((CollectionOfDirectoryObject0)res.getValue()).odataNextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphDirectoryObjectInner> listMembersAsync(String groupId, Integer top, Integer skip, String search, String filter, Boolean count, List<GroupsOrderby> orderby, List<GroupsSelect> select, List<String> expand) {
        return new PagedFlux(() -> this.listMembersSinglePageAsync(groupId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listMembersNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<MicrosoftGraphDirectoryObjectInner> listMembersAsync(String groupId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List orderby = null;
        List select = null;
        List expand = null;
        return new PagedFlux(() -> this.listMembersSinglePageAsync(groupId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listMembersNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<MicrosoftGraphDirectoryObjectInner> listMembersAsync(String groupId, Integer top, Integer skip, String search, String filter, Boolean count, List<GroupsOrderby> orderby, List<GroupsSelect> select, List<String> expand, Context context) {
        return new PagedFlux(() -> this.listMembersSinglePageAsync(groupId, top, skip, search, filter, count, orderby, select, expand, context), nextLink -> this.listMembersNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphDirectoryObjectInner> listMembers(String groupId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List<GroupsOrderby> orderby = null;
        List<GroupsSelect> select = null;
        List<String> expand = null;
        return new PagedIterable(this.listMembersAsync(groupId, top, skip, search, filter, count, orderby, select, expand));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<MicrosoftGraphDirectoryObjectInner> listMembers(String groupId, Integer top, Integer skip, String search, String filter, Boolean count, List<GroupsOrderby> orderby, List<GroupsSelect> select, List<String> expand, Context context) {
        return new PagedIterable(this.listMembersAsync(groupId, top, skip, search, filter, count, orderby, select, expand, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefMembersSinglePageAsync(String groupId, Integer top, Integer skip, String search, String filter, Boolean count, List<GroupsOrderby> orderby) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = orderby == null ? null : orderby.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
        return FluxUtil.withContext(context -> this.service.listRefMembers(this.client.getEndpoint(), groupId, top, skip, search, filter, count, orderbyConverted, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfDirectoryObject)res.getValue()).value(), ((CollectionOfLinksOfDirectoryObject)res.getValue()).odataNextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefMembersSinglePageAsync(String groupId, Integer top, Integer skip, String search, String filter, Boolean count, List<GroupsOrderby> orderby, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = orderby == null ? null : orderby.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.joining(","));
        context = this.client.mergeContext(context);
        return this.service.listRefMembers(this.client.getEndpoint(), groupId, top, skip, search, filter, count, orderbyConverted, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfDirectoryObject)res.getValue()).value(), ((CollectionOfLinksOfDirectoryObject)res.getValue()).odataNextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<String> listRefMembersAsync(String groupId, Integer top, Integer skip, String search, String filter, Boolean count, List<GroupsOrderby> orderby) {
        return new PagedFlux(() -> this.listRefMembersSinglePageAsync(groupId, top, skip, search, filter, count, orderby), nextLink -> this.listRefMembersNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<String> listRefMembersAsync(String groupId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List orderby = null;
        return new PagedFlux(() -> this.listRefMembersSinglePageAsync(groupId, top, skip, search, filter, count, orderby), nextLink -> this.listRefMembersNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<String> listRefMembersAsync(String groupId, Integer top, Integer skip, String search, String filter, Boolean count, List<GroupsOrderby> orderby, Context context) {
        return new PagedFlux(() -> this.listRefMembersSinglePageAsync(groupId, top, skip, search, filter, count, orderby, context), nextLink -> this.listRefMembersNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<String> listRefMembers(String groupId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List<GroupsOrderby> orderby = null;
        return new PagedIterable(this.listRefMembersAsync(groupId, top, skip, search, filter, count, orderby));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<String> listRefMembers(String groupId, Integer top, Integer skip, String search, String filter, Boolean count, List<GroupsOrderby> orderby, Context context) {
        return new PagedIterable(this.listRefMembersAsync(groupId, top, skip, search, filter, count, orderby, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> createRefMembersWithResponseAsync(String groupId, Map<String, Object> body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createRefMembers(this.client.getEndpoint(), groupId, body, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> createRefMembersWithResponseAsync(String groupId, Map<String, Object> body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createRefMembers(this.client.getEndpoint(), groupId, body, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> createRefMembersAsync(String groupId, Map<String, Object> body) {
        return this.createRefMembersWithResponseAsync(groupId, body).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> createRefMembersWithResponse(String groupId, Map<String, Object> body, Context context) {
        return (Response)this.createRefMembersWithResponseAsync(groupId, body, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void createRefMembers(String groupId, Map<String, Object> body) {
        this.createRefMembersWithResponse(groupId, body, Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteRefMemberWithResponseAsync(String groupId, String directoryObjectId, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (directoryObjectId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter directoryObjectId is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteRefMember(this.client.getEndpoint(), groupId, directoryObjectId, ifMatch, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteRefMemberWithResponseAsync(String groupId, String directoryObjectId, String ifMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupId is required and cannot be null."));
        }
        if (directoryObjectId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter directoryObjectId is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.deleteRefMember(this.client.getEndpoint(), groupId, directoryObjectId, ifMatch, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteRefMemberAsync(String groupId, String directoryObjectId) {
        String ifMatch = null;
        return this.deleteRefMemberWithResponseAsync(groupId, directoryObjectId, ifMatch).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteRefMemberWithResponse(String groupId, String directoryObjectId, String ifMatch, Context context) {
        return (Response)this.deleteRefMemberWithResponseAsync(groupId, directoryObjectId, ifMatch, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteRefMember(String groupId, String directoryObjectId) {
        String ifMatch = null;
        this.deleteRefMemberWithResponse(groupId, directoryObjectId, ifMatch, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listMoreSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listMore(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObject)res.getValue()).value(), ((CollectionOfDirectoryObject)res.getValue()).odataNextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listMoreSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listMore(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObject)res.getValue()).value(), ((CollectionOfDirectoryObject)res.getValue()).odataNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listMembersNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listMembersNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObject0)res.getValue()).value(), ((CollectionOfDirectoryObject0)res.getValue()).odataNextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listMembersNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listMembersNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObject0)res.getValue()).value(), ((CollectionOfDirectoryObject0)res.getValue()).odataNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefMembersNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listRefMembersNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfDirectoryObject)res.getValue()).value(), ((CollectionOfLinksOfDirectoryObject)res.getValue()).odataNextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<String>> listRefMembersNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listRefMembersNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfDirectoryObject)res.getValue()).value(), ((CollectionOfLinksOfDirectoryObject)res.getValue()).odataNextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="MicrosoftGraphClient")
    public static interface GroupsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/groups/{group-id}/acceptedSenders")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfDirectoryObject>> listAcceptedSenders(@HostParam(value="$host") String var1, @PathParam(value="group-id") String var2, @QueryParam(value="$top") Integer var3, @QueryParam(value="$skip") Integer var4, @QueryParam(value="$search") String var5, @QueryParam(value="$filter") String var6, @QueryParam(value="$count") Boolean var7, @QueryParam(value="$orderby") String var8, @QueryParam(value="$select") String var9, @QueryParam(value="$expand") String var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/groups/{group-id}/acceptedSenders")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<MicrosoftGraphDirectoryObjectInner>> createAcceptedSenders(@HostParam(value="$host") String var1, @PathParam(value="group-id") String var2, @BodyParam(value="application/json") MicrosoftGraphDirectoryObjectInner var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/groups/{group-id}/members")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfDirectoryObject0>> listMembers(@HostParam(value="$host") String var1, @PathParam(value="group-id") String var2, @QueryParam(value="$top") Integer var3, @QueryParam(value="$skip") Integer var4, @QueryParam(value="$search") String var5, @QueryParam(value="$filter") String var6, @QueryParam(value="$count") Boolean var7, @QueryParam(value="$orderby") String var8, @QueryParam(value="$select") String var9, @QueryParam(value="$expand") String var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/groups/{group-id}/members/$ref")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfLinksOfDirectoryObject>> listRefMembers(@HostParam(value="$host") String var1, @PathParam(value="group-id") String var2, @QueryParam(value="$top") Integer var3, @QueryParam(value="$skip") Integer var4, @QueryParam(value="$search") String var5, @QueryParam(value="$filter") String var6, @QueryParam(value="$count") Boolean var7, @QueryParam(value="$orderby") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/groups/{group-id}/members/$ref")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> createRefMembers(@HostParam(value="$host") String var1, @PathParam(value="group-id") String var2, @BodyParam(value="application/json") Map<String, Object> var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/groups/{group-id}/members/{directoryObject-id}/$ref")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> deleteRefMember(@HostParam(value="$host") String var1, @PathParam(value="group-id") String var2, @PathParam(value="directoryObject-id") String var3, @HeaderParam(value="If-Match") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfDirectoryObject>> listMore(@PathParam(value="nextLink", encoded=true) String var1, Context var2);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfDirectoryObject0>> listMembersNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfLinksOfDirectoryObject>> listRefMembersNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);
    }
}

