/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphEntity;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphResourceReference;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphResourceVisualization;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphSharingDetail;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class MicrosoftGraphSharedInsight
extends MicrosoftGraphEntity {
    private MicrosoftGraphSharingDetail lastShared;
    private MicrosoftGraphResourceReference resourceReference;
    private MicrosoftGraphResourceVisualization resourceVisualization;
    private List<MicrosoftGraphSharingDetail> sharingHistory;
    private MicrosoftGraphEntity lastSharedMethod;
    private MicrosoftGraphEntity resource;
    private Map<String, Object> additionalProperties;

    public MicrosoftGraphSharingDetail lastShared() {
        return this.lastShared;
    }

    public MicrosoftGraphSharedInsight withLastShared(MicrosoftGraphSharingDetail lastShared) {
        this.lastShared = lastShared;
        return this;
    }

    public MicrosoftGraphResourceReference resourceReference() {
        return this.resourceReference;
    }

    public MicrosoftGraphSharedInsight withResourceReference(MicrosoftGraphResourceReference resourceReference) {
        this.resourceReference = resourceReference;
        return this;
    }

    public MicrosoftGraphResourceVisualization resourceVisualization() {
        return this.resourceVisualization;
    }

    public MicrosoftGraphSharedInsight withResourceVisualization(MicrosoftGraphResourceVisualization resourceVisualization) {
        this.resourceVisualization = resourceVisualization;
        return this;
    }

    public List<MicrosoftGraphSharingDetail> sharingHistory() {
        return this.sharingHistory;
    }

    public MicrosoftGraphSharedInsight withSharingHistory(List<MicrosoftGraphSharingDetail> sharingHistory) {
        this.sharingHistory = sharingHistory;
        return this;
    }

    public MicrosoftGraphEntity lastSharedMethod() {
        return this.lastSharedMethod;
    }

    public MicrosoftGraphSharedInsight withLastSharedMethod(MicrosoftGraphEntity lastSharedMethod) {
        this.lastSharedMethod = lastSharedMethod;
        return this;
    }

    public MicrosoftGraphEntity resource() {
        return this.resource;
    }

    public MicrosoftGraphSharedInsight withResource(MicrosoftGraphEntity resource) {
        this.resource = resource;
        return this;
    }

    @Override
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public MicrosoftGraphSharedInsight withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @Override
    public MicrosoftGraphSharedInsight withId(String id) {
        super.withId(id);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.lastShared() != null) {
            this.lastShared().validate();
        }
        if (this.resourceReference() != null) {
            this.resourceReference().validate();
        }
        if (this.resourceVisualization() != null) {
            this.resourceVisualization().validate();
        }
        if (this.sharingHistory() != null) {
            this.sharingHistory().forEach(e -> e.validate());
        }
        if (this.lastSharedMethod() != null) {
            this.lastSharedMethod().validate();
        }
        if (this.resource() != null) {
            this.resource().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeJsonField("lastShared", (JsonSerializable)this.lastShared);
        jsonWriter.writeJsonField("resourceReference", (JsonSerializable)this.resourceReference);
        jsonWriter.writeJsonField("resourceVisualization", (JsonSerializable)this.resourceVisualization);
        jsonWriter.writeArrayField("sharingHistory", this.sharingHistory, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("lastSharedMethod", (JsonSerializable)this.lastSharedMethod);
        jsonWriter.writeJsonField("resource", (JsonSerializable)this.resource);
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static MicrosoftGraphSharedInsight fromJson(JsonReader jsonReader) throws IOException {
        return (MicrosoftGraphSharedInsight)jsonReader.readObject(reader -> {
            MicrosoftGraphSharedInsight deserializedMicrosoftGraphSharedInsight = new MicrosoftGraphSharedInsight();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphSharedInsight.withId(reader.getString());
                    continue;
                }
                if ("lastShared".equals(fieldName)) {
                    deserializedMicrosoftGraphSharedInsight.lastShared = MicrosoftGraphSharingDetail.fromJson(reader);
                    continue;
                }
                if ("resourceReference".equals(fieldName)) {
                    deserializedMicrosoftGraphSharedInsight.resourceReference = MicrosoftGraphResourceReference.fromJson(reader);
                    continue;
                }
                if ("resourceVisualization".equals(fieldName)) {
                    deserializedMicrosoftGraphSharedInsight.resourceVisualization = MicrosoftGraphResourceVisualization.fromJson(reader);
                    continue;
                }
                if ("sharingHistory".equals(fieldName)) {
                    List sharingHistory;
                    deserializedMicrosoftGraphSharedInsight.sharingHistory = sharingHistory = reader.readArray(reader1 -> MicrosoftGraphSharingDetail.fromJson(reader1));
                    continue;
                }
                if ("lastSharedMethod".equals(fieldName)) {
                    deserializedMicrosoftGraphSharedInsight.lastSharedMethod = MicrosoftGraphEntity.fromJson(reader);
                    continue;
                }
                if ("resource".equals(fieldName)) {
                    deserializedMicrosoftGraphSharedInsight.resource = MicrosoftGraphEntity.fromJson(reader);
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedMicrosoftGraphSharedInsight.additionalProperties = additionalProperties;
            return deserializedMicrosoftGraphSharedInsight;
        });
    }
}

