/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphEntity;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphIdentitySet;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphItemReference;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphSharingInvitation;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphSharingLink;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class MicrosoftGraphPermission
extends MicrosoftGraphEntity {
    private OffsetDateTime expirationDateTime;
    private MicrosoftGraphIdentitySet grantedTo;
    private List<MicrosoftGraphIdentitySet> grantedToIdentities;
    private Boolean hasPassword;
    private MicrosoftGraphItemReference inheritedFrom;
    private MicrosoftGraphSharingInvitation invitation;
    private MicrosoftGraphSharingLink link;
    private List<String> roles;
    private String shareId;
    private Map<String, Object> additionalProperties;

    public OffsetDateTime expirationDateTime() {
        return this.expirationDateTime;
    }

    public MicrosoftGraphPermission withExpirationDateTime(OffsetDateTime expirationDateTime) {
        this.expirationDateTime = expirationDateTime;
        return this;
    }

    public MicrosoftGraphIdentitySet grantedTo() {
        return this.grantedTo;
    }

    public MicrosoftGraphPermission withGrantedTo(MicrosoftGraphIdentitySet grantedTo) {
        this.grantedTo = grantedTo;
        return this;
    }

    public List<MicrosoftGraphIdentitySet> grantedToIdentities() {
        return this.grantedToIdentities;
    }

    public MicrosoftGraphPermission withGrantedToIdentities(List<MicrosoftGraphIdentitySet> grantedToIdentities) {
        this.grantedToIdentities = grantedToIdentities;
        return this;
    }

    public Boolean hasPassword() {
        return this.hasPassword;
    }

    public MicrosoftGraphPermission withHasPassword(Boolean hasPassword) {
        this.hasPassword = hasPassword;
        return this;
    }

    public MicrosoftGraphItemReference inheritedFrom() {
        return this.inheritedFrom;
    }

    public MicrosoftGraphPermission withInheritedFrom(MicrosoftGraphItemReference inheritedFrom) {
        this.inheritedFrom = inheritedFrom;
        return this;
    }

    public MicrosoftGraphSharingInvitation invitation() {
        return this.invitation;
    }

    public MicrosoftGraphPermission withInvitation(MicrosoftGraphSharingInvitation invitation) {
        this.invitation = invitation;
        return this;
    }

    public MicrosoftGraphSharingLink link() {
        return this.link;
    }

    public MicrosoftGraphPermission withLink(MicrosoftGraphSharingLink link) {
        this.link = link;
        return this;
    }

    public List<String> roles() {
        return this.roles;
    }

    public MicrosoftGraphPermission withRoles(List<String> roles) {
        this.roles = roles;
        return this;
    }

    public String shareId() {
        return this.shareId;
    }

    public MicrosoftGraphPermission withShareId(String shareId) {
        this.shareId = shareId;
        return this;
    }

    @Override
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public MicrosoftGraphPermission withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @Override
    public MicrosoftGraphPermission withId(String id) {
        super.withId(id);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.grantedTo() != null) {
            this.grantedTo().validate();
        }
        if (this.grantedToIdentities() != null) {
            this.grantedToIdentities().forEach(e -> e.validate());
        }
        if (this.inheritedFrom() != null) {
            this.inheritedFrom().validate();
        }
        if (this.invitation() != null) {
            this.invitation().validate();
        }
        if (this.link() != null) {
            this.link().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeStringField("expirationDateTime", this.expirationDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.expirationDateTime));
        jsonWriter.writeJsonField("grantedTo", (JsonSerializable)this.grantedTo);
        jsonWriter.writeArrayField("grantedToIdentities", this.grantedToIdentities, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeBooleanField("hasPassword", this.hasPassword);
        jsonWriter.writeJsonField("inheritedFrom", (JsonSerializable)this.inheritedFrom);
        jsonWriter.writeJsonField("invitation", (JsonSerializable)this.invitation);
        jsonWriter.writeJsonField("link", (JsonSerializable)this.link);
        jsonWriter.writeArrayField("roles", this.roles, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("shareId", this.shareId);
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static MicrosoftGraphPermission fromJson(JsonReader jsonReader) throws IOException {
        return (MicrosoftGraphPermission)jsonReader.readObject(reader -> {
            MicrosoftGraphPermission deserializedMicrosoftGraphPermission = new MicrosoftGraphPermission();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphPermission.withId(reader.getString());
                    continue;
                }
                if ("expirationDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphPermission.expirationDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("grantedTo".equals(fieldName)) {
                    deserializedMicrosoftGraphPermission.grantedTo = MicrosoftGraphIdentitySet.fromJson(reader);
                    continue;
                }
                if ("grantedToIdentities".equals(fieldName)) {
                    List grantedToIdentities;
                    deserializedMicrosoftGraphPermission.grantedToIdentities = grantedToIdentities = reader.readArray(reader1 -> MicrosoftGraphIdentitySet.fromJson(reader1));
                    continue;
                }
                if ("hasPassword".equals(fieldName)) {
                    deserializedMicrosoftGraphPermission.hasPassword = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("inheritedFrom".equals(fieldName)) {
                    deserializedMicrosoftGraphPermission.inheritedFrom = MicrosoftGraphItemReference.fromJson(reader);
                    continue;
                }
                if ("invitation".equals(fieldName)) {
                    deserializedMicrosoftGraphPermission.invitation = MicrosoftGraphSharingInvitation.fromJson(reader);
                    continue;
                }
                if ("link".equals(fieldName)) {
                    deserializedMicrosoftGraphPermission.link = MicrosoftGraphSharingLink.fromJson(reader);
                    continue;
                }
                if ("roles".equals(fieldName)) {
                    List roles;
                    deserializedMicrosoftGraphPermission.roles = roles = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("shareId".equals(fieldName)) {
                    deserializedMicrosoftGraphPermission.shareId = reader.getString();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedMicrosoftGraphPermission.additionalProperties = additionalProperties;
            return deserializedMicrosoftGraphPermission;
        });
    }
}

