/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphDateTimeZone;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphEntity;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphExtension;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphImportance;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphItemBody;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphLinkedResource;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphPatternedRecurrence;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphTaskStatus;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class MicrosoftGraphTodoTask
extends MicrosoftGraphEntity {
    private MicrosoftGraphItemBody body;
    private OffsetDateTime bodyLastModifiedDateTime;
    private MicrosoftGraphDateTimeZone completedDateTime;
    private OffsetDateTime createdDateTime;
    private MicrosoftGraphDateTimeZone dueDateTime;
    private MicrosoftGraphImportance importance;
    private Boolean isReminderOn;
    private OffsetDateTime lastModifiedDateTime;
    private MicrosoftGraphPatternedRecurrence recurrence;
    private MicrosoftGraphDateTimeZone reminderDateTime;
    private MicrosoftGraphTaskStatus status;
    private String title;
    private List<MicrosoftGraphExtension> extensions;
    private List<MicrosoftGraphLinkedResource> linkedResources;
    private Map<String, Object> additionalProperties;

    public MicrosoftGraphItemBody body() {
        return this.body;
    }

    public MicrosoftGraphTodoTask withBody(MicrosoftGraphItemBody body) {
        this.body = body;
        return this;
    }

    public OffsetDateTime bodyLastModifiedDateTime() {
        return this.bodyLastModifiedDateTime;
    }

    public MicrosoftGraphTodoTask withBodyLastModifiedDateTime(OffsetDateTime bodyLastModifiedDateTime) {
        this.bodyLastModifiedDateTime = bodyLastModifiedDateTime;
        return this;
    }

    public MicrosoftGraphDateTimeZone completedDateTime() {
        return this.completedDateTime;
    }

    public MicrosoftGraphTodoTask withCompletedDateTime(MicrosoftGraphDateTimeZone completedDateTime) {
        this.completedDateTime = completedDateTime;
        return this;
    }

    public OffsetDateTime createdDateTime() {
        return this.createdDateTime;
    }

    public MicrosoftGraphTodoTask withCreatedDateTime(OffsetDateTime createdDateTime) {
        this.createdDateTime = createdDateTime;
        return this;
    }

    public MicrosoftGraphDateTimeZone dueDateTime() {
        return this.dueDateTime;
    }

    public MicrosoftGraphTodoTask withDueDateTime(MicrosoftGraphDateTimeZone dueDateTime) {
        this.dueDateTime = dueDateTime;
        return this;
    }

    public MicrosoftGraphImportance importance() {
        return this.importance;
    }

    public MicrosoftGraphTodoTask withImportance(MicrosoftGraphImportance importance) {
        this.importance = importance;
        return this;
    }

    public Boolean isReminderOn() {
        return this.isReminderOn;
    }

    public MicrosoftGraphTodoTask withIsReminderOn(Boolean isReminderOn) {
        this.isReminderOn = isReminderOn;
        return this;
    }

    public OffsetDateTime lastModifiedDateTime() {
        return this.lastModifiedDateTime;
    }

    public MicrosoftGraphTodoTask withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        this.lastModifiedDateTime = lastModifiedDateTime;
        return this;
    }

    public MicrosoftGraphPatternedRecurrence recurrence() {
        return this.recurrence;
    }

    public MicrosoftGraphTodoTask withRecurrence(MicrosoftGraphPatternedRecurrence recurrence) {
        this.recurrence = recurrence;
        return this;
    }

    public MicrosoftGraphDateTimeZone reminderDateTime() {
        return this.reminderDateTime;
    }

    public MicrosoftGraphTodoTask withReminderDateTime(MicrosoftGraphDateTimeZone reminderDateTime) {
        this.reminderDateTime = reminderDateTime;
        return this;
    }

    public MicrosoftGraphTaskStatus status() {
        return this.status;
    }

    public MicrosoftGraphTodoTask withStatus(MicrosoftGraphTaskStatus status) {
        this.status = status;
        return this;
    }

    public String title() {
        return this.title;
    }

    public MicrosoftGraphTodoTask withTitle(String title) {
        this.title = title;
        return this;
    }

    public List<MicrosoftGraphExtension> extensions() {
        return this.extensions;
    }

    public MicrosoftGraphTodoTask withExtensions(List<MicrosoftGraphExtension> extensions) {
        this.extensions = extensions;
        return this;
    }

    public List<MicrosoftGraphLinkedResource> linkedResources() {
        return this.linkedResources;
    }

    public MicrosoftGraphTodoTask withLinkedResources(List<MicrosoftGraphLinkedResource> linkedResources) {
        this.linkedResources = linkedResources;
        return this;
    }

    @Override
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public MicrosoftGraphTodoTask withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @Override
    public MicrosoftGraphTodoTask withId(String id) {
        super.withId(id);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.body() != null) {
            this.body().validate();
        }
        if (this.completedDateTime() != null) {
            this.completedDateTime().validate();
        }
        if (this.dueDateTime() != null) {
            this.dueDateTime().validate();
        }
        if (this.recurrence() != null) {
            this.recurrence().validate();
        }
        if (this.reminderDateTime() != null) {
            this.reminderDateTime().validate();
        }
        if (this.extensions() != null) {
            this.extensions().forEach(e -> e.validate());
        }
        if (this.linkedResources() != null) {
            this.linkedResources().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeJsonField("body", (JsonSerializable)this.body);
        jsonWriter.writeStringField("bodyLastModifiedDateTime", this.bodyLastModifiedDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.bodyLastModifiedDateTime));
        jsonWriter.writeJsonField("completedDateTime", (JsonSerializable)this.completedDateTime);
        jsonWriter.writeStringField("createdDateTime", this.createdDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.createdDateTime));
        jsonWriter.writeJsonField("dueDateTime", (JsonSerializable)this.dueDateTime);
        jsonWriter.writeStringField("importance", this.importance == null ? null : this.importance.toString());
        jsonWriter.writeBooleanField("isReminderOn", this.isReminderOn);
        jsonWriter.writeStringField("lastModifiedDateTime", this.lastModifiedDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastModifiedDateTime));
        jsonWriter.writeJsonField("recurrence", (JsonSerializable)this.recurrence);
        jsonWriter.writeJsonField("reminderDateTime", (JsonSerializable)this.reminderDateTime);
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        jsonWriter.writeStringField("title", this.title);
        jsonWriter.writeArrayField("extensions", this.extensions, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("linkedResources", this.linkedResources, (writer, element) -> writer.writeJson((JsonSerializable)element));
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static MicrosoftGraphTodoTask fromJson(JsonReader jsonReader) throws IOException {
        return (MicrosoftGraphTodoTask)jsonReader.readObject(reader -> {
            MicrosoftGraphTodoTask deserializedMicrosoftGraphTodoTask = new MicrosoftGraphTodoTask();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphTodoTask.withId(reader.getString());
                    continue;
                }
                if ("body".equals(fieldName)) {
                    deserializedMicrosoftGraphTodoTask.body = MicrosoftGraphItemBody.fromJson(reader);
                    continue;
                }
                if ("bodyLastModifiedDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphTodoTask.bodyLastModifiedDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("completedDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphTodoTask.completedDateTime = MicrosoftGraphDateTimeZone.fromJson(reader);
                    continue;
                }
                if ("createdDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphTodoTask.createdDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("dueDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphTodoTask.dueDateTime = MicrosoftGraphDateTimeZone.fromJson(reader);
                    continue;
                }
                if ("importance".equals(fieldName)) {
                    deserializedMicrosoftGraphTodoTask.importance = MicrosoftGraphImportance.fromString(reader.getString());
                    continue;
                }
                if ("isReminderOn".equals(fieldName)) {
                    deserializedMicrosoftGraphTodoTask.isReminderOn = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("lastModifiedDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphTodoTask.lastModifiedDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("recurrence".equals(fieldName)) {
                    deserializedMicrosoftGraphTodoTask.recurrence = MicrosoftGraphPatternedRecurrence.fromJson(reader);
                    continue;
                }
                if ("reminderDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphTodoTask.reminderDateTime = MicrosoftGraphDateTimeZone.fromJson(reader);
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedMicrosoftGraphTodoTask.status = MicrosoftGraphTaskStatus.fromString(reader.getString());
                    continue;
                }
                if ("title".equals(fieldName)) {
                    deserializedMicrosoftGraphTodoTask.title = reader.getString();
                    continue;
                }
                if ("extensions".equals(fieldName)) {
                    List extensions;
                    deserializedMicrosoftGraphTodoTask.extensions = extensions = reader.readArray(reader1 -> MicrosoftGraphExtension.fromJson(reader1));
                    continue;
                }
                if ("linkedResources".equals(fieldName)) {
                    List linkedResources;
                    deserializedMicrosoftGraphTodoTask.linkedResources = linkedResources = reader.readArray(reader1 -> MicrosoftGraphLinkedResource.fromJson(reader1));
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedMicrosoftGraphTodoTask.additionalProperties = additionalProperties;
            return deserializedMicrosoftGraphTodoTask;
        });
    }
}

