/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphDirectoryObjectInner;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;

public final class MicrosoftGraphContract
extends MicrosoftGraphDirectoryObjectInner {
    private String contractType;
    private UUID customerId;
    private String defaultDomainName;
    private String displayName;
    private Map<String, Object> additionalProperties;

    public String contractType() {
        return this.contractType;
    }

    public MicrosoftGraphContract withContractType(String contractType) {
        this.contractType = contractType;
        return this;
    }

    public UUID customerId() {
        return this.customerId;
    }

    public MicrosoftGraphContract withCustomerId(UUID customerId) {
        this.customerId = customerId;
        return this;
    }

    public String defaultDomainName() {
        return this.defaultDomainName;
    }

    public MicrosoftGraphContract withDefaultDomainName(String defaultDomainName) {
        this.defaultDomainName = defaultDomainName;
        return this;
    }

    public String displayName() {
        return this.displayName;
    }

    public MicrosoftGraphContract withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Override
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public MicrosoftGraphContract withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @Override
    public MicrosoftGraphContract withDeletedDateTime(OffsetDateTime deletedDateTime) {
        super.withDeletedDateTime(deletedDateTime);
        return this;
    }

    @Override
    public MicrosoftGraphContract withId(String id) {
        super.withId(id);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeStringField("deletedDateTime", this.deletedDateTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.deletedDateTime()));
        jsonWriter.writeStringField("contractType", this.contractType);
        jsonWriter.writeStringField("customerId", Objects.toString(this.customerId, null));
        jsonWriter.writeStringField("defaultDomainName", this.defaultDomainName);
        jsonWriter.writeStringField("displayName", this.displayName);
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static MicrosoftGraphContract fromJson(JsonReader jsonReader) throws IOException {
        return (MicrosoftGraphContract)jsonReader.readObject(reader -> {
            MicrosoftGraphContract deserializedMicrosoftGraphContract = new MicrosoftGraphContract();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphContract.withId(reader.getString());
                    continue;
                }
                if ("deletedDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphContract.withDeletedDateTime((OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString())));
                    continue;
                }
                if ("contractType".equals(fieldName)) {
                    deserializedMicrosoftGraphContract.contractType = reader.getString();
                    continue;
                }
                if ("customerId".equals(fieldName)) {
                    deserializedMicrosoftGraphContract.customerId = (UUID)reader.getNullable(nonNullReader -> UUID.fromString(nonNullReader.getString()));
                    continue;
                }
                if ("defaultDomainName".equals(fieldName)) {
                    deserializedMicrosoftGraphContract.defaultDomainName = reader.getString();
                    continue;
                }
                if ("displayName".equals(fieldName)) {
                    deserializedMicrosoftGraphContract.displayName = reader.getString();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedMicrosoftGraphContract.additionalProperties = additionalProperties;
            return deserializedMicrosoftGraphContract;
        });
    }
}

