/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphActivityHistoryItem;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphEntity;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphStatus;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphVisualInfo;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class MicrosoftGraphUserActivity
extends MicrosoftGraphEntity {
    private String activationUrl;
    private String activitySourceHost;
    private String appActivityId;
    private String appDisplayName;
    private Map<String, Object> contentInfo;
    private String contentUrl;
    private OffsetDateTime createdDateTime;
    private OffsetDateTime expirationDateTime;
    private String fallbackUrl;
    private OffsetDateTime lastModifiedDateTime;
    private MicrosoftGraphStatus status;
    private String userTimezone;
    private MicrosoftGraphVisualInfo visualElements;
    private List<MicrosoftGraphActivityHistoryItem> historyItems;
    private Map<String, Object> additionalProperties;

    public String activationUrl() {
        return this.activationUrl;
    }

    public MicrosoftGraphUserActivity withActivationUrl(String activationUrl) {
        this.activationUrl = activationUrl;
        return this;
    }

    public String activitySourceHost() {
        return this.activitySourceHost;
    }

    public MicrosoftGraphUserActivity withActivitySourceHost(String activitySourceHost) {
        this.activitySourceHost = activitySourceHost;
        return this;
    }

    public String appActivityId() {
        return this.appActivityId;
    }

    public MicrosoftGraphUserActivity withAppActivityId(String appActivityId) {
        this.appActivityId = appActivityId;
        return this;
    }

    public String appDisplayName() {
        return this.appDisplayName;
    }

    public MicrosoftGraphUserActivity withAppDisplayName(String appDisplayName) {
        this.appDisplayName = appDisplayName;
        return this;
    }

    public Map<String, Object> contentInfo() {
        return this.contentInfo;
    }

    public MicrosoftGraphUserActivity withContentInfo(Map<String, Object> contentInfo) {
        this.contentInfo = contentInfo;
        return this;
    }

    public String contentUrl() {
        return this.contentUrl;
    }

    public MicrosoftGraphUserActivity withContentUrl(String contentUrl) {
        this.contentUrl = contentUrl;
        return this;
    }

    public OffsetDateTime createdDateTime() {
        return this.createdDateTime;
    }

    public MicrosoftGraphUserActivity withCreatedDateTime(OffsetDateTime createdDateTime) {
        this.createdDateTime = createdDateTime;
        return this;
    }

    public OffsetDateTime expirationDateTime() {
        return this.expirationDateTime;
    }

    public MicrosoftGraphUserActivity withExpirationDateTime(OffsetDateTime expirationDateTime) {
        this.expirationDateTime = expirationDateTime;
        return this;
    }

    public String fallbackUrl() {
        return this.fallbackUrl;
    }

    public MicrosoftGraphUserActivity withFallbackUrl(String fallbackUrl) {
        this.fallbackUrl = fallbackUrl;
        return this;
    }

    public OffsetDateTime lastModifiedDateTime() {
        return this.lastModifiedDateTime;
    }

    public MicrosoftGraphUserActivity withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        this.lastModifiedDateTime = lastModifiedDateTime;
        return this;
    }

    public MicrosoftGraphStatus status() {
        return this.status;
    }

    public MicrosoftGraphUserActivity withStatus(MicrosoftGraphStatus status) {
        this.status = status;
        return this;
    }

    public String userTimezone() {
        return this.userTimezone;
    }

    public MicrosoftGraphUserActivity withUserTimezone(String userTimezone) {
        this.userTimezone = userTimezone;
        return this;
    }

    public MicrosoftGraphVisualInfo visualElements() {
        return this.visualElements;
    }

    public MicrosoftGraphUserActivity withVisualElements(MicrosoftGraphVisualInfo visualElements) {
        this.visualElements = visualElements;
        return this;
    }

    public List<MicrosoftGraphActivityHistoryItem> historyItems() {
        return this.historyItems;
    }

    public MicrosoftGraphUserActivity withHistoryItems(List<MicrosoftGraphActivityHistoryItem> historyItems) {
        this.historyItems = historyItems;
        return this;
    }

    @Override
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public MicrosoftGraphUserActivity withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @Override
    public MicrosoftGraphUserActivity withId(String id) {
        super.withId(id);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.visualElements() != null) {
            this.visualElements().validate();
        }
        if (this.historyItems() != null) {
            this.historyItems().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeStringField("activationUrl", this.activationUrl);
        jsonWriter.writeStringField("activitySourceHost", this.activitySourceHost);
        jsonWriter.writeStringField("appActivityId", this.appActivityId);
        jsonWriter.writeStringField("appDisplayName", this.appDisplayName);
        jsonWriter.writeMapField("contentInfo", this.contentInfo, (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeStringField("contentUrl", this.contentUrl);
        jsonWriter.writeStringField("createdDateTime", this.createdDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.createdDateTime));
        jsonWriter.writeStringField("expirationDateTime", this.expirationDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.expirationDateTime));
        jsonWriter.writeStringField("fallbackUrl", this.fallbackUrl);
        jsonWriter.writeStringField("lastModifiedDateTime", this.lastModifiedDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastModifiedDateTime));
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        jsonWriter.writeStringField("userTimezone", this.userTimezone);
        jsonWriter.writeJsonField("visualElements", (JsonSerializable)this.visualElements);
        jsonWriter.writeArrayField("historyItems", this.historyItems, (writer, element) -> writer.writeJson((JsonSerializable)element));
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static MicrosoftGraphUserActivity fromJson(JsonReader jsonReader) throws IOException {
        return (MicrosoftGraphUserActivity)jsonReader.readObject(reader -> {
            MicrosoftGraphUserActivity deserializedMicrosoftGraphUserActivity = new MicrosoftGraphUserActivity();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphUserActivity.withId(reader.getString());
                    continue;
                }
                if ("activationUrl".equals(fieldName)) {
                    deserializedMicrosoftGraphUserActivity.activationUrl = reader.getString();
                    continue;
                }
                if ("activitySourceHost".equals(fieldName)) {
                    deserializedMicrosoftGraphUserActivity.activitySourceHost = reader.getString();
                    continue;
                }
                if ("appActivityId".equals(fieldName)) {
                    deserializedMicrosoftGraphUserActivity.appActivityId = reader.getString();
                    continue;
                }
                if ("appDisplayName".equals(fieldName)) {
                    deserializedMicrosoftGraphUserActivity.appDisplayName = reader.getString();
                    continue;
                }
                if ("contentInfo".equals(fieldName)) {
                    Map contentInfo;
                    deserializedMicrosoftGraphUserActivity.contentInfo = contentInfo = reader.readMap(reader1 -> reader1.readUntyped());
                    continue;
                }
                if ("contentUrl".equals(fieldName)) {
                    deserializedMicrosoftGraphUserActivity.contentUrl = reader.getString();
                    continue;
                }
                if ("createdDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphUserActivity.createdDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("expirationDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphUserActivity.expirationDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("fallbackUrl".equals(fieldName)) {
                    deserializedMicrosoftGraphUserActivity.fallbackUrl = reader.getString();
                    continue;
                }
                if ("lastModifiedDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphUserActivity.lastModifiedDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedMicrosoftGraphUserActivity.status = MicrosoftGraphStatus.fromString(reader.getString());
                    continue;
                }
                if ("userTimezone".equals(fieldName)) {
                    deserializedMicrosoftGraphUserActivity.userTimezone = reader.getString();
                    continue;
                }
                if ("visualElements".equals(fieldName)) {
                    deserializedMicrosoftGraphUserActivity.visualElements = MicrosoftGraphVisualInfo.fromJson(reader);
                    continue;
                }
                if ("historyItems".equals(fieldName)) {
                    List historyItems;
                    deserializedMicrosoftGraphUserActivity.historyItems = historyItems = reader.readArray(reader1 -> MicrosoftGraphActivityHistoryItem.fromJson(reader1));
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedMicrosoftGraphUserActivity.additionalProperties = additionalProperties;
            return deserializedMicrosoftGraphUserActivity;
        });
    }
}

