/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphEntity;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphIdentity;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class MicrosoftGraphScopedRoleMembership
extends MicrosoftGraphEntity {
    private String administrativeUnitId;
    private String roleId;
    private MicrosoftGraphIdentity roleMemberInfo;
    private Map<String, Object> additionalProperties;

    public String administrativeUnitId() {
        return this.administrativeUnitId;
    }

    public MicrosoftGraphScopedRoleMembership withAdministrativeUnitId(String administrativeUnitId) {
        this.administrativeUnitId = administrativeUnitId;
        return this;
    }

    public String roleId() {
        return this.roleId;
    }

    public MicrosoftGraphScopedRoleMembership withRoleId(String roleId) {
        this.roleId = roleId;
        return this;
    }

    public MicrosoftGraphIdentity roleMemberInfo() {
        return this.roleMemberInfo;
    }

    public MicrosoftGraphScopedRoleMembership withRoleMemberInfo(MicrosoftGraphIdentity roleMemberInfo) {
        this.roleMemberInfo = roleMemberInfo;
        return this;
    }

    @Override
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public MicrosoftGraphScopedRoleMembership withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @Override
    public MicrosoftGraphScopedRoleMembership withId(String id) {
        super.withId(id);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.roleMemberInfo() != null) {
            this.roleMemberInfo().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeStringField("administrativeUnitId", this.administrativeUnitId);
        jsonWriter.writeStringField("roleId", this.roleId);
        jsonWriter.writeJsonField("roleMemberInfo", (JsonSerializable)this.roleMemberInfo);
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static MicrosoftGraphScopedRoleMembership fromJson(JsonReader jsonReader) throws IOException {
        return (MicrosoftGraphScopedRoleMembership)jsonReader.readObject(reader -> {
            MicrosoftGraphScopedRoleMembership deserializedMicrosoftGraphScopedRoleMembership = new MicrosoftGraphScopedRoleMembership();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphScopedRoleMembership.withId(reader.getString());
                    continue;
                }
                if ("administrativeUnitId".equals(fieldName)) {
                    deserializedMicrosoftGraphScopedRoleMembership.administrativeUnitId = reader.getString();
                    continue;
                }
                if ("roleId".equals(fieldName)) {
                    deserializedMicrosoftGraphScopedRoleMembership.roleId = reader.getString();
                    continue;
                }
                if ("roleMemberInfo".equals(fieldName)) {
                    deserializedMicrosoftGraphScopedRoleMembership.roleMemberInfo = MicrosoftGraphIdentity.fromJson(reader);
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedMicrosoftGraphScopedRoleMembership.additionalProperties = additionalProperties;
            return deserializedMicrosoftGraphScopedRoleMembership;
        });
    }
}

