// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.authorization.fluent.models.RoleEligibilityScheduleRequestInner;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Role eligibility schedule request list operation result. */
@Fluent
public final class RoleEligibilityScheduleRequestListResult {
    /*
     * Role eligibility schedule request list.
     */
    @JsonProperty(value = "value")
    private List<RoleEligibilityScheduleRequestInner> value;

    /*
     * The URL to use for getting the next set of results.
     */
    @JsonProperty(value = "nextLink")
    private String nextLink;

    /** Creates an instance of RoleEligibilityScheduleRequestListResult class. */
    public RoleEligibilityScheduleRequestListResult() {
    }

    /**
     * Get the value property: Role eligibility schedule request list.
     *
     * @return the value value.
     */
    public List<RoleEligibilityScheduleRequestInner> value() {
        return this.value;
    }

    /**
     * Set the value property: Role eligibility schedule request list.
     *
     * @param value the value value to set.
     * @return the RoleEligibilityScheduleRequestListResult object itself.
     */
    public RoleEligibilityScheduleRequestListResult withValue(List<RoleEligibilityScheduleRequestInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The URL to use for getting the next set of results.
     *
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: The URL to use for getting the next set of results.
     *
     * @param nextLink the nextLink value to set.
     * @return the RoleEligibilityScheduleRequestListResult object itself.
     */
    public RoleEligibilityScheduleRequestListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }
}
