// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/** workbookChart. */
@Fluent
public final class MicrosoftGraphWorkbookChart extends MicrosoftGraphEntity {
    /*
     * Represents the height, in points, of the chart object.
     */
    @JsonProperty(value = "height")
    private Double height;

    /*
     * The distance, in points, from the left side of the chart to the worksheet origin.
     */
    @JsonProperty(value = "left")
    private Double left;

    /*
     * Represents the name of a chart object.
     */
    @JsonProperty(value = "name")
    private String name;

    /*
     * Represents the distance, in points, from the top edge of the object to the top of row 1 (on a worksheet) or the
     * top of the chart area (on a chart).
     */
    @JsonProperty(value = "top")
    private Double top;

    /*
     * Represents the width, in points, of the chart object.
     */
    @JsonProperty(value = "width")
    private Double width;

    /*
     * workbookChartAxes
     */
    @JsonProperty(value = "axes")
    private MicrosoftGraphWorkbookChartAxes axes;

    /*
     * workbookChartDataLabels
     */
    @JsonProperty(value = "dataLabels")
    private MicrosoftGraphWorkbookChartDataLabels dataLabels;

    /*
     * workbookChartAreaFormat
     */
    @JsonProperty(value = "format")
    private MicrosoftGraphWorkbookChartAreaFormat format;

    /*
     * workbookChartLegend
     */
    @JsonProperty(value = "legend")
    private MicrosoftGraphWorkbookChartLegend legend;

    /*
     * Represents either a single series or collection of series in the chart. Read-only.
     */
    @JsonProperty(value = "series")
    private List<MicrosoftGraphWorkbookChartSeries> series;

    /*
     * workbookChartTitle
     */
    @JsonProperty(value = "title")
    private MicrosoftGraphWorkbookChartTitle title;

    /*
     * workbookWorksheet
     */
    @JsonProperty(value = "worksheet")
    private MicrosoftGraphWorkbookWorksheet worksheet;

    /*
     * workbookChart
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /** Creates an instance of MicrosoftGraphWorkbookChart class. */
    public MicrosoftGraphWorkbookChart() {
    }

    /**
     * Get the height property: Represents the height, in points, of the chart object.
     *
     * @return the height value.
     */
    public Double height() {
        return this.height;
    }

    /**
     * Set the height property: Represents the height, in points, of the chart object.
     *
     * @param height the height value to set.
     * @return the MicrosoftGraphWorkbookChart object itself.
     */
    public MicrosoftGraphWorkbookChart withHeight(Double height) {
        this.height = height;
        return this;
    }

    /**
     * Get the left property: The distance, in points, from the left side of the chart to the worksheet origin.
     *
     * @return the left value.
     */
    public Double left() {
        return this.left;
    }

    /**
     * Set the left property: The distance, in points, from the left side of the chart to the worksheet origin.
     *
     * @param left the left value to set.
     * @return the MicrosoftGraphWorkbookChart object itself.
     */
    public MicrosoftGraphWorkbookChart withLeft(Double left) {
        this.left = left;
        return this;
    }

    /**
     * Get the name property: Represents the name of a chart object.
     *
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Represents the name of a chart object.
     *
     * @param name the name value to set.
     * @return the MicrosoftGraphWorkbookChart object itself.
     */
    public MicrosoftGraphWorkbookChart withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the top property: Represents the distance, in points, from the top edge of the object to the top of row 1 (on
     * a worksheet) or the top of the chart area (on a chart).
     *
     * @return the top value.
     */
    public Double top() {
        return this.top;
    }

    /**
     * Set the top property: Represents the distance, in points, from the top edge of the object to the top of row 1 (on
     * a worksheet) or the top of the chart area (on a chart).
     *
     * @param top the top value to set.
     * @return the MicrosoftGraphWorkbookChart object itself.
     */
    public MicrosoftGraphWorkbookChart withTop(Double top) {
        this.top = top;
        return this;
    }

    /**
     * Get the width property: Represents the width, in points, of the chart object.
     *
     * @return the width value.
     */
    public Double width() {
        return this.width;
    }

    /**
     * Set the width property: Represents the width, in points, of the chart object.
     *
     * @param width the width value to set.
     * @return the MicrosoftGraphWorkbookChart object itself.
     */
    public MicrosoftGraphWorkbookChart withWidth(Double width) {
        this.width = width;
        return this;
    }

    /**
     * Get the axes property: workbookChartAxes.
     *
     * @return the axes value.
     */
    public MicrosoftGraphWorkbookChartAxes axes() {
        return this.axes;
    }

    /**
     * Set the axes property: workbookChartAxes.
     *
     * @param axes the axes value to set.
     * @return the MicrosoftGraphWorkbookChart object itself.
     */
    public MicrosoftGraphWorkbookChart withAxes(MicrosoftGraphWorkbookChartAxes axes) {
        this.axes = axes;
        return this;
    }

    /**
     * Get the dataLabels property: workbookChartDataLabels.
     *
     * @return the dataLabels value.
     */
    public MicrosoftGraphWorkbookChartDataLabels dataLabels() {
        return this.dataLabels;
    }

    /**
     * Set the dataLabels property: workbookChartDataLabels.
     *
     * @param dataLabels the dataLabels value to set.
     * @return the MicrosoftGraphWorkbookChart object itself.
     */
    public MicrosoftGraphWorkbookChart withDataLabels(MicrosoftGraphWorkbookChartDataLabels dataLabels) {
        this.dataLabels = dataLabels;
        return this;
    }

    /**
     * Get the format property: workbookChartAreaFormat.
     *
     * @return the format value.
     */
    public MicrosoftGraphWorkbookChartAreaFormat format() {
        return this.format;
    }

    /**
     * Set the format property: workbookChartAreaFormat.
     *
     * @param format the format value to set.
     * @return the MicrosoftGraphWorkbookChart object itself.
     */
    public MicrosoftGraphWorkbookChart withFormat(MicrosoftGraphWorkbookChartAreaFormat format) {
        this.format = format;
        return this;
    }

    /**
     * Get the legend property: workbookChartLegend.
     *
     * @return the legend value.
     */
    public MicrosoftGraphWorkbookChartLegend legend() {
        return this.legend;
    }

    /**
     * Set the legend property: workbookChartLegend.
     *
     * @param legend the legend value to set.
     * @return the MicrosoftGraphWorkbookChart object itself.
     */
    public MicrosoftGraphWorkbookChart withLegend(MicrosoftGraphWorkbookChartLegend legend) {
        this.legend = legend;
        return this;
    }

    /**
     * Get the series property: Represents either a single series or collection of series in the chart. Read-only.
     *
     * @return the series value.
     */
    public List<MicrosoftGraphWorkbookChartSeries> series() {
        return this.series;
    }

    /**
     * Set the series property: Represents either a single series or collection of series in the chart. Read-only.
     *
     * @param series the series value to set.
     * @return the MicrosoftGraphWorkbookChart object itself.
     */
    public MicrosoftGraphWorkbookChart withSeries(List<MicrosoftGraphWorkbookChartSeries> series) {
        this.series = series;
        return this;
    }

    /**
     * Get the title property: workbookChartTitle.
     *
     * @return the title value.
     */
    public MicrosoftGraphWorkbookChartTitle title() {
        return this.title;
    }

    /**
     * Set the title property: workbookChartTitle.
     *
     * @param title the title value to set.
     * @return the MicrosoftGraphWorkbookChart object itself.
     */
    public MicrosoftGraphWorkbookChart withTitle(MicrosoftGraphWorkbookChartTitle title) {
        this.title = title;
        return this;
    }

    /**
     * Get the worksheet property: workbookWorksheet.
     *
     * @return the worksheet value.
     */
    public MicrosoftGraphWorkbookWorksheet worksheet() {
        return this.worksheet;
    }

    /**
     * Set the worksheet property: workbookWorksheet.
     *
     * @param worksheet the worksheet value to set.
     * @return the MicrosoftGraphWorkbookChart object itself.
     */
    public MicrosoftGraphWorkbookChart withWorksheet(MicrosoftGraphWorkbookWorksheet worksheet) {
        this.worksheet = worksheet;
        return this;
    }

    /**
     * Get the additionalProperties property: workbookChart.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: workbookChart.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphWorkbookChart object itself.
     */
    public MicrosoftGraphWorkbookChart withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphWorkbookChart withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (axes() != null) {
            axes().validate();
        }
        if (dataLabels() != null) {
            dataLabels().validate();
        }
        if (format() != null) {
            format().validate();
        }
        if (legend() != null) {
            legend().validate();
        }
        if (series() != null) {
            series().forEach(e -> e.validate());
        }
        if (title() != null) {
            title().validate();
        }
        if (worksheet() != null) {
            worksheet().validate();
        }
    }
}
