// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/** inferenceClassification. */
@Fluent
public final class MicrosoftGraphInferenceClassification extends MicrosoftGraphEntity {
    /*
     * A set of overrides for a user to always classify messages from specific senders in certain ways: focused, or
     * other. Read-only. Nullable.
     */
    @JsonProperty(value = "overrides")
    private List<MicrosoftGraphInferenceClassificationOverride> overrides;

    /*
     * inferenceClassification
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /** Creates an instance of MicrosoftGraphInferenceClassification class. */
    public MicrosoftGraphInferenceClassification() {
    }

    /**
     * Get the overrides property: A set of overrides for a user to always classify messages from specific senders in
     * certain ways: focused, or other. Read-only. Nullable.
     *
     * @return the overrides value.
     */
    public List<MicrosoftGraphInferenceClassificationOverride> overrides() {
        return this.overrides;
    }

    /**
     * Set the overrides property: A set of overrides for a user to always classify messages from specific senders in
     * certain ways: focused, or other. Read-only. Nullable.
     *
     * @param overrides the overrides value to set.
     * @return the MicrosoftGraphInferenceClassification object itself.
     */
    public MicrosoftGraphInferenceClassification withOverrides(
        List<MicrosoftGraphInferenceClassificationOverride> overrides) {
        this.overrides = overrides;
        return this;
    }

    /**
     * Get the additionalProperties property: inferenceClassification.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: inferenceClassification.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphInferenceClassification object itself.
     */
    public MicrosoftGraphInferenceClassification withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphInferenceClassification withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (overrides() != null) {
            overrides().forEach(e -> e.validate());
        }
    }
}
