// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/** directory. */
@Fluent
public final class MicrosoftGraphDirectory extends MicrosoftGraphEntity {
    /*
     * The administrativeUnits property.
     */
    @JsonProperty(value = "administrativeUnits")
    private List<MicrosoftGraphAdministrativeUnit> administrativeUnits;

    /*
     * Recently deleted items. Read-only. Nullable.
     */
    @JsonProperty(value = "deletedItems")
    private List<MicrosoftGraphDirectoryObjectInner> deletedItems;

    /*
     * directory
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /** Creates an instance of MicrosoftGraphDirectory class. */
    public MicrosoftGraphDirectory() {
    }

    /**
     * Get the administrativeUnits property: The administrativeUnits property.
     *
     * @return the administrativeUnits value.
     */
    public List<MicrosoftGraphAdministrativeUnit> administrativeUnits() {
        return this.administrativeUnits;
    }

    /**
     * Set the administrativeUnits property: The administrativeUnits property.
     *
     * @param administrativeUnits the administrativeUnits value to set.
     * @return the MicrosoftGraphDirectory object itself.
     */
    public MicrosoftGraphDirectory withAdministrativeUnits(List<MicrosoftGraphAdministrativeUnit> administrativeUnits) {
        this.administrativeUnits = administrativeUnits;
        return this;
    }

    /**
     * Get the deletedItems property: Recently deleted items. Read-only. Nullable.
     *
     * @return the deletedItems value.
     */
    public List<MicrosoftGraphDirectoryObjectInner> deletedItems() {
        return this.deletedItems;
    }

    /**
     * Set the deletedItems property: Recently deleted items. Read-only. Nullable.
     *
     * @param deletedItems the deletedItems value to set.
     * @return the MicrosoftGraphDirectory object itself.
     */
    public MicrosoftGraphDirectory withDeletedItems(List<MicrosoftGraphDirectoryObjectInner> deletedItems) {
        this.deletedItems = deletedItems;
        return this;
    }

    /**
     * Get the additionalProperties property: directory.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: directory.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphDirectory object itself.
     */
    public MicrosoftGraphDirectory withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphDirectory withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (administrativeUnits() != null) {
            administrativeUnits().forEach(e -> e.validate());
        }
        if (deletedItems() != null) {
            deletedItems().forEach(e -> e.validate());
        }
    }
}
