// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.authorization.models.ExpandedProperties;
import com.azure.resourcemanager.authorization.models.PrincipalType;
import com.azure.resourcemanager.authorization.models.RequestType;
import com.azure.resourcemanager.authorization.models.RoleAssignmentScheduleRequestPropertiesScheduleInfo;
import com.azure.resourcemanager.authorization.models.RoleAssignmentScheduleRequestPropertiesTicketInfo;
import com.azure.resourcemanager.authorization.models.Status;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

/** Role Assignment schedule request. */
@Fluent
public final class RoleAssignmentScheduleRequestInner {
    /*
     * The role assignment schedule request ID.
     */
    @JsonProperty(value = "id", access = JsonProperty.Access.WRITE_ONLY)
    private String id;

    /*
     * The role assignment schedule request name.
     */
    @JsonProperty(value = "name", access = JsonProperty.Access.WRITE_ONLY)
    private String name;

    /*
     * The role assignment schedule request type.
     */
    @JsonProperty(value = "type", access = JsonProperty.Access.WRITE_ONLY)
    private String type;

    /*
     * Role assignment schedule request properties.
     */
    @JsonProperty(value = "properties")
    private RoleAssignmentScheduleRequestProperties innerProperties;

    /** Creates an instance of RoleAssignmentScheduleRequestInner class. */
    public RoleAssignmentScheduleRequestInner() {
    }

    /**
     * Get the id property: The role assignment schedule request ID.
     *
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Get the name property: The role assignment schedule request name.
     *
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Get the type property: The role assignment schedule request type.
     *
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * Get the innerProperties property: Role assignment schedule request properties.
     *
     * @return the innerProperties value.
     */
    private RoleAssignmentScheduleRequestProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the scope property: The role assignment schedule request scope.
     *
     * @return the scope value.
     */
    public String scope() {
        return this.innerProperties() == null ? null : this.innerProperties().scope();
    }

    /**
     * Get the roleDefinitionId property: The role definition ID.
     *
     * @return the roleDefinitionId value.
     */
    public String roleDefinitionId() {
        return this.innerProperties() == null ? null : this.innerProperties().roleDefinitionId();
    }

    /**
     * Set the roleDefinitionId property: The role definition ID.
     *
     * @param roleDefinitionId the roleDefinitionId value to set.
     * @return the RoleAssignmentScheduleRequestInner object itself.
     */
    public RoleAssignmentScheduleRequestInner withRoleDefinitionId(String roleDefinitionId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RoleAssignmentScheduleRequestProperties();
        }
        this.innerProperties().withRoleDefinitionId(roleDefinitionId);
        return this;
    }

    /**
     * Get the principalId property: The principal ID.
     *
     * @return the principalId value.
     */
    public String principalId() {
        return this.innerProperties() == null ? null : this.innerProperties().principalId();
    }

    /**
     * Set the principalId property: The principal ID.
     *
     * @param principalId the principalId value to set.
     * @return the RoleAssignmentScheduleRequestInner object itself.
     */
    public RoleAssignmentScheduleRequestInner withPrincipalId(String principalId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RoleAssignmentScheduleRequestProperties();
        }
        this.innerProperties().withPrincipalId(principalId);
        return this;
    }

    /**
     * Get the principalType property: The principal type of the assigned principal ID.
     *
     * @return the principalType value.
     */
    public PrincipalType principalType() {
        return this.innerProperties() == null ? null : this.innerProperties().principalType();
    }

    /**
     * Get the requestType property: The type of the role assignment schedule request. Eg: SelfActivate, AdminAssign
     * etc.
     *
     * @return the requestType value.
     */
    public RequestType requestType() {
        return this.innerProperties() == null ? null : this.innerProperties().requestType();
    }

    /**
     * Set the requestType property: The type of the role assignment schedule request. Eg: SelfActivate, AdminAssign
     * etc.
     *
     * @param requestType the requestType value to set.
     * @return the RoleAssignmentScheduleRequestInner object itself.
     */
    public RoleAssignmentScheduleRequestInner withRequestType(RequestType requestType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RoleAssignmentScheduleRequestProperties();
        }
        this.innerProperties().withRequestType(requestType);
        return this;
    }

    /**
     * Get the status property: The status of the role assignment schedule request.
     *
     * @return the status value.
     */
    public Status status() {
        return this.innerProperties() == null ? null : this.innerProperties().status();
    }

    /**
     * Get the approvalId property: The approvalId of the role assignment schedule request.
     *
     * @return the approvalId value.
     */
    public String approvalId() {
        return this.innerProperties() == null ? null : this.innerProperties().approvalId();
    }

    /**
     * Get the targetRoleAssignmentScheduleId property: The resultant role assignment schedule id or the role assignment
     * schedule id being updated.
     *
     * @return the targetRoleAssignmentScheduleId value.
     */
    public String targetRoleAssignmentScheduleId() {
        return this.innerProperties() == null ? null : this.innerProperties().targetRoleAssignmentScheduleId();
    }

    /**
     * Set the targetRoleAssignmentScheduleId property: The resultant role assignment schedule id or the role assignment
     * schedule id being updated.
     *
     * @param targetRoleAssignmentScheduleId the targetRoleAssignmentScheduleId value to set.
     * @return the RoleAssignmentScheduleRequestInner object itself.
     */
    public RoleAssignmentScheduleRequestInner withTargetRoleAssignmentScheduleId(
        String targetRoleAssignmentScheduleId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RoleAssignmentScheduleRequestProperties();
        }
        this.innerProperties().withTargetRoleAssignmentScheduleId(targetRoleAssignmentScheduleId);
        return this;
    }

    /**
     * Get the targetRoleAssignmentScheduleInstanceId property: The role assignment schedule instance id being updated.
     *
     * @return the targetRoleAssignmentScheduleInstanceId value.
     */
    public String targetRoleAssignmentScheduleInstanceId() {
        return this.innerProperties() == null ? null : this.innerProperties().targetRoleAssignmentScheduleInstanceId();
    }

    /**
     * Set the targetRoleAssignmentScheduleInstanceId property: The role assignment schedule instance id being updated.
     *
     * @param targetRoleAssignmentScheduleInstanceId the targetRoleAssignmentScheduleInstanceId value to set.
     * @return the RoleAssignmentScheduleRequestInner object itself.
     */
    public RoleAssignmentScheduleRequestInner withTargetRoleAssignmentScheduleInstanceId(
        String targetRoleAssignmentScheduleInstanceId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RoleAssignmentScheduleRequestProperties();
        }
        this.innerProperties().withTargetRoleAssignmentScheduleInstanceId(targetRoleAssignmentScheduleInstanceId);
        return this;
    }

    /**
     * Get the scheduleInfo property: Schedule info of the role assignment schedule.
     *
     * @return the scheduleInfo value.
     */
    public RoleAssignmentScheduleRequestPropertiesScheduleInfo scheduleInfo() {
        return this.innerProperties() == null ? null : this.innerProperties().scheduleInfo();
    }

    /**
     * Set the scheduleInfo property: Schedule info of the role assignment schedule.
     *
     * @param scheduleInfo the scheduleInfo value to set.
     * @return the RoleAssignmentScheduleRequestInner object itself.
     */
    public RoleAssignmentScheduleRequestInner withScheduleInfo(
        RoleAssignmentScheduleRequestPropertiesScheduleInfo scheduleInfo) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RoleAssignmentScheduleRequestProperties();
        }
        this.innerProperties().withScheduleInfo(scheduleInfo);
        return this;
    }

    /**
     * Get the linkedRoleEligibilityScheduleId property: The linked role eligibility schedule id - to activate an
     * eligibility.
     *
     * @return the linkedRoleEligibilityScheduleId value.
     */
    public String linkedRoleEligibilityScheduleId() {
        return this.innerProperties() == null ? null : this.innerProperties().linkedRoleEligibilityScheduleId();
    }

    /**
     * Set the linkedRoleEligibilityScheduleId property: The linked role eligibility schedule id - to activate an
     * eligibility.
     *
     * @param linkedRoleEligibilityScheduleId the linkedRoleEligibilityScheduleId value to set.
     * @return the RoleAssignmentScheduleRequestInner object itself.
     */
    public RoleAssignmentScheduleRequestInner withLinkedRoleEligibilityScheduleId(
        String linkedRoleEligibilityScheduleId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RoleAssignmentScheduleRequestProperties();
        }
        this.innerProperties().withLinkedRoleEligibilityScheduleId(linkedRoleEligibilityScheduleId);
        return this;
    }

    /**
     * Get the justification property: Justification for the role assignment.
     *
     * @return the justification value.
     */
    public String justification() {
        return this.innerProperties() == null ? null : this.innerProperties().justification();
    }

    /**
     * Set the justification property: Justification for the role assignment.
     *
     * @param justification the justification value to set.
     * @return the RoleAssignmentScheduleRequestInner object itself.
     */
    public RoleAssignmentScheduleRequestInner withJustification(String justification) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RoleAssignmentScheduleRequestProperties();
        }
        this.innerProperties().withJustification(justification);
        return this;
    }

    /**
     * Get the ticketInfo property: Ticket Info of the role assignment.
     *
     * @return the ticketInfo value.
     */
    public RoleAssignmentScheduleRequestPropertiesTicketInfo ticketInfo() {
        return this.innerProperties() == null ? null : this.innerProperties().ticketInfo();
    }

    /**
     * Set the ticketInfo property: Ticket Info of the role assignment.
     *
     * @param ticketInfo the ticketInfo value to set.
     * @return the RoleAssignmentScheduleRequestInner object itself.
     */
    public RoleAssignmentScheduleRequestInner withTicketInfo(
        RoleAssignmentScheduleRequestPropertiesTicketInfo ticketInfo) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RoleAssignmentScheduleRequestProperties();
        }
        this.innerProperties().withTicketInfo(ticketInfo);
        return this;
    }

    /**
     * Get the condition property: The conditions on the role assignment. This limits the resources it can be assigned
     * to. e.g.: @Resource[Microsoft.Storage/storageAccounts/blobServices/containers:ContainerName]
     * StringEqualsIgnoreCase 'foo_storage_container'.
     *
     * @return the condition value.
     */
    public String condition() {
        return this.innerProperties() == null ? null : this.innerProperties().condition();
    }

    /**
     * Set the condition property: The conditions on the role assignment. This limits the resources it can be assigned
     * to. e.g.: @Resource[Microsoft.Storage/storageAccounts/blobServices/containers:ContainerName]
     * StringEqualsIgnoreCase 'foo_storage_container'.
     *
     * @param condition the condition value to set.
     * @return the RoleAssignmentScheduleRequestInner object itself.
     */
    public RoleAssignmentScheduleRequestInner withCondition(String condition) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RoleAssignmentScheduleRequestProperties();
        }
        this.innerProperties().withCondition(condition);
        return this;
    }

    /**
     * Get the conditionVersion property: Version of the condition. Currently accepted value is '2.0'.
     *
     * @return the conditionVersion value.
     */
    public String conditionVersion() {
        return this.innerProperties() == null ? null : this.innerProperties().conditionVersion();
    }

    /**
     * Set the conditionVersion property: Version of the condition. Currently accepted value is '2.0'.
     *
     * @param conditionVersion the conditionVersion value to set.
     * @return the RoleAssignmentScheduleRequestInner object itself.
     */
    public RoleAssignmentScheduleRequestInner withConditionVersion(String conditionVersion) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RoleAssignmentScheduleRequestProperties();
        }
        this.innerProperties().withConditionVersion(conditionVersion);
        return this;
    }

    /**
     * Get the createdOn property: DateTime when role assignment schedule request was created.
     *
     * @return the createdOn value.
     */
    public OffsetDateTime createdOn() {
        return this.innerProperties() == null ? null : this.innerProperties().createdOn();
    }

    /**
     * Get the requestorId property: Id of the user who created this request.
     *
     * @return the requestorId value.
     */
    public String requestorId() {
        return this.innerProperties() == null ? null : this.innerProperties().requestorId();
    }

    /**
     * Get the expandedProperties property: Additional properties of principal, scope and role definition.
     *
     * @return the expandedProperties value.
     */
    public ExpandedProperties expandedProperties() {
        return this.innerProperties() == null ? null : this.innerProperties().expandedProperties();
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
