// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;

/** plannerProgressTaskBoardTaskFormat. */
@Fluent
public final class MicrosoftGraphPlannerProgressTaskBoardTaskFormat extends MicrosoftGraphEntity {
    /*
     * Hint value used to order the task on the Progress view of the Task Board. The format is defined as outlined
     * here.
     */
    @JsonProperty(value = "orderHint")
    private String orderHint;

    /*
     * plannerProgressTaskBoardTaskFormat
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /** Creates an instance of MicrosoftGraphPlannerProgressTaskBoardTaskFormat class. */
    public MicrosoftGraphPlannerProgressTaskBoardTaskFormat() {
    }

    /**
     * Get the orderHint property: Hint value used to order the task on the Progress view of the Task Board. The format
     * is defined as outlined here.
     *
     * @return the orderHint value.
     */
    public String orderHint() {
        return this.orderHint;
    }

    /**
     * Set the orderHint property: Hint value used to order the task on the Progress view of the Task Board. The format
     * is defined as outlined here.
     *
     * @param orderHint the orderHint value to set.
     * @return the MicrosoftGraphPlannerProgressTaskBoardTaskFormat object itself.
     */
    public MicrosoftGraphPlannerProgressTaskBoardTaskFormat withOrderHint(String orderHint) {
        this.orderHint = orderHint;
        return this;
    }

    /**
     * Get the additionalProperties property: plannerProgressTaskBoardTaskFormat.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: plannerProgressTaskBoardTaskFormat.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphPlannerProgressTaskBoardTaskFormat object itself.
     */
    public MicrosoftGraphPlannerProgressTaskBoardTaskFormat withAdditionalProperties(
        Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphPlannerProgressTaskBoardTaskFormat withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }
}
