// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;

/** chatMessageReaction. */
@Fluent
public final class MicrosoftGraphChatMessageReaction {
    /*
     * The createdDateTime property.
     */
    @JsonProperty(value = "createdDateTime")
    private OffsetDateTime createdDateTime;

    /*
     * The reactionType property.
     */
    @JsonProperty(value = "reactionType")
    private String reactionType;

    /*
     * identitySet
     */
    @JsonProperty(value = "user")
    private MicrosoftGraphIdentitySet user;

    /*
     * chatMessageReaction
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /** Creates an instance of MicrosoftGraphChatMessageReaction class. */
    public MicrosoftGraphChatMessageReaction() {
    }

    /**
     * Get the createdDateTime property: The createdDateTime property.
     *
     * @return the createdDateTime value.
     */
    public OffsetDateTime createdDateTime() {
        return this.createdDateTime;
    }

    /**
     * Set the createdDateTime property: The createdDateTime property.
     *
     * @param createdDateTime the createdDateTime value to set.
     * @return the MicrosoftGraphChatMessageReaction object itself.
     */
    public MicrosoftGraphChatMessageReaction withCreatedDateTime(OffsetDateTime createdDateTime) {
        this.createdDateTime = createdDateTime;
        return this;
    }

    /**
     * Get the reactionType property: The reactionType property.
     *
     * @return the reactionType value.
     */
    public String reactionType() {
        return this.reactionType;
    }

    /**
     * Set the reactionType property: The reactionType property.
     *
     * @param reactionType the reactionType value to set.
     * @return the MicrosoftGraphChatMessageReaction object itself.
     */
    public MicrosoftGraphChatMessageReaction withReactionType(String reactionType) {
        this.reactionType = reactionType;
        return this;
    }

    /**
     * Get the user property: identitySet.
     *
     * @return the user value.
     */
    public MicrosoftGraphIdentitySet user() {
        return this.user;
    }

    /**
     * Set the user property: identitySet.
     *
     * @param user the user value to set.
     * @return the MicrosoftGraphChatMessageReaction object itself.
     */
    public MicrosoftGraphChatMessageReaction withUser(MicrosoftGraphIdentitySet user) {
        this.user = user;
        return this;
    }

    /**
     * Get the additionalProperties property: chatMessageReaction.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: chatMessageReaction.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphChatMessageReaction object itself.
     */
    public MicrosoftGraphChatMessageReaction withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (user() != null) {
            user().validate();
        }
    }
}
