// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

/** addIn. */
@Fluent
public final class MicrosoftGraphAddIn {
    /*
     * The id property.
     */
    @JsonProperty(value = "id")
    private UUID id;

    /*
     * The properties property.
     */
    @JsonProperty(value = "properties")
    private List<MicrosoftGraphKeyValue> properties;

    /*
     * The type property.
     */
    @JsonProperty(value = "type")
    private String type;

    /*
     * addIn
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /** Creates an instance of MicrosoftGraphAddIn class. */
    public MicrosoftGraphAddIn() {
    }

    /**
     * Get the id property: The id property.
     *
     * @return the id value.
     */
    public UUID id() {
        return this.id;
    }

    /**
     * Set the id property: The id property.
     *
     * @param id the id value to set.
     * @return the MicrosoftGraphAddIn object itself.
     */
    public MicrosoftGraphAddIn withId(UUID id) {
        this.id = id;
        return this;
    }

    /**
     * Get the properties property: The properties property.
     *
     * @return the properties value.
     */
    public List<MicrosoftGraphKeyValue> properties() {
        return this.properties;
    }

    /**
     * Set the properties property: The properties property.
     *
     * @param properties the properties value to set.
     * @return the MicrosoftGraphAddIn object itself.
     */
    public MicrosoftGraphAddIn withProperties(List<MicrosoftGraphKeyValue> properties) {
        this.properties = properties;
        return this;
    }

    /**
     * Get the type property: The type property.
     *
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * Set the type property: The type property.
     *
     * @param type the type value to set.
     * @return the MicrosoftGraphAddIn object itself.
     */
    public MicrosoftGraphAddIn withType(String type) {
        this.type = type;
        return this;
    }

    /**
     * Get the additionalProperties property: addIn.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: addIn.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphAddIn object itself.
     */
    public MicrosoftGraphAddIn withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (properties() != null) {
            properties().forEach(e -> e.validate());
        }
    }
}
