// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.implementation;

import com.azure.core.annotation.ServiceClient;
import com.azure.core.http.HttpPipeline;
import com.azure.core.management.AzureEnvironment;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.authorization.fluent.ApplicationsApplicationsClient;
import com.azure.resourcemanager.authorization.fluent.ApplicationsClient;
import com.azure.resourcemanager.authorization.fluent.DomainsDomainsClient;
import com.azure.resourcemanager.authorization.fluent.GroupsClient;
import com.azure.resourcemanager.authorization.fluent.GroupsGroupsClient;
import com.azure.resourcemanager.authorization.fluent.MicrosoftGraphClient;
import com.azure.resourcemanager.authorization.fluent.ServicePrincipalsClient;
import com.azure.resourcemanager.authorization.fluent.ServicePrincipalsServicePrincipalsClient;
import com.azure.resourcemanager.authorization.fluent.UsersUsersClient;
import com.azure.resourcemanager.resources.fluentcore.AzureServiceClient;
import java.time.Duration;

/** Initializes a new instance of the MicrosoftGraphClientImpl type. */
@ServiceClient(builder = MicrosoftGraphClientBuilder.class)
public final class MicrosoftGraphClientImpl extends AzureServiceClient implements MicrosoftGraphClient {
    /** server parameter. */
    private final String endpoint;

    /**
     * Gets server parameter.
     *
     * @return the endpoint value.
     */
    public String getEndpoint() {
        return this.endpoint;
    }

    /** The HTTP pipeline to send requests through. */
    private final HttpPipeline httpPipeline;

    /**
     * Gets The HTTP pipeline to send requests through.
     *
     * @return the httpPipeline value.
     */
    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    /** The serializer to serialize an object into a string. */
    private final SerializerAdapter serializerAdapter;

    /**
     * Gets The serializer to serialize an object into a string.
     *
     * @return the serializerAdapter value.
     */
    SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    /** The default poll interval for long-running operation. */
    private final Duration defaultPollInterval;

    /**
     * Gets The default poll interval for long-running operation.
     *
     * @return the defaultPollInterval value.
     */
    public Duration getDefaultPollInterval() {
        return this.defaultPollInterval;
    }

    /** The ApplicationsApplicationsClient object to access its operations. */
    private final ApplicationsApplicationsClient applicationsApplications;

    /**
     * Gets the ApplicationsApplicationsClient object to access its operations.
     *
     * @return the ApplicationsApplicationsClient object.
     */
    public ApplicationsApplicationsClient getApplicationsApplications() {
        return this.applicationsApplications;
    }

    /** The ApplicationsClient object to access its operations. */
    private final ApplicationsClient applications;

    /**
     * Gets the ApplicationsClient object to access its operations.
     *
     * @return the ApplicationsClient object.
     */
    public ApplicationsClient getApplications() {
        return this.applications;
    }

    /** The ServicePrincipalsServicePrincipalsClient object to access its operations. */
    private final ServicePrincipalsServicePrincipalsClient servicePrincipalsServicePrincipals;

    /**
     * Gets the ServicePrincipalsServicePrincipalsClient object to access its operations.
     *
     * @return the ServicePrincipalsServicePrincipalsClient object.
     */
    public ServicePrincipalsServicePrincipalsClient getServicePrincipalsServicePrincipals() {
        return this.servicePrincipalsServicePrincipals;
    }

    /** The ServicePrincipalsClient object to access its operations. */
    private final ServicePrincipalsClient servicePrincipals;

    /**
     * Gets the ServicePrincipalsClient object to access its operations.
     *
     * @return the ServicePrincipalsClient object.
     */
    public ServicePrincipalsClient getServicePrincipals() {
        return this.servicePrincipals;
    }

    /** The GroupsGroupsClient object to access its operations. */
    private final GroupsGroupsClient groupsGroups;

    /**
     * Gets the GroupsGroupsClient object to access its operations.
     *
     * @return the GroupsGroupsClient object.
     */
    public GroupsGroupsClient getGroupsGroups() {
        return this.groupsGroups;
    }

    /** The GroupsClient object to access its operations. */
    private final GroupsClient groups;

    /**
     * Gets the GroupsClient object to access its operations.
     *
     * @return the GroupsClient object.
     */
    public GroupsClient getGroups() {
        return this.groups;
    }

    /** The UsersUsersClient object to access its operations. */
    private final UsersUsersClient usersUsers;

    /**
     * Gets the UsersUsersClient object to access its operations.
     *
     * @return the UsersUsersClient object.
     */
    public UsersUsersClient getUsersUsers() {
        return this.usersUsers;
    }

    /** The DomainsDomainsClient object to access its operations. */
    private final DomainsDomainsClient domainsDomains;

    /**
     * Gets the DomainsDomainsClient object to access its operations.
     *
     * @return the DomainsDomainsClient object.
     */
    public DomainsDomainsClient getDomainsDomains() {
        return this.domainsDomains;
    }

    /**
     * Initializes an instance of MicrosoftGraphClient client.
     *
     * @param httpPipeline The HTTP pipeline to send requests through.
     * @param serializerAdapter The serializer to serialize an object into a string.
     * @param defaultPollInterval The default poll interval for long-running operation.
     * @param environment The Azure environment.
     * @param endpoint server parameter.
     */
    MicrosoftGraphClientImpl(
        HttpPipeline httpPipeline,
        SerializerAdapter serializerAdapter,
        Duration defaultPollInterval,
        AzureEnvironment environment,
        String endpoint) {
        super(httpPipeline, serializerAdapter, environment);
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.defaultPollInterval = defaultPollInterval;
        this.endpoint = endpoint;
        this.applicationsApplications = new ApplicationsApplicationsClientImpl(this);
        this.applications = new ApplicationsClientImpl(this);
        this.servicePrincipalsServicePrincipals = new ServicePrincipalsServicePrincipalsClientImpl(this);
        this.servicePrincipals = new ServicePrincipalsClientImpl(this);
        this.groupsGroups = new GroupsGroupsClientImpl(this);
        this.groups = new GroupsClientImpl(this);
        this.usersUsers = new UsersUsersClientImpl(this);
        this.domainsDomains = new DomainsDomainsClientImpl(this);
    }
}
