// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/** workbookComment. */
@Fluent
public final class MicrosoftGraphWorkbookComment extends MicrosoftGraphEntity {
    /*
     * The content of comment.
     */
    @JsonProperty(value = "content")
    private String content;

    /*
     * Indicates the type for the comment.
     */
    @JsonProperty(value = "contentType")
    private String contentType;

    /*
     * Read-only. Nullable.
     */
    @JsonProperty(value = "replies")
    private List<MicrosoftGraphWorkbookCommentReply> replies;

    /*
     * workbookComment
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /** Creates an instance of MicrosoftGraphWorkbookComment class. */
    public MicrosoftGraphWorkbookComment() {
    }

    /**
     * Get the content property: The content of comment.
     *
     * @return the content value.
     */
    public String content() {
        return this.content;
    }

    /**
     * Set the content property: The content of comment.
     *
     * @param content the content value to set.
     * @return the MicrosoftGraphWorkbookComment object itself.
     */
    public MicrosoftGraphWorkbookComment withContent(String content) {
        this.content = content;
        return this;
    }

    /**
     * Get the contentType property: Indicates the type for the comment.
     *
     * @return the contentType value.
     */
    public String contentType() {
        return this.contentType;
    }

    /**
     * Set the contentType property: Indicates the type for the comment.
     *
     * @param contentType the contentType value to set.
     * @return the MicrosoftGraphWorkbookComment object itself.
     */
    public MicrosoftGraphWorkbookComment withContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    /**
     * Get the replies property: Read-only. Nullable.
     *
     * @return the replies value.
     */
    public List<MicrosoftGraphWorkbookCommentReply> replies() {
        return this.replies;
    }

    /**
     * Set the replies property: Read-only. Nullable.
     *
     * @param replies the replies value to set.
     * @return the MicrosoftGraphWorkbookComment object itself.
     */
    public MicrosoftGraphWorkbookComment withReplies(List<MicrosoftGraphWorkbookCommentReply> replies) {
        this.replies = replies;
        return this;
    }

    /**
     * Get the additionalProperties property: workbookComment.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: workbookComment.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphWorkbookComment object itself.
     */
    public MicrosoftGraphWorkbookComment withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphWorkbookComment withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (replies() != null) {
            replies().forEach(e -> e.validate());
        }
    }
}
