// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;

/** outlookCategory. */
@Fluent
public final class MicrosoftGraphOutlookCategory extends MicrosoftGraphEntity {
    /*
     * categoryColor
     */
    @JsonProperty(value = "color")
    private MicrosoftGraphCategoryColor color;

    /*
     * A unique name that identifies a category in the user's mailbox. After a category is created, the name cannot be
     * changed. Read-only.
     */
    @JsonProperty(value = "displayName")
    private String displayName;

    /*
     * outlookCategory
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /** Creates an instance of MicrosoftGraphOutlookCategory class. */
    public MicrosoftGraphOutlookCategory() {
    }

    /**
     * Get the color property: categoryColor.
     *
     * @return the color value.
     */
    public MicrosoftGraphCategoryColor color() {
        return this.color;
    }

    /**
     * Set the color property: categoryColor.
     *
     * @param color the color value to set.
     * @return the MicrosoftGraphOutlookCategory object itself.
     */
    public MicrosoftGraphOutlookCategory withColor(MicrosoftGraphCategoryColor color) {
        this.color = color;
        return this;
    }

    /**
     * Get the displayName property: A unique name that identifies a category in the user's mailbox. After a category is
     * created, the name cannot be changed. Read-only.
     *
     * @return the displayName value.
     */
    public String displayName() {
        return this.displayName;
    }

    /**
     * Set the displayName property: A unique name that identifies a category in the user's mailbox. After a category is
     * created, the name cannot be changed. Read-only.
     *
     * @param displayName the displayName value to set.
     * @return the MicrosoftGraphOutlookCategory object itself.
     */
    public MicrosoftGraphOutlookCategory withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    /**
     * Get the additionalProperties property: outlookCategory.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: outlookCategory.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphOutlookCategory object itself.
     */
    public MicrosoftGraphOutlookCategory withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphOutlookCategory withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }
}
