// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;

/** licenseUnitsDetail. */
@Fluent
public final class MicrosoftGraphLicenseUnitsDetail {
    /*
     * The number of units that are enabled.
     */
    @JsonProperty(value = "enabled")
    private Integer enabled;

    /*
     * The number of units that are suspended.
     */
    @JsonProperty(value = "suspended")
    private Integer suspended;

    /*
     * The number of units that are in warning status.
     */
    @JsonProperty(value = "warning")
    private Integer warning;

    /*
     * licenseUnitsDetail
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /** Creates an instance of MicrosoftGraphLicenseUnitsDetail class. */
    public MicrosoftGraphLicenseUnitsDetail() {
    }

    /**
     * Get the enabled property: The number of units that are enabled.
     *
     * @return the enabled value.
     */
    public Integer enabled() {
        return this.enabled;
    }

    /**
     * Set the enabled property: The number of units that are enabled.
     *
     * @param enabled the enabled value to set.
     * @return the MicrosoftGraphLicenseUnitsDetail object itself.
     */
    public MicrosoftGraphLicenseUnitsDetail withEnabled(Integer enabled) {
        this.enabled = enabled;
        return this;
    }

    /**
     * Get the suspended property: The number of units that are suspended.
     *
     * @return the suspended value.
     */
    public Integer suspended() {
        return this.suspended;
    }

    /**
     * Set the suspended property: The number of units that are suspended.
     *
     * @param suspended the suspended value to set.
     * @return the MicrosoftGraphLicenseUnitsDetail object itself.
     */
    public MicrosoftGraphLicenseUnitsDetail withSuspended(Integer suspended) {
        this.suspended = suspended;
        return this;
    }

    /**
     * Get the warning property: The number of units that are in warning status.
     *
     * @return the warning value.
     */
    public Integer warning() {
        return this.warning;
    }

    /**
     * Set the warning property: The number of units that are in warning status.
     *
     * @param warning the warning value to set.
     * @return the MicrosoftGraphLicenseUnitsDetail object itself.
     */
    public MicrosoftGraphLicenseUnitsDetail withWarning(Integer warning) {
        this.warning = warning;
        return this;
    }

    /**
     * Get the additionalProperties property: licenseUnitsDetail.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: licenseUnitsDetail.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphLicenseUnitsDetail object itself.
     */
    public MicrosoftGraphLicenseUnitsDetail withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
