// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;

/** attachmentItem. */
@Fluent
public final class MicrosoftGraphAttachmentItem {
    /*
     * attachmentType
     */
    @JsonProperty(value = "attachmentType")
    private MicrosoftGraphAttachmentType attachmentType;

    /*
     * The nature of the data in the attachment. Optional.
     */
    @JsonProperty(value = "contentType")
    private String contentType;

    /*
     * true if the attachment is an inline attachment; otherwise, false. Optional.
     */
    @JsonProperty(value = "isInline")
    private Boolean isInline;

    /*
     * The display name of the attachment. This can be a descriptive string and does not have to be the actual file
     * name. Required.
     */
    @JsonProperty(value = "name")
    private String name;

    /*
     * The length of the attachment in bytes. Required.
     */
    @JsonProperty(value = "size")
    private Long size;

    /*
     * attachmentItem
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /** Creates an instance of MicrosoftGraphAttachmentItem class. */
    public MicrosoftGraphAttachmentItem() {
    }

    /**
     * Get the attachmentType property: attachmentType.
     *
     * @return the attachmentType value.
     */
    public MicrosoftGraphAttachmentType attachmentType() {
        return this.attachmentType;
    }

    /**
     * Set the attachmentType property: attachmentType.
     *
     * @param attachmentType the attachmentType value to set.
     * @return the MicrosoftGraphAttachmentItem object itself.
     */
    public MicrosoftGraphAttachmentItem withAttachmentType(MicrosoftGraphAttachmentType attachmentType) {
        this.attachmentType = attachmentType;
        return this;
    }

    /**
     * Get the contentType property: The nature of the data in the attachment. Optional.
     *
     * @return the contentType value.
     */
    public String contentType() {
        return this.contentType;
    }

    /**
     * Set the contentType property: The nature of the data in the attachment. Optional.
     *
     * @param contentType the contentType value to set.
     * @return the MicrosoftGraphAttachmentItem object itself.
     */
    public MicrosoftGraphAttachmentItem withContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    /**
     * Get the isInline property: true if the attachment is an inline attachment; otherwise, false. Optional.
     *
     * @return the isInline value.
     */
    public Boolean isInline() {
        return this.isInline;
    }

    /**
     * Set the isInline property: true if the attachment is an inline attachment; otherwise, false. Optional.
     *
     * @param isInline the isInline value to set.
     * @return the MicrosoftGraphAttachmentItem object itself.
     */
    public MicrosoftGraphAttachmentItem withIsInline(Boolean isInline) {
        this.isInline = isInline;
        return this;
    }

    /**
     * Get the name property: The display name of the attachment. This can be a descriptive string and does not have to
     * be the actual file name. Required.
     *
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The display name of the attachment. This can be a descriptive string and does not have to
     * be the actual file name. Required.
     *
     * @param name the name value to set.
     * @return the MicrosoftGraphAttachmentItem object itself.
     */
    public MicrosoftGraphAttachmentItem withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the size property: The length of the attachment in bytes. Required.
     *
     * @return the size value.
     */
    public Long size() {
        return this.size;
    }

    /**
     * Set the size property: The length of the attachment in bytes. Required.
     *
     * @param size the size value to set.
     * @return the MicrosoftGraphAttachmentItem object itself.
     */
    public MicrosoftGraphAttachmentItem withSize(Long size) {
        this.size = size;
        return this;
    }

    /**
     * Get the additionalProperties property: attachmentItem.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: attachmentItem.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphAttachmentItem object itself.
     */
    public MicrosoftGraphAttachmentItem withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
