/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.CollectionFormat;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.authorization.fluent.DirectoriesClient;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfAdministrativeUnit;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfDirectoryObject7;
import com.azure.resourcemanager.authorization.fluent.models.DirectoryExpand;
import com.azure.resourcemanager.authorization.fluent.models.DirectoryOrderby;
import com.azure.resourcemanager.authorization.fluent.models.DirectorySelect;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphAdministrativeUnitInner;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphDirectoryObjectInner;
import com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException;
import com.azure.resourcemanager.authorization.implementation.MicrosoftGraphClientImpl;
import java.util.List;
import reactor.core.publisher.Mono;

public final class DirectoriesClientImpl
implements DirectoriesClient {
    private final ClientLogger logger = new ClientLogger(DirectoriesClientImpl.class);
    private final DirectoriesService service;
    private final MicrosoftGraphClientImpl client;

    DirectoriesClientImpl(MicrosoftGraphClientImpl client) {
        this.service = (DirectoriesService)RestProxy.create(DirectoriesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    private Mono<PagedResponse<MicrosoftGraphAdministrativeUnitInner>> listAdministrativeUnitsSinglePageAsync(Integer top, Integer skip, String search, String filter, Boolean count, List<DirectoryOrderby> orderby, List<DirectorySelect> select, List<DirectoryExpand> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.listAdministrativeUnits(this.client.getEndpoint(), top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfAdministrativeUnit)res.getValue()).value(), ((CollectionOfAdministrativeUnit)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<MicrosoftGraphAdministrativeUnitInner>> listAdministrativeUnitsSinglePageAsync(Integer top, Integer skip, String search, String filter, Boolean count, List<DirectoryOrderby> orderby, List<DirectorySelect> select, List<DirectoryExpand> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.listAdministrativeUnits(this.client.getEndpoint(), top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfAdministrativeUnit)res.getValue()).value(), ((CollectionOfAdministrativeUnit)res.getValue()).odataNextLink(), null));
    }

    @Override
    public PagedFlux<MicrosoftGraphAdministrativeUnitInner> listAdministrativeUnitsAsync(Integer top, Integer skip, String search, String filter, Boolean count, List<DirectoryOrderby> orderby, List<DirectorySelect> select, List<DirectoryExpand> expand) {
        return new PagedFlux(() -> this.listAdministrativeUnitsSinglePageAsync(top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listMoreSinglePageAsync((String)nextLink));
    }

    @Override
    public PagedFlux<MicrosoftGraphAdministrativeUnitInner> listAdministrativeUnitsAsync() {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List orderby = null;
        List select = null;
        List expand = null;
        return new PagedFlux(() -> this.listAdministrativeUnitsSinglePageAsync(top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listMoreSinglePageAsync((String)nextLink));
    }

    private PagedFlux<MicrosoftGraphAdministrativeUnitInner> listAdministrativeUnitsAsync(Integer top, Integer skip, String search, String filter, Boolean count, List<DirectoryOrderby> orderby, List<DirectorySelect> select, List<DirectoryExpand> expand, Context context) {
        return new PagedFlux(() -> this.listAdministrativeUnitsSinglePageAsync(top, skip, search, filter, count, orderby, select, expand, context), nextLink -> this.listMoreSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<MicrosoftGraphAdministrativeUnitInner> listAdministrativeUnits() {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List<DirectoryOrderby> orderby = null;
        List<DirectorySelect> select = null;
        List<DirectoryExpand> expand = null;
        return new PagedIterable(this.listAdministrativeUnitsAsync(top, skip, search, filter, count, orderby, select, expand));
    }

    @Override
    public PagedIterable<MicrosoftGraphAdministrativeUnitInner> listAdministrativeUnits(Integer top, Integer skip, String search, String filter, Boolean count, List<DirectoryOrderby> orderby, List<DirectorySelect> select, List<DirectoryExpand> expand, Context context) {
        return new PagedIterable(this.listAdministrativeUnitsAsync(top, skip, search, filter, count, orderby, select, expand, context));
    }

    @Override
    public Mono<Response<MicrosoftGraphAdministrativeUnitInner>> createAdministrativeUnitsWithResponseAsync(MicrosoftGraphAdministrativeUnitInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createAdministrativeUnits(this.client.getEndpoint(), body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<MicrosoftGraphAdministrativeUnitInner>> createAdministrativeUnitsWithResponseAsync(MicrosoftGraphAdministrativeUnitInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createAdministrativeUnits(this.client.getEndpoint(), body, "application/json", context);
    }

    @Override
    public Mono<MicrosoftGraphAdministrativeUnitInner> createAdministrativeUnitsAsync(MicrosoftGraphAdministrativeUnitInner body) {
        return this.createAdministrativeUnitsWithResponseAsync(body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphAdministrativeUnitInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public MicrosoftGraphAdministrativeUnitInner createAdministrativeUnits(MicrosoftGraphAdministrativeUnitInner body) {
        return (MicrosoftGraphAdministrativeUnitInner)this.createAdministrativeUnitsAsync(body).block();
    }

    @Override
    public Response<MicrosoftGraphAdministrativeUnitInner> createAdministrativeUnitsWithResponse(MicrosoftGraphAdministrativeUnitInner body, Context context) {
        return (Response)this.createAdministrativeUnitsWithResponseAsync(body, context).block();
    }

    @Override
    public Mono<Response<MicrosoftGraphAdministrativeUnitInner>> getAdministrativeUnitsWithResponseAsync(String administrativeUnitId, List<DirectorySelect> select, List<DirectoryExpand> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (administrativeUnitId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter administrativeUnitId is required and cannot be null."));
        }
        String accept = "application/json";
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.getAdministrativeUnits(this.client.getEndpoint(), administrativeUnitId, selectConverted, expandConverted, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<MicrosoftGraphAdministrativeUnitInner>> getAdministrativeUnitsWithResponseAsync(String administrativeUnitId, List<DirectorySelect> select, List<DirectoryExpand> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (administrativeUnitId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter administrativeUnitId is required and cannot be null."));
        }
        String accept = "application/json";
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.getAdministrativeUnits(this.client.getEndpoint(), administrativeUnitId, selectConverted, expandConverted, "application/json", context);
    }

    @Override
    public Mono<MicrosoftGraphAdministrativeUnitInner> getAdministrativeUnitsAsync(String administrativeUnitId, List<DirectorySelect> select, List<DirectoryExpand> expand) {
        return this.getAdministrativeUnitsWithResponseAsync(administrativeUnitId, select, expand).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphAdministrativeUnitInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public Mono<MicrosoftGraphAdministrativeUnitInner> getAdministrativeUnitsAsync(String administrativeUnitId) {
        List<DirectorySelect> select = null;
        List<DirectoryExpand> expand = null;
        return this.getAdministrativeUnitsWithResponseAsync(administrativeUnitId, select, expand).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphAdministrativeUnitInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public MicrosoftGraphAdministrativeUnitInner getAdministrativeUnits(String administrativeUnitId) {
        List<DirectorySelect> select = null;
        List<DirectoryExpand> expand = null;
        return (MicrosoftGraphAdministrativeUnitInner)this.getAdministrativeUnitsAsync(administrativeUnitId, select, expand).block();
    }

    @Override
    public Response<MicrosoftGraphAdministrativeUnitInner> getAdministrativeUnitsWithResponse(String administrativeUnitId, List<DirectorySelect> select, List<DirectoryExpand> expand, Context context) {
        return (Response)this.getAdministrativeUnitsWithResponseAsync(administrativeUnitId, select, expand, context).block();
    }

    @Override
    public Mono<Response<Void>> updateAdministrativeUnitsWithResponseAsync(String administrativeUnitId, MicrosoftGraphAdministrativeUnitInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (administrativeUnitId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter administrativeUnitId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updateAdministrativeUnits(this.client.getEndpoint(), administrativeUnitId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Void>> updateAdministrativeUnitsWithResponseAsync(String administrativeUnitId, MicrosoftGraphAdministrativeUnitInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (administrativeUnitId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter administrativeUnitId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.updateAdministrativeUnits(this.client.getEndpoint(), administrativeUnitId, body, "application/json", context);
    }

    @Override
    public Mono<Void> updateAdministrativeUnitsAsync(String administrativeUnitId, MicrosoftGraphAdministrativeUnitInner body) {
        return this.updateAdministrativeUnitsWithResponseAsync(administrativeUnitId, body).flatMap(res -> Mono.empty());
    }

    @Override
    public void updateAdministrativeUnits(String administrativeUnitId, MicrosoftGraphAdministrativeUnitInner body) {
        this.updateAdministrativeUnitsAsync(administrativeUnitId, body).block();
    }

    @Override
    public Response<Void> updateAdministrativeUnitsWithResponse(String administrativeUnitId, MicrosoftGraphAdministrativeUnitInner body, Context context) {
        return (Response)this.updateAdministrativeUnitsWithResponseAsync(administrativeUnitId, body, context).block();
    }

    @Override
    public Mono<Response<Void>> deleteAdministrativeUnitsWithResponseAsync(String administrativeUnitId, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (administrativeUnitId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter administrativeUnitId is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteAdministrativeUnits(this.client.getEndpoint(), administrativeUnitId, ifMatch, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Void>> deleteAdministrativeUnitsWithResponseAsync(String administrativeUnitId, String ifMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (administrativeUnitId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter administrativeUnitId is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.deleteAdministrativeUnits(this.client.getEndpoint(), administrativeUnitId, ifMatch, "application/json", context);
    }

    @Override
    public Mono<Void> deleteAdministrativeUnitsAsync(String administrativeUnitId, String ifMatch) {
        return this.deleteAdministrativeUnitsWithResponseAsync(administrativeUnitId, ifMatch).flatMap(res -> Mono.empty());
    }

    @Override
    public Mono<Void> deleteAdministrativeUnitsAsync(String administrativeUnitId) {
        String ifMatch = null;
        return this.deleteAdministrativeUnitsWithResponseAsync(administrativeUnitId, ifMatch).flatMap(res -> Mono.empty());
    }

    @Override
    public void deleteAdministrativeUnits(String administrativeUnitId) {
        String ifMatch = null;
        this.deleteAdministrativeUnitsAsync(administrativeUnitId, ifMatch).block();
    }

    @Override
    public Response<Void> deleteAdministrativeUnitsWithResponse(String administrativeUnitId, String ifMatch, Context context) {
        return (Response)this.deleteAdministrativeUnitsWithResponseAsync(administrativeUnitId, ifMatch, context).block();
    }

    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listDeletedItemsSinglePageAsync(Integer top, Integer skip, String search, String filter, Boolean count, List<DirectoryOrderby> orderby, List<DirectorySelect> select, List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.listDeletedItems(this.client.getEndpoint(), top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObject7)res.getValue()).value(), ((CollectionOfDirectoryObject7)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listDeletedItemsSinglePageAsync(Integer top, Integer skip, String search, String filter, Boolean count, List<DirectoryOrderby> orderby, List<DirectorySelect> select, List<String> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.listDeletedItems(this.client.getEndpoint(), top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObject7)res.getValue()).value(), ((CollectionOfDirectoryObject7)res.getValue()).odataNextLink(), null));
    }

    @Override
    public PagedFlux<MicrosoftGraphDirectoryObjectInner> listDeletedItemsAsync(Integer top, Integer skip, String search, String filter, Boolean count, List<DirectoryOrderby> orderby, List<DirectorySelect> select, List<String> expand) {
        return new PagedFlux(() -> this.listDeletedItemsSinglePageAsync(top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listDeletedItemsNextSinglePageAsync((String)nextLink));
    }

    @Override
    public PagedFlux<MicrosoftGraphDirectoryObjectInner> listDeletedItemsAsync() {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List orderby = null;
        List select = null;
        List expand = null;
        return new PagedFlux(() -> this.listDeletedItemsSinglePageAsync(top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listDeletedItemsNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<MicrosoftGraphDirectoryObjectInner> listDeletedItemsAsync(Integer top, Integer skip, String search, String filter, Boolean count, List<DirectoryOrderby> orderby, List<DirectorySelect> select, List<String> expand, Context context) {
        return new PagedFlux(() -> this.listDeletedItemsSinglePageAsync(top, skip, search, filter, count, orderby, select, expand, context), nextLink -> this.listDeletedItemsNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<MicrosoftGraphDirectoryObjectInner> listDeletedItems() {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List<DirectoryOrderby> orderby = null;
        List<DirectorySelect> select = null;
        List<String> expand = null;
        return new PagedIterable(this.listDeletedItemsAsync(top, skip, search, filter, count, orderby, select, expand));
    }

    @Override
    public PagedIterable<MicrosoftGraphDirectoryObjectInner> listDeletedItems(Integer top, Integer skip, String search, String filter, Boolean count, List<DirectoryOrderby> orderby, List<DirectorySelect> select, List<String> expand, Context context) {
        return new PagedIterable(this.listDeletedItemsAsync(top, skip, search, filter, count, orderby, select, expand, context));
    }

    @Override
    public Mono<Response<MicrosoftGraphDirectoryObjectInner>> createDeletedItemsWithResponseAsync(MicrosoftGraphDirectoryObjectInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createDeletedItems(this.client.getEndpoint(), body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<MicrosoftGraphDirectoryObjectInner>> createDeletedItemsWithResponseAsync(MicrosoftGraphDirectoryObjectInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createDeletedItems(this.client.getEndpoint(), body, "application/json", context);
    }

    @Override
    public Mono<MicrosoftGraphDirectoryObjectInner> createDeletedItemsAsync(MicrosoftGraphDirectoryObjectInner body) {
        return this.createDeletedItemsWithResponseAsync(body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphDirectoryObjectInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public MicrosoftGraphDirectoryObjectInner createDeletedItems(MicrosoftGraphDirectoryObjectInner body) {
        return (MicrosoftGraphDirectoryObjectInner)this.createDeletedItemsAsync(body).block();
    }

    @Override
    public Response<MicrosoftGraphDirectoryObjectInner> createDeletedItemsWithResponse(MicrosoftGraphDirectoryObjectInner body, Context context) {
        return (Response)this.createDeletedItemsWithResponseAsync(body, context).block();
    }

    @Override
    public Mono<Response<MicrosoftGraphDirectoryObjectInner>> getDeletedItemsWithResponseAsync(String directoryObjectId, List<DirectorySelect> select, List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (directoryObjectId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter directoryObjectId is required and cannot be null."));
        }
        String accept = "application/json";
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.getDeletedItems(this.client.getEndpoint(), directoryObjectId, selectConverted, expandConverted, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<MicrosoftGraphDirectoryObjectInner>> getDeletedItemsWithResponseAsync(String directoryObjectId, List<DirectorySelect> select, List<String> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (directoryObjectId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter directoryObjectId is required and cannot be null."));
        }
        String accept = "application/json";
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.getDeletedItems(this.client.getEndpoint(), directoryObjectId, selectConverted, expandConverted, "application/json", context);
    }

    @Override
    public Mono<MicrosoftGraphDirectoryObjectInner> getDeletedItemsAsync(String directoryObjectId, List<DirectorySelect> select, List<String> expand) {
        return this.getDeletedItemsWithResponseAsync(directoryObjectId, select, expand).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphDirectoryObjectInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public Mono<MicrosoftGraphDirectoryObjectInner> getDeletedItemsAsync(String directoryObjectId) {
        List<DirectorySelect> select = null;
        List<String> expand = null;
        return this.getDeletedItemsWithResponseAsync(directoryObjectId, select, expand).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphDirectoryObjectInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public MicrosoftGraphDirectoryObjectInner getDeletedItems(String directoryObjectId) {
        List<DirectorySelect> select = null;
        List<String> expand = null;
        return (MicrosoftGraphDirectoryObjectInner)this.getDeletedItemsAsync(directoryObjectId, select, expand).block();
    }

    @Override
    public Response<MicrosoftGraphDirectoryObjectInner> getDeletedItemsWithResponse(String directoryObjectId, List<DirectorySelect> select, List<String> expand, Context context) {
        return (Response)this.getDeletedItemsWithResponseAsync(directoryObjectId, select, expand, context).block();
    }

    @Override
    public Mono<Response<Void>> updateDeletedItemsWithResponseAsync(String directoryObjectId, MicrosoftGraphDirectoryObjectInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (directoryObjectId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter directoryObjectId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updateDeletedItems(this.client.getEndpoint(), directoryObjectId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Void>> updateDeletedItemsWithResponseAsync(String directoryObjectId, MicrosoftGraphDirectoryObjectInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (directoryObjectId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter directoryObjectId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.updateDeletedItems(this.client.getEndpoint(), directoryObjectId, body, "application/json", context);
    }

    @Override
    public Mono<Void> updateDeletedItemsAsync(String directoryObjectId, MicrosoftGraphDirectoryObjectInner body) {
        return this.updateDeletedItemsWithResponseAsync(directoryObjectId, body).flatMap(res -> Mono.empty());
    }

    @Override
    public void updateDeletedItems(String directoryObjectId, MicrosoftGraphDirectoryObjectInner body) {
        this.updateDeletedItemsAsync(directoryObjectId, body).block();
    }

    @Override
    public Response<Void> updateDeletedItemsWithResponse(String directoryObjectId, MicrosoftGraphDirectoryObjectInner body, Context context) {
        return (Response)this.updateDeletedItemsWithResponseAsync(directoryObjectId, body, context).block();
    }

    @Override
    public Mono<Response<Void>> deleteDeletedItemsWithResponseAsync(String directoryObjectId, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (directoryObjectId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter directoryObjectId is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteDeletedItems(this.client.getEndpoint(), directoryObjectId, ifMatch, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Void>> deleteDeletedItemsWithResponseAsync(String directoryObjectId, String ifMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (directoryObjectId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter directoryObjectId is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.deleteDeletedItems(this.client.getEndpoint(), directoryObjectId, ifMatch, "application/json", context);
    }

    @Override
    public Mono<Void> deleteDeletedItemsAsync(String directoryObjectId, String ifMatch) {
        return this.deleteDeletedItemsWithResponseAsync(directoryObjectId, ifMatch).flatMap(res -> Mono.empty());
    }

    @Override
    public Mono<Void> deleteDeletedItemsAsync(String directoryObjectId) {
        String ifMatch = null;
        return this.deleteDeletedItemsWithResponseAsync(directoryObjectId, ifMatch).flatMap(res -> Mono.empty());
    }

    @Override
    public void deleteDeletedItems(String directoryObjectId) {
        String ifMatch = null;
        this.deleteDeletedItemsAsync(directoryObjectId, ifMatch).block();
    }

    @Override
    public Response<Void> deleteDeletedItemsWithResponse(String directoryObjectId, String ifMatch, Context context) {
        return (Response)this.deleteDeletedItemsWithResponseAsync(directoryObjectId, ifMatch, context).block();
    }

    private Mono<PagedResponse<MicrosoftGraphAdministrativeUnitInner>> listMoreSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listMore(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfAdministrativeUnit)res.getValue()).value(), ((CollectionOfAdministrativeUnit)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<MicrosoftGraphAdministrativeUnitInner>> listMoreSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listMore(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfAdministrativeUnit)res.getValue()).value(), ((CollectionOfAdministrativeUnit)res.getValue()).odataNextLink(), null));
    }

    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listDeletedItemsNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listDeletedItemsNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObject7)res.getValue()).value(), ((CollectionOfDirectoryObject7)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listDeletedItemsNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listDeletedItemsNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObject7)res.getValue()).value(), ((CollectionOfDirectoryObject7)res.getValue()).odataNextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="MicrosoftGraphClient")
    private static interface DirectoriesService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/directory/administrativeUnits")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfAdministrativeUnit>> listAdministrativeUnits(@HostParam(value="$host") String var1, @QueryParam(value="$top") Integer var2, @QueryParam(value="$skip") Integer var3, @QueryParam(value="$search") String var4, @QueryParam(value="$filter") String var5, @QueryParam(value="$count") Boolean var6, @QueryParam(value="$orderby") String var7, @QueryParam(value="$select") String var8, @QueryParam(value="$expand") String var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/directory/administrativeUnits")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<MicrosoftGraphAdministrativeUnitInner>> createAdministrativeUnits(@HostParam(value="$host") String var1, @BodyParam(value="application/json") MicrosoftGraphAdministrativeUnitInner var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/directory/administrativeUnits/{administrativeUnit-id}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<MicrosoftGraphAdministrativeUnitInner>> getAdministrativeUnits(@HostParam(value="$host") String var1, @PathParam(value="administrativeUnit-id") String var2, @QueryParam(value="$select") String var3, @QueryParam(value="$expand") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/directory/administrativeUnits/{administrativeUnit-id}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> updateAdministrativeUnits(@HostParam(value="$host") String var1, @PathParam(value="administrativeUnit-id") String var2, @BodyParam(value="application/json") MicrosoftGraphAdministrativeUnitInner var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/directory/administrativeUnits/{administrativeUnit-id}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> deleteAdministrativeUnits(@HostParam(value="$host") String var1, @PathParam(value="administrativeUnit-id") String var2, @HeaderParam(value="If-Match") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/directory/deletedItems")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfDirectoryObject7>> listDeletedItems(@HostParam(value="$host") String var1, @QueryParam(value="$top") Integer var2, @QueryParam(value="$skip") Integer var3, @QueryParam(value="$search") String var4, @QueryParam(value="$filter") String var5, @QueryParam(value="$count") Boolean var6, @QueryParam(value="$orderby") String var7, @QueryParam(value="$select") String var8, @QueryParam(value="$expand") String var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/directory/deletedItems")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<MicrosoftGraphDirectoryObjectInner>> createDeletedItems(@HostParam(value="$host") String var1, @BodyParam(value="application/json") MicrosoftGraphDirectoryObjectInner var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/directory/deletedItems/{directoryObject-id}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<MicrosoftGraphDirectoryObjectInner>> getDeletedItems(@HostParam(value="$host") String var1, @PathParam(value="directoryObject-id") String var2, @QueryParam(value="$select") String var3, @QueryParam(value="$expand") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/directory/deletedItems/{directoryObject-id}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> updateDeletedItems(@HostParam(value="$host") String var1, @PathParam(value="directoryObject-id") String var2, @BodyParam(value="application/json") MicrosoftGraphDirectoryObjectInner var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/directory/deletedItems/{directoryObject-id}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> deleteDeletedItems(@HostParam(value="$host") String var1, @PathParam(value="directoryObject-id") String var2, @HeaderParam(value="If-Match") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfAdministrativeUnit>> listMore(@PathParam(value="nextLink", encoded=true) String var1, Context var2);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfDirectoryObject7>> listDeletedItemsNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);
    }
}

