/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.authorization.fluent.ContractsClient;
import com.azure.resourcemanager.authorization.fluent.models.ContractsCheckMemberGroupsRequestBody;
import com.azure.resourcemanager.authorization.fluent.models.ContractsCheckMemberObjectsRequestBody;
import com.azure.resourcemanager.authorization.fluent.models.ContractsGetAvailableExtensionPropertiesRequestBody;
import com.azure.resourcemanager.authorization.fluent.models.ContractsGetByIdsRequestBody;
import com.azure.resourcemanager.authorization.fluent.models.ContractsGetMemberGroupsRequestBody;
import com.azure.resourcemanager.authorization.fluent.models.ContractsGetMemberObjectsRequestBody;
import com.azure.resourcemanager.authorization.fluent.models.ContractsValidatePropertiesRequestBody;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphDirectoryObjectInner;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphExtensionPropertyInner;
import com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException;
import com.azure.resourcemanager.authorization.implementation.MicrosoftGraphClientImpl;
import java.util.List;
import reactor.core.publisher.Mono;

public final class ContractsClientImpl
implements ContractsClient {
    private final ClientLogger logger = new ClientLogger(ContractsClientImpl.class);
    private final ContractsService service;
    private final MicrosoftGraphClientImpl client;

    ContractsClientImpl(MicrosoftGraphClientImpl client) {
        this.service = (ContractsService)RestProxy.create(ContractsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    public Mono<Response<List<String>>> checkMemberGroupsWithResponseAsync(String contractId, ContractsCheckMemberGroupsRequestBody body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (contractId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter contractId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.checkMemberGroups(this.client.getEndpoint(), contractId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<List<String>>> checkMemberGroupsWithResponseAsync(String contractId, ContractsCheckMemberGroupsRequestBody body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (contractId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter contractId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.checkMemberGroups(this.client.getEndpoint(), contractId, body, "application/json", context);
    }

    @Override
    public Mono<List<String>> checkMemberGroupsAsync(String contractId, ContractsCheckMemberGroupsRequestBody body) {
        return this.checkMemberGroupsWithResponseAsync(contractId, body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((List)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public List<String> checkMemberGroups(String contractId, ContractsCheckMemberGroupsRequestBody body) {
        return (List)this.checkMemberGroupsAsync(contractId, body).block();
    }

    @Override
    public Response<List<String>> checkMemberGroupsWithResponse(String contractId, ContractsCheckMemberGroupsRequestBody body, Context context) {
        return (Response)this.checkMemberGroupsWithResponseAsync(contractId, body, context).block();
    }

    @Override
    public Mono<Response<List<String>>> checkMemberObjectsWithResponseAsync(String contractId, ContractsCheckMemberObjectsRequestBody body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (contractId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter contractId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.checkMemberObjects(this.client.getEndpoint(), contractId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<List<String>>> checkMemberObjectsWithResponseAsync(String contractId, ContractsCheckMemberObjectsRequestBody body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (contractId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter contractId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.checkMemberObjects(this.client.getEndpoint(), contractId, body, "application/json", context);
    }

    @Override
    public Mono<List<String>> checkMemberObjectsAsync(String contractId, ContractsCheckMemberObjectsRequestBody body) {
        return this.checkMemberObjectsWithResponseAsync(contractId, body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((List)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public List<String> checkMemberObjects(String contractId, ContractsCheckMemberObjectsRequestBody body) {
        return (List)this.checkMemberObjectsAsync(contractId, body).block();
    }

    @Override
    public Response<List<String>> checkMemberObjectsWithResponse(String contractId, ContractsCheckMemberObjectsRequestBody body, Context context) {
        return (Response)this.checkMemberObjectsWithResponseAsync(contractId, body, context).block();
    }

    @Override
    public Mono<Response<List<String>>> getMemberGroupsWithResponseAsync(String contractId, ContractsGetMemberGroupsRequestBody body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (contractId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter contractId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getMemberGroups(this.client.getEndpoint(), contractId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<List<String>>> getMemberGroupsWithResponseAsync(String contractId, ContractsGetMemberGroupsRequestBody body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (contractId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter contractId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getMemberGroups(this.client.getEndpoint(), contractId, body, "application/json", context);
    }

    @Override
    public Mono<List<String>> getMemberGroupsAsync(String contractId, ContractsGetMemberGroupsRequestBody body) {
        return this.getMemberGroupsWithResponseAsync(contractId, body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((List)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public List<String> getMemberGroups(String contractId, ContractsGetMemberGroupsRequestBody body) {
        return (List)this.getMemberGroupsAsync(contractId, body).block();
    }

    @Override
    public Response<List<String>> getMemberGroupsWithResponse(String contractId, ContractsGetMemberGroupsRequestBody body, Context context) {
        return (Response)this.getMemberGroupsWithResponseAsync(contractId, body, context).block();
    }

    @Override
    public Mono<Response<List<String>>> getMemberObjectsWithResponseAsync(String contractId, ContractsGetMemberObjectsRequestBody body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (contractId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter contractId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getMemberObjects(this.client.getEndpoint(), contractId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<List<String>>> getMemberObjectsWithResponseAsync(String contractId, ContractsGetMemberObjectsRequestBody body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (contractId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter contractId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getMemberObjects(this.client.getEndpoint(), contractId, body, "application/json", context);
    }

    @Override
    public Mono<List<String>> getMemberObjectsAsync(String contractId, ContractsGetMemberObjectsRequestBody body) {
        return this.getMemberObjectsWithResponseAsync(contractId, body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((List)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public List<String> getMemberObjects(String contractId, ContractsGetMemberObjectsRequestBody body) {
        return (List)this.getMemberObjectsAsync(contractId, body).block();
    }

    @Override
    public Response<List<String>> getMemberObjectsWithResponse(String contractId, ContractsGetMemberObjectsRequestBody body, Context context) {
        return (Response)this.getMemberObjectsWithResponseAsync(contractId, body, context).block();
    }

    @Override
    public Mono<Response<MicrosoftGraphDirectoryObjectInner>> restoreWithResponseAsync(String contractId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (contractId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter contractId is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.restore(this.client.getEndpoint(), contractId, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<MicrosoftGraphDirectoryObjectInner>> restoreWithResponseAsync(String contractId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (contractId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter contractId is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.restore(this.client.getEndpoint(), contractId, "application/json", context);
    }

    @Override
    public Mono<MicrosoftGraphDirectoryObjectInner> restoreAsync(String contractId) {
        return this.restoreWithResponseAsync(contractId).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphDirectoryObjectInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public MicrosoftGraphDirectoryObjectInner restore(String contractId) {
        return (MicrosoftGraphDirectoryObjectInner)this.restoreAsync(contractId).block();
    }

    @Override
    public Response<MicrosoftGraphDirectoryObjectInner> restoreWithResponse(String contractId, Context context) {
        return (Response)this.restoreWithResponseAsync(contractId, context).block();
    }

    @Override
    public Mono<Response<List<MicrosoftGraphExtensionPropertyInner>>> getAvailableExtensionPropertiesWithResponseAsync(ContractsGetAvailableExtensionPropertiesRequestBody body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getAvailableExtensionProperties(this.client.getEndpoint(), body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<List<MicrosoftGraphExtensionPropertyInner>>> getAvailableExtensionPropertiesWithResponseAsync(ContractsGetAvailableExtensionPropertiesRequestBody body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getAvailableExtensionProperties(this.client.getEndpoint(), body, "application/json", context);
    }

    @Override
    public Mono<List<MicrosoftGraphExtensionPropertyInner>> getAvailableExtensionPropertiesAsync(ContractsGetAvailableExtensionPropertiesRequestBody body) {
        return this.getAvailableExtensionPropertiesWithResponseAsync(body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((List)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public List<MicrosoftGraphExtensionPropertyInner> getAvailableExtensionProperties(ContractsGetAvailableExtensionPropertiesRequestBody body) {
        return (List)this.getAvailableExtensionPropertiesAsync(body).block();
    }

    @Override
    public Response<List<MicrosoftGraphExtensionPropertyInner>> getAvailableExtensionPropertiesWithResponse(ContractsGetAvailableExtensionPropertiesRequestBody body, Context context) {
        return (Response)this.getAvailableExtensionPropertiesWithResponseAsync(body, context).block();
    }

    @Override
    public Mono<Response<List<MicrosoftGraphDirectoryObjectInner>>> getByIdsWithResponseAsync(ContractsGetByIdsRequestBody body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getByIds(this.client.getEndpoint(), body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<List<MicrosoftGraphDirectoryObjectInner>>> getByIdsWithResponseAsync(ContractsGetByIdsRequestBody body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getByIds(this.client.getEndpoint(), body, "application/json", context);
    }

    @Override
    public Mono<List<MicrosoftGraphDirectoryObjectInner>> getByIdsAsync(ContractsGetByIdsRequestBody body) {
        return this.getByIdsWithResponseAsync(body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((List)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public List<MicrosoftGraphDirectoryObjectInner> getByIds(ContractsGetByIdsRequestBody body) {
        return (List)this.getByIdsAsync(body).block();
    }

    @Override
    public Response<List<MicrosoftGraphDirectoryObjectInner>> getByIdsWithResponse(ContractsGetByIdsRequestBody body, Context context) {
        return (Response)this.getByIdsWithResponseAsync(body, context).block();
    }

    @Override
    public Mono<Response<Void>> validatePropertiesWithResponseAsync(ContractsValidatePropertiesRequestBody body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.validateProperties(this.client.getEndpoint(), body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Void>> validatePropertiesWithResponseAsync(ContractsValidatePropertiesRequestBody body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.validateProperties(this.client.getEndpoint(), body, "application/json", context);
    }

    @Override
    public Mono<Void> validatePropertiesAsync(ContractsValidatePropertiesRequestBody body) {
        return this.validatePropertiesWithResponseAsync(body).flatMap(res -> Mono.empty());
    }

    @Override
    public void validateProperties(ContractsValidatePropertiesRequestBody body) {
        this.validatePropertiesAsync(body).block();
    }

    @Override
    public Response<Void> validatePropertiesWithResponse(ContractsValidatePropertiesRequestBody body, Context context) {
        return (Response)this.validatePropertiesWithResponseAsync(body, context).block();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="MicrosoftGraphClient")
    private static interface ContractsService {
        @Headers(value={"Content-Type: application/json"})
        @Post(value="/contracts/{contract-id}/microsoft.graph.checkMemberGroups")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<List<String>>> checkMemberGroups(@HostParam(value="$host") String var1, @PathParam(value="contract-id") String var2, @BodyParam(value="application/json") ContractsCheckMemberGroupsRequestBody var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/contracts/{contract-id}/microsoft.graph.checkMemberObjects")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<List<String>>> checkMemberObjects(@HostParam(value="$host") String var1, @PathParam(value="contract-id") String var2, @BodyParam(value="application/json") ContractsCheckMemberObjectsRequestBody var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/contracts/{contract-id}/microsoft.graph.getMemberGroups")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<List<String>>> getMemberGroups(@HostParam(value="$host") String var1, @PathParam(value="contract-id") String var2, @BodyParam(value="application/json") ContractsGetMemberGroupsRequestBody var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/contracts/{contract-id}/microsoft.graph.getMemberObjects")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<List<String>>> getMemberObjects(@HostParam(value="$host") String var1, @PathParam(value="contract-id") String var2, @BodyParam(value="application/json") ContractsGetMemberObjectsRequestBody var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/contracts/{contract-id}/microsoft.graph.restore")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<MicrosoftGraphDirectoryObjectInner>> restore(@HostParam(value="$host") String var1, @PathParam(value="contract-id") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/contracts/microsoft.graph.getAvailableExtensionProperties")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<List<MicrosoftGraphExtensionPropertyInner>>> getAvailableExtensionProperties(@HostParam(value="$host") String var1, @BodyParam(value="application/json") ContractsGetAvailableExtensionPropertiesRequestBody var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/contracts/microsoft.graph.getByIds")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<List<MicrosoftGraphDirectoryObjectInner>>> getByIds(@HostParam(value="$host") String var1, @BodyParam(value="application/json") ContractsGetByIdsRequestBody var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/contracts/microsoft.graph.validateProperties")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> validateProperties(@HostParam(value="$host") String var1, @BodyParam(value="application/json") ContractsValidatePropertiesRequestBody var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

