/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.authorization.fluent.RoleAssignmentScheduleRequestsClient;
import com.azure.resourcemanager.authorization.fluent.models.RoleAssignmentScheduleRequestInner;
import com.azure.resourcemanager.authorization.implementation.AuthorizationManagementClientImpl;
import com.azure.resourcemanager.authorization.models.RoleAssignmentScheduleRequestListResult;
import reactor.core.publisher.Mono;

public final class RoleAssignmentScheduleRequestsClientImpl
implements RoleAssignmentScheduleRequestsClient {
    private final RoleAssignmentScheduleRequestsService service;
    private final AuthorizationManagementClientImpl client;

    RoleAssignmentScheduleRequestsClientImpl(AuthorizationManagementClientImpl client) {
        this.service = (RoleAssignmentScheduleRequestsService)RestProxy.create(RoleAssignmentScheduleRequestsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<RoleAssignmentScheduleRequestInner>> createWithResponseAsync(String scope, String roleAssignmentScheduleRequestName, RoleAssignmentScheduleRequestInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (roleAssignmentScheduleRequestName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter roleAssignmentScheduleRequestName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2020-10-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.create(this.client.getEndpoint(), scope, roleAssignmentScheduleRequestName, "2020-10-01", parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<RoleAssignmentScheduleRequestInner>> createWithResponseAsync(String scope, String roleAssignmentScheduleRequestName, RoleAssignmentScheduleRequestInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (roleAssignmentScheduleRequestName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter roleAssignmentScheduleRequestName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2020-10-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.create(this.client.getEndpoint(), scope, roleAssignmentScheduleRequestName, "2020-10-01", parameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RoleAssignmentScheduleRequestInner> createAsync(String scope, String roleAssignmentScheduleRequestName, RoleAssignmentScheduleRequestInner parameters) {
        return this.createWithResponseAsync(scope, roleAssignmentScheduleRequestName, parameters).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((RoleAssignmentScheduleRequestInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public RoleAssignmentScheduleRequestInner create(String scope, String roleAssignmentScheduleRequestName, RoleAssignmentScheduleRequestInner parameters) {
        return (RoleAssignmentScheduleRequestInner)this.createAsync(scope, roleAssignmentScheduleRequestName, parameters).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RoleAssignmentScheduleRequestInner> createWithResponse(String scope, String roleAssignmentScheduleRequestName, RoleAssignmentScheduleRequestInner parameters, Context context) {
        return (Response)this.createWithResponseAsync(scope, roleAssignmentScheduleRequestName, parameters, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<RoleAssignmentScheduleRequestInner>> getWithResponseAsync(String scope, String roleAssignmentScheduleRequestName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (roleAssignmentScheduleRequestName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter roleAssignmentScheduleRequestName is required and cannot be null."));
        }
        String apiVersion = "2020-10-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), scope, roleAssignmentScheduleRequestName, "2020-10-01", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<RoleAssignmentScheduleRequestInner>> getWithResponseAsync(String scope, String roleAssignmentScheduleRequestName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (roleAssignmentScheduleRequestName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter roleAssignmentScheduleRequestName is required and cannot be null."));
        }
        String apiVersion = "2020-10-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), scope, roleAssignmentScheduleRequestName, "2020-10-01", "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RoleAssignmentScheduleRequestInner> getAsync(String scope, String roleAssignmentScheduleRequestName) {
        return this.getWithResponseAsync(scope, roleAssignmentScheduleRequestName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((RoleAssignmentScheduleRequestInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public RoleAssignmentScheduleRequestInner get(String scope, String roleAssignmentScheduleRequestName) {
        return (RoleAssignmentScheduleRequestInner)this.getAsync(scope, roleAssignmentScheduleRequestName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RoleAssignmentScheduleRequestInner> getWithResponse(String scope, String roleAssignmentScheduleRequestName, Context context) {
        return (Response)this.getWithResponseAsync(scope, roleAssignmentScheduleRequestName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RoleAssignmentScheduleRequestInner>> listForScopeSinglePageAsync(String scope, String filter) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        String apiVersion = "2020-10-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listForScope(this.client.getEndpoint(), scope, filter, "2020-10-01", "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RoleAssignmentScheduleRequestListResult)res.getValue()).value(), ((RoleAssignmentScheduleRequestListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RoleAssignmentScheduleRequestInner>> listForScopeSinglePageAsync(String scope, String filter, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        String apiVersion = "2020-10-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listForScope(this.client.getEndpoint(), scope, filter, "2020-10-01", "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RoleAssignmentScheduleRequestListResult)res.getValue()).value(), ((RoleAssignmentScheduleRequestListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<RoleAssignmentScheduleRequestInner> listForScopeAsync(String scope, String filter) {
        return new PagedFlux(() -> this.listForScopeSinglePageAsync(scope, filter), nextLink -> this.listForScopeNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<RoleAssignmentScheduleRequestInner> listForScopeAsync(String scope) {
        String filter = null;
        return new PagedFlux(() -> this.listForScopeSinglePageAsync(scope, filter), nextLink -> this.listForScopeNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<RoleAssignmentScheduleRequestInner> listForScopeAsync(String scope, String filter, Context context) {
        return new PagedFlux(() -> this.listForScopeSinglePageAsync(scope, filter, context), nextLink -> this.listForScopeNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<RoleAssignmentScheduleRequestInner> listForScope(String scope) {
        String filter = null;
        return new PagedIterable(this.listForScopeAsync(scope, filter));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<RoleAssignmentScheduleRequestInner> listForScope(String scope, String filter, Context context) {
        return new PagedIterable(this.listForScopeAsync(scope, filter, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> cancelWithResponseAsync(String scope, String roleAssignmentScheduleRequestName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (roleAssignmentScheduleRequestName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter roleAssignmentScheduleRequestName is required and cannot be null."));
        }
        String apiVersion = "2020-10-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.cancel(this.client.getEndpoint(), scope, roleAssignmentScheduleRequestName, "2020-10-01", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> cancelWithResponseAsync(String scope, String roleAssignmentScheduleRequestName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (roleAssignmentScheduleRequestName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter roleAssignmentScheduleRequestName is required and cannot be null."));
        }
        String apiVersion = "2020-10-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.cancel(this.client.getEndpoint(), scope, roleAssignmentScheduleRequestName, "2020-10-01", "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> cancelAsync(String scope, String roleAssignmentScheduleRequestName) {
        return this.cancelWithResponseAsync(scope, roleAssignmentScheduleRequestName).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void cancel(String scope, String roleAssignmentScheduleRequestName) {
        this.cancelAsync(scope, roleAssignmentScheduleRequestName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> cancelWithResponse(String scope, String roleAssignmentScheduleRequestName, Context context) {
        return (Response)this.cancelWithResponseAsync(scope, roleAssignmentScheduleRequestName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<RoleAssignmentScheduleRequestInner>> validateWithResponseAsync(String scope, String roleAssignmentScheduleRequestName, RoleAssignmentScheduleRequestInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (roleAssignmentScheduleRequestName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter roleAssignmentScheduleRequestName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2020-10-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.validate(this.client.getEndpoint(), scope, roleAssignmentScheduleRequestName, "2020-10-01", parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<RoleAssignmentScheduleRequestInner>> validateWithResponseAsync(String scope, String roleAssignmentScheduleRequestName, RoleAssignmentScheduleRequestInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (roleAssignmentScheduleRequestName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter roleAssignmentScheduleRequestName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2020-10-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.validate(this.client.getEndpoint(), scope, roleAssignmentScheduleRequestName, "2020-10-01", parameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RoleAssignmentScheduleRequestInner> validateAsync(String scope, String roleAssignmentScheduleRequestName, RoleAssignmentScheduleRequestInner parameters) {
        return this.validateWithResponseAsync(scope, roleAssignmentScheduleRequestName, parameters).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((RoleAssignmentScheduleRequestInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public RoleAssignmentScheduleRequestInner validate(String scope, String roleAssignmentScheduleRequestName, RoleAssignmentScheduleRequestInner parameters) {
        return (RoleAssignmentScheduleRequestInner)this.validateAsync(scope, roleAssignmentScheduleRequestName, parameters).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RoleAssignmentScheduleRequestInner> validateWithResponse(String scope, String roleAssignmentScheduleRequestName, RoleAssignmentScheduleRequestInner parameters, Context context) {
        return (Response)this.validateWithResponseAsync(scope, roleAssignmentScheduleRequestName, parameters, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RoleAssignmentScheduleRequestInner>> listForScopeNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listForScopeNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RoleAssignmentScheduleRequestListResult)res.getValue()).value(), ((RoleAssignmentScheduleRequestListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RoleAssignmentScheduleRequestInner>> listForScopeNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listForScopeNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RoleAssignmentScheduleRequestListResult)res.getValue()).value(), ((RoleAssignmentScheduleRequestListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="AuthorizationManagem")
    private static interface RoleAssignmentScheduleRequestsService {
        @Headers(value={"Content-Type: application/json"})
        @Put(value="/{scope}/providers/Microsoft.Authorization/roleAssignmentScheduleRequests/{roleAssignmentScheduleRequestName}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RoleAssignmentScheduleRequestInner>> create(@HostParam(value="$host") String var1, @PathParam(value="scope", encoded=true) String var2, @PathParam(value="roleAssignmentScheduleRequestName") String var3, @QueryParam(value="api-version") String var4, @BodyParam(value="application/json") RoleAssignmentScheduleRequestInner var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/{scope}/providers/Microsoft.Authorization/roleAssignmentScheduleRequests/{roleAssignmentScheduleRequestName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RoleAssignmentScheduleRequestInner>> get(@HostParam(value="$host") String var1, @PathParam(value="scope", encoded=true) String var2, @PathParam(value="roleAssignmentScheduleRequestName") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/{scope}/providers/Microsoft.Authorization/roleAssignmentScheduleRequests")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RoleAssignmentScheduleRequestListResult>> listForScope(@HostParam(value="$host") String var1, @PathParam(value="scope", encoded=true) String var2, @QueryParam(value="$filter") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/{scope}/providers/Microsoft.Authorization/roleAssignmentScheduleRequests/{roleAssignmentScheduleRequestName}/cancel")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> cancel(@HostParam(value="$host") String var1, @PathParam(value="scope", encoded=true) String var2, @PathParam(value="roleAssignmentScheduleRequestName") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/{scope}/providers/Microsoft.Authorization/roleAssignmentScheduleRequests/{roleAssignmentScheduleRequestName}/validate")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RoleAssignmentScheduleRequestInner>> validate(@HostParam(value="$host") String var1, @PathParam(value="scope", encoded=true) String var2, @PathParam(value="roleAssignmentScheduleRequestName") String var3, @QueryParam(value="api-version") String var4, @BodyParam(value="application/json") RoleAssignmentScheduleRequestInner var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RoleAssignmentScheduleRequestListResult>> listForScopeNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

