// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Ticket Info of the role assignment. */
@Fluent
public final class RoleAssignmentScheduleRequestPropertiesTicketInfo {
    /*
     * Ticket number for the role assignment
     */
    @JsonProperty(value = "ticketNumber")
    private String ticketNumber;

    /*
     * Ticket system name for the role assignment
     */
    @JsonProperty(value = "ticketSystem")
    private String ticketSystem;

    /**
     * Get the ticketNumber property: Ticket number for the role assignment.
     *
     * @return the ticketNumber value.
     */
    public String ticketNumber() {
        return this.ticketNumber;
    }

    /**
     * Set the ticketNumber property: Ticket number for the role assignment.
     *
     * @param ticketNumber the ticketNumber value to set.
     * @return the RoleAssignmentScheduleRequestPropertiesTicketInfo object itself.
     */
    public RoleAssignmentScheduleRequestPropertiesTicketInfo withTicketNumber(String ticketNumber) {
        this.ticketNumber = ticketNumber;
        return this;
    }

    /**
     * Get the ticketSystem property: Ticket system name for the role assignment.
     *
     * @return the ticketSystem value.
     */
    public String ticketSystem() {
        return this.ticketSystem;
    }

    /**
     * Set the ticketSystem property: Ticket system name for the role assignment.
     *
     * @param ticketSystem the ticketSystem value to set.
     * @return the RoleAssignmentScheduleRequestPropertiesTicketInfo object itself.
     */
    public RoleAssignmentScheduleRequestPropertiesTicketInfo withTicketSystem(String ticketSystem) {
        this.ticketSystem = ticketSystem;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
