// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;

/** workbookOperation. */
@Fluent
public final class MicrosoftGraphWorkbookOperation extends MicrosoftGraphEntity {
    /*
     * workbookOperationError
     */
    @JsonProperty(value = "error")
    private MicrosoftGraphWorkbookOperationError error;

    /*
     * The resource URI for the result.
     */
    @JsonProperty(value = "resourceLocation")
    private String resourceLocation;

    /*
     * workbookOperationStatus
     */
    @JsonProperty(value = "status")
    private MicrosoftGraphWorkbookOperationStatus status;

    /*
     * workbookOperation
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /**
     * Get the error property: workbookOperationError.
     *
     * @return the error value.
     */
    public MicrosoftGraphWorkbookOperationError error() {
        return this.error;
    }

    /**
     * Set the error property: workbookOperationError.
     *
     * @param error the error value to set.
     * @return the MicrosoftGraphWorkbookOperation object itself.
     */
    public MicrosoftGraphWorkbookOperation withError(MicrosoftGraphWorkbookOperationError error) {
        this.error = error;
        return this;
    }

    /**
     * Get the resourceLocation property: The resource URI for the result.
     *
     * @return the resourceLocation value.
     */
    public String resourceLocation() {
        return this.resourceLocation;
    }

    /**
     * Set the resourceLocation property: The resource URI for the result.
     *
     * @param resourceLocation the resourceLocation value to set.
     * @return the MicrosoftGraphWorkbookOperation object itself.
     */
    public MicrosoftGraphWorkbookOperation withResourceLocation(String resourceLocation) {
        this.resourceLocation = resourceLocation;
        return this;
    }

    /**
     * Get the status property: workbookOperationStatus.
     *
     * @return the status value.
     */
    public MicrosoftGraphWorkbookOperationStatus status() {
        return this.status;
    }

    /**
     * Set the status property: workbookOperationStatus.
     *
     * @param status the status value to set.
     * @return the MicrosoftGraphWorkbookOperation object itself.
     */
    public MicrosoftGraphWorkbookOperation withStatus(MicrosoftGraphWorkbookOperationStatus status) {
        this.status = status;
        return this;
    }

    /**
     * Get the additionalProperties property: workbookOperation.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: workbookOperation.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphWorkbookOperation object itself.
     */
    public MicrosoftGraphWorkbookOperation withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphWorkbookOperation withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (error() != null) {
            error().validate();
        }
    }
}
