// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;

/** workbookChartFont. */
@Fluent
public final class MicrosoftGraphWorkbookChartFont extends MicrosoftGraphEntity {
    /*
     * Represents the bold status of font.
     */
    @JsonProperty(value = "bold")
    private Boolean bold;

    /*
     * HTML color code representation of the text color. E.g. #FF0000
     * represents Red.
     */
    @JsonProperty(value = "color")
    private String color;

    /*
     * Represents the italic status of the font.
     */
    @JsonProperty(value = "italic")
    private Boolean italic;

    /*
     * Font name (e.g. 'Calibri')
     */
    @JsonProperty(value = "name")
    private String name;

    /*
     * Size of the font (e.g. 11)
     */
    @JsonProperty(value = "size")
    private Double size;

    /*
     * Type of underline applied to the font. The possible values are: None,
     * Single.
     */
    @JsonProperty(value = "underline")
    private String underline;

    /*
     * workbookChartFont
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /**
     * Get the bold property: Represents the bold status of font.
     *
     * @return the bold value.
     */
    public Boolean bold() {
        return this.bold;
    }

    /**
     * Set the bold property: Represents the bold status of font.
     *
     * @param bold the bold value to set.
     * @return the MicrosoftGraphWorkbookChartFont object itself.
     */
    public MicrosoftGraphWorkbookChartFont withBold(Boolean bold) {
        this.bold = bold;
        return this;
    }

    /**
     * Get the color property: HTML color code representation of the text color. E.g. #FF0000 represents Red.
     *
     * @return the color value.
     */
    public String color() {
        return this.color;
    }

    /**
     * Set the color property: HTML color code representation of the text color. E.g. #FF0000 represents Red.
     *
     * @param color the color value to set.
     * @return the MicrosoftGraphWorkbookChartFont object itself.
     */
    public MicrosoftGraphWorkbookChartFont withColor(String color) {
        this.color = color;
        return this;
    }

    /**
     * Get the italic property: Represents the italic status of the font.
     *
     * @return the italic value.
     */
    public Boolean italic() {
        return this.italic;
    }

    /**
     * Set the italic property: Represents the italic status of the font.
     *
     * @param italic the italic value to set.
     * @return the MicrosoftGraphWorkbookChartFont object itself.
     */
    public MicrosoftGraphWorkbookChartFont withItalic(Boolean italic) {
        this.italic = italic;
        return this;
    }

    /**
     * Get the name property: Font name (e.g. 'Calibri').
     *
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Font name (e.g. 'Calibri').
     *
     * @param name the name value to set.
     * @return the MicrosoftGraphWorkbookChartFont object itself.
     */
    public MicrosoftGraphWorkbookChartFont withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the size property: Size of the font (e.g. 11).
     *
     * @return the size value.
     */
    public Double size() {
        return this.size;
    }

    /**
     * Set the size property: Size of the font (e.g. 11).
     *
     * @param size the size value to set.
     * @return the MicrosoftGraphWorkbookChartFont object itself.
     */
    public MicrosoftGraphWorkbookChartFont withSize(Double size) {
        this.size = size;
        return this;
    }

    /**
     * Get the underline property: Type of underline applied to the font. The possible values are: None, Single.
     *
     * @return the underline value.
     */
    public String underline() {
        return this.underline;
    }

    /**
     * Set the underline property: Type of underline applied to the font. The possible values are: None, Single.
     *
     * @param underline the underline value to set.
     * @return the MicrosoftGraphWorkbookChartFont object itself.
     */
    public MicrosoftGraphWorkbookChartFont withUnderline(String underline) {
        this.underline = underline;
        return this;
    }

    /**
     * Get the additionalProperties property: workbookChartFont.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: workbookChartFont.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphWorkbookChartFont object itself.
     */
    public MicrosoftGraphWorkbookChartFont withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphWorkbookChartFont withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }
}
