// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;

/** usedInsight. */
@Fluent
public final class MicrosoftGraphUsedInsight extends MicrosoftGraphEntity {
    /*
     * usageDetails
     */
    @JsonProperty(value = "lastUsed")
    private MicrosoftGraphUsageDetails lastUsed;

    /*
     * resourceReference
     */
    @JsonProperty(value = "resourceReference")
    private MicrosoftGraphResourceReference resourceReference;

    /*
     * resourceVisualization
     */
    @JsonProperty(value = "resourceVisualization")
    private MicrosoftGraphResourceVisualization resourceVisualization;

    /*
     * entity
     */
    @JsonProperty(value = "resource")
    private MicrosoftGraphEntity resource;

    /*
     * usedInsight
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /**
     * Get the lastUsed property: usageDetails.
     *
     * @return the lastUsed value.
     */
    public MicrosoftGraphUsageDetails lastUsed() {
        return this.lastUsed;
    }

    /**
     * Set the lastUsed property: usageDetails.
     *
     * @param lastUsed the lastUsed value to set.
     * @return the MicrosoftGraphUsedInsight object itself.
     */
    public MicrosoftGraphUsedInsight withLastUsed(MicrosoftGraphUsageDetails lastUsed) {
        this.lastUsed = lastUsed;
        return this;
    }

    /**
     * Get the resourceReference property: resourceReference.
     *
     * @return the resourceReference value.
     */
    public MicrosoftGraphResourceReference resourceReference() {
        return this.resourceReference;
    }

    /**
     * Set the resourceReference property: resourceReference.
     *
     * @param resourceReference the resourceReference value to set.
     * @return the MicrosoftGraphUsedInsight object itself.
     */
    public MicrosoftGraphUsedInsight withResourceReference(MicrosoftGraphResourceReference resourceReference) {
        this.resourceReference = resourceReference;
        return this;
    }

    /**
     * Get the resourceVisualization property: resourceVisualization.
     *
     * @return the resourceVisualization value.
     */
    public MicrosoftGraphResourceVisualization resourceVisualization() {
        return this.resourceVisualization;
    }

    /**
     * Set the resourceVisualization property: resourceVisualization.
     *
     * @param resourceVisualization the resourceVisualization value to set.
     * @return the MicrosoftGraphUsedInsight object itself.
     */
    public MicrosoftGraphUsedInsight withResourceVisualization(
        MicrosoftGraphResourceVisualization resourceVisualization) {
        this.resourceVisualization = resourceVisualization;
        return this;
    }

    /**
     * Get the resource property: entity.
     *
     * @return the resource value.
     */
    public MicrosoftGraphEntity resource() {
        return this.resource;
    }

    /**
     * Set the resource property: entity.
     *
     * @param resource the resource value to set.
     * @return the MicrosoftGraphUsedInsight object itself.
     */
    public MicrosoftGraphUsedInsight withResource(MicrosoftGraphEntity resource) {
        this.resource = resource;
        return this;
    }

    /**
     * Get the additionalProperties property: usedInsight.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: usedInsight.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphUsedInsight object itself.
     */
    public MicrosoftGraphUsedInsight withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphUsedInsight withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (lastUsed() != null) {
            lastUsed().validate();
        }
        if (resourceReference() != null) {
            resourceReference().validate();
        }
        if (resourceVisualization() != null) {
            resourceVisualization().validate();
        }
        if (resource() != null) {
            resource().validate();
        }
    }
}
