// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;

/** timeOff. */
@Fluent
public final class MicrosoftGraphTimeOff extends MicrosoftGraphChangeTrackedEntity {
    /*
     * timeOffItem
     */
    @JsonProperty(value = "draftTimeOff")
    private MicrosoftGraphTimeOffItem draftTimeOff;

    /*
     * timeOffItem
     */
    @JsonProperty(value = "sharedTimeOff")
    private MicrosoftGraphTimeOffItem sharedTimeOff;

    /*
     * ID of the user assigned to the timeOff. Required.
     */
    @JsonProperty(value = "userId")
    private String userId;

    /*
     * timeOff
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /**
     * Get the draftTimeOff property: timeOffItem.
     *
     * @return the draftTimeOff value.
     */
    public MicrosoftGraphTimeOffItem draftTimeOff() {
        return this.draftTimeOff;
    }

    /**
     * Set the draftTimeOff property: timeOffItem.
     *
     * @param draftTimeOff the draftTimeOff value to set.
     * @return the MicrosoftGraphTimeOff object itself.
     */
    public MicrosoftGraphTimeOff withDraftTimeOff(MicrosoftGraphTimeOffItem draftTimeOff) {
        this.draftTimeOff = draftTimeOff;
        return this;
    }

    /**
     * Get the sharedTimeOff property: timeOffItem.
     *
     * @return the sharedTimeOff value.
     */
    public MicrosoftGraphTimeOffItem sharedTimeOff() {
        return this.sharedTimeOff;
    }

    /**
     * Set the sharedTimeOff property: timeOffItem.
     *
     * @param sharedTimeOff the sharedTimeOff value to set.
     * @return the MicrosoftGraphTimeOff object itself.
     */
    public MicrosoftGraphTimeOff withSharedTimeOff(MicrosoftGraphTimeOffItem sharedTimeOff) {
        this.sharedTimeOff = sharedTimeOff;
        return this;
    }

    /**
     * Get the userId property: ID of the user assigned to the timeOff. Required.
     *
     * @return the userId value.
     */
    public String userId() {
        return this.userId;
    }

    /**
     * Set the userId property: ID of the user assigned to the timeOff. Required.
     *
     * @param userId the userId value to set.
     * @return the MicrosoftGraphTimeOff object itself.
     */
    public MicrosoftGraphTimeOff withUserId(String userId) {
        this.userId = userId;
        return this;
    }

    /**
     * Get the additionalProperties property: timeOff.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: timeOff.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphTimeOff object itself.
     */
    public MicrosoftGraphTimeOff withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphTimeOff withCreatedDateTime(OffsetDateTime createdDateTime) {
        super.withCreatedDateTime(createdDateTime);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphTimeOff withLastModifiedBy(MicrosoftGraphIdentitySet lastModifiedBy) {
        super.withLastModifiedBy(lastModifiedBy);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphTimeOff withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        super.withLastModifiedDateTime(lastModifiedDateTime);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphTimeOff withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (draftTimeOff() != null) {
            draftTimeOff().validate();
        }
        if (sharedTimeOff() != null) {
            sharedTimeOff().validate();
        }
    }
}
