// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;

/** sharepointIds. */
@Fluent
public final class MicrosoftGraphSharepointIds {
    /*
     * The unique identifier (guid) for the item's list in SharePoint.
     */
    @JsonProperty(value = "listId")
    private String listId;

    /*
     * An integer identifier for the item within the containing list.
     */
    @JsonProperty(value = "listItemId")
    private String listItemId;

    /*
     * The unique identifier (guid) for the item within OneDrive for Business
     * or a SharePoint site.
     */
    @JsonProperty(value = "listItemUniqueId")
    private String listItemUniqueId;

    /*
     * The unique identifier (guid) for the item's site collection (SPSite).
     */
    @JsonProperty(value = "siteId")
    private String siteId;

    /*
     * The SharePoint URL for the site that contains the item.
     */
    @JsonProperty(value = "siteUrl")
    private String siteUrl;

    /*
     * The unique identifier (guid) for the tenancy.
     */
    @JsonProperty(value = "tenantId")
    private String tenantId;

    /*
     * The unique identifier (guid) for the item's site (SPWeb).
     */
    @JsonProperty(value = "webId")
    private String webId;

    /*
     * sharepointIds
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /**
     * Get the listId property: The unique identifier (guid) for the item's list in SharePoint.
     *
     * @return the listId value.
     */
    public String listId() {
        return this.listId;
    }

    /**
     * Set the listId property: The unique identifier (guid) for the item's list in SharePoint.
     *
     * @param listId the listId value to set.
     * @return the MicrosoftGraphSharepointIds object itself.
     */
    public MicrosoftGraphSharepointIds withListId(String listId) {
        this.listId = listId;
        return this;
    }

    /**
     * Get the listItemId property: An integer identifier for the item within the containing list.
     *
     * @return the listItemId value.
     */
    public String listItemId() {
        return this.listItemId;
    }

    /**
     * Set the listItemId property: An integer identifier for the item within the containing list.
     *
     * @param listItemId the listItemId value to set.
     * @return the MicrosoftGraphSharepointIds object itself.
     */
    public MicrosoftGraphSharepointIds withListItemId(String listItemId) {
        this.listItemId = listItemId;
        return this;
    }

    /**
     * Get the listItemUniqueId property: The unique identifier (guid) for the item within OneDrive for Business or a
     * SharePoint site.
     *
     * @return the listItemUniqueId value.
     */
    public String listItemUniqueId() {
        return this.listItemUniqueId;
    }

    /**
     * Set the listItemUniqueId property: The unique identifier (guid) for the item within OneDrive for Business or a
     * SharePoint site.
     *
     * @param listItemUniqueId the listItemUniqueId value to set.
     * @return the MicrosoftGraphSharepointIds object itself.
     */
    public MicrosoftGraphSharepointIds withListItemUniqueId(String listItemUniqueId) {
        this.listItemUniqueId = listItemUniqueId;
        return this;
    }

    /**
     * Get the siteId property: The unique identifier (guid) for the item's site collection (SPSite).
     *
     * @return the siteId value.
     */
    public String siteId() {
        return this.siteId;
    }

    /**
     * Set the siteId property: The unique identifier (guid) for the item's site collection (SPSite).
     *
     * @param siteId the siteId value to set.
     * @return the MicrosoftGraphSharepointIds object itself.
     */
    public MicrosoftGraphSharepointIds withSiteId(String siteId) {
        this.siteId = siteId;
        return this;
    }

    /**
     * Get the siteUrl property: The SharePoint URL for the site that contains the item.
     *
     * @return the siteUrl value.
     */
    public String siteUrl() {
        return this.siteUrl;
    }

    /**
     * Set the siteUrl property: The SharePoint URL for the site that contains the item.
     *
     * @param siteUrl the siteUrl value to set.
     * @return the MicrosoftGraphSharepointIds object itself.
     */
    public MicrosoftGraphSharepointIds withSiteUrl(String siteUrl) {
        this.siteUrl = siteUrl;
        return this;
    }

    /**
     * Get the tenantId property: The unique identifier (guid) for the tenancy.
     *
     * @return the tenantId value.
     */
    public String tenantId() {
        return this.tenantId;
    }

    /**
     * Set the tenantId property: The unique identifier (guid) for the tenancy.
     *
     * @param tenantId the tenantId value to set.
     * @return the MicrosoftGraphSharepointIds object itself.
     */
    public MicrosoftGraphSharepointIds withTenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    /**
     * Get the webId property: The unique identifier (guid) for the item's site (SPWeb).
     *
     * @return the webId value.
     */
    public String webId() {
        return this.webId;
    }

    /**
     * Set the webId property: The unique identifier (guid) for the item's site (SPWeb).
     *
     * @param webId the webId value to set.
     * @return the MicrosoftGraphSharepointIds object itself.
     */
    public MicrosoftGraphSharepointIds withWebId(String webId) {
        this.webId = webId;
        return this;
    }

    /**
     * Get the additionalProperties property: sharepointIds.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: sharepointIds.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphSharepointIds object itself.
     */
    public MicrosoftGraphSharepointIds withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
