// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;

/** recipient. */
@Fluent
public class MicrosoftGraphRecipient {
    /*
     * emailAddress
     */
    @JsonProperty(value = "emailAddress")
    private MicrosoftGraphEmailAddress emailAddress;

    /*
     * recipient
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /**
     * Get the emailAddress property: emailAddress.
     *
     * @return the emailAddress value.
     */
    public MicrosoftGraphEmailAddress emailAddress() {
        return this.emailAddress;
    }

    /**
     * Set the emailAddress property: emailAddress.
     *
     * @param emailAddress the emailAddress value to set.
     * @return the MicrosoftGraphRecipient object itself.
     */
    public MicrosoftGraphRecipient withEmailAddress(MicrosoftGraphEmailAddress emailAddress) {
        this.emailAddress = emailAddress;
        return this;
    }

    /**
     * Get the additionalProperties property: recipient.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: recipient.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphRecipient object itself.
     */
    public MicrosoftGraphRecipient withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (emailAddress() != null) {
            emailAddress().validate();
        }
    }
}
