// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;

/** presence. */
@Fluent
public final class MicrosoftGraphPresence extends MicrosoftGraphEntity {
    /*
     * The supplemental information to a user's availability. Possible values
     * are Available, Away, BeRightBack,Busy, DoNotDisturb, InACall,
     * InAConferenceCall, Inactive,InAMeeting, Offline, OffWork,OutOfOffice,
     * PresenceUnknown,Presenting, UrgentInterruptionsOnly.
     */
    @JsonProperty(value = "activity")
    private String activity;

    /*
     * The base presence information for a user. Possible values are Available,
     * AvailableIdle,  Away, BeRightBack, Busy, BusyIdle, DoNotDisturb,
     * Offline, PresenceUnknown
     */
    @JsonProperty(value = "availability")
    private String availability;

    /*
     * presence
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /**
     * Get the activity property: The supplemental information to a user's availability. Possible values are Available,
     * Away, BeRightBack,Busy, DoNotDisturb, InACall, InAConferenceCall, Inactive,InAMeeting, Offline,
     * OffWork,OutOfOffice, PresenceUnknown,Presenting, UrgentInterruptionsOnly.
     *
     * @return the activity value.
     */
    public String activity() {
        return this.activity;
    }

    /**
     * Set the activity property: The supplemental information to a user's availability. Possible values are Available,
     * Away, BeRightBack,Busy, DoNotDisturb, InACall, InAConferenceCall, Inactive,InAMeeting, Offline,
     * OffWork,OutOfOffice, PresenceUnknown,Presenting, UrgentInterruptionsOnly.
     *
     * @param activity the activity value to set.
     * @return the MicrosoftGraphPresence object itself.
     */
    public MicrosoftGraphPresence withActivity(String activity) {
        this.activity = activity;
        return this;
    }

    /**
     * Get the availability property: The base presence information for a user. Possible values are Available,
     * AvailableIdle, Away, BeRightBack, Busy, BusyIdle, DoNotDisturb, Offline, PresenceUnknown.
     *
     * @return the availability value.
     */
    public String availability() {
        return this.availability;
    }

    /**
     * Set the availability property: The base presence information for a user. Possible values are Available,
     * AvailableIdle, Away, BeRightBack, Busy, BusyIdle, DoNotDisturb, Offline, PresenceUnknown.
     *
     * @param availability the availability value to set.
     * @return the MicrosoftGraphPresence object itself.
     */
    public MicrosoftGraphPresence withAvailability(String availability) {
        this.availability = availability;
        return this;
    }

    /**
     * Get the additionalProperties property: presence.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: presence.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphPresence object itself.
     */
    public MicrosoftGraphPresence withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphPresence withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }
}
