// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/** person. */
@Fluent
public final class MicrosoftGraphPerson extends MicrosoftGraphEntity {
    /*
     * The person's birthday.
     */
    @JsonProperty(value = "birthday")
    private String birthday;

    /*
     * The name of the person's company.
     */
    @JsonProperty(value = "companyName")
    private String companyName;

    /*
     * The person's department.
     */
    @JsonProperty(value = "department")
    private String department;

    /*
     * The person's display name.
     */
    @JsonProperty(value = "displayName")
    private String displayName;

    /*
     * The person's given name.
     */
    @JsonProperty(value = "givenName")
    private String givenName;

    /*
     * The instant message voice over IP (VOIP) session initiation protocol
     * (SIP) address for the user. Read-only.
     */
    @JsonProperty(value = "imAddress")
    private String imAddress;

    /*
     * true if the user has flagged this person as a favorite.
     */
    @JsonProperty(value = "isFavorite")
    private Boolean isFavorite;

    /*
     * The person's job title.
     */
    @JsonProperty(value = "jobTitle")
    private String jobTitle;

    /*
     * The location of the person's office.
     */
    @JsonProperty(value = "officeLocation")
    private String officeLocation;

    /*
     * Free-form notes that the user has taken about this person.
     */
    @JsonProperty(value = "personNotes")
    private String personNotes;

    /*
     * personType
     */
    @JsonProperty(value = "personType")
    private MicrosoftGraphPersonType personType;

    /*
     * The person's phone numbers.
     */
    @JsonProperty(value = "phones")
    private List<MicrosoftGraphPhone> phones;

    /*
     * The person's addresses.
     */
    @JsonProperty(value = "postalAddresses")
    private List<MicrosoftGraphLocation> postalAddresses;

    /*
     * The person's profession.
     */
    @JsonProperty(value = "profession")
    private String profession;

    /*
     * The person's email addresses.
     */
    @JsonProperty(value = "scoredEmailAddresses")
    private List<MicrosoftGraphScoredEmailAddress> scoredEmailAddresses;

    /*
     * The person's surname.
     */
    @JsonProperty(value = "surname")
    private String surname;

    /*
     * The user principal name (UPN) of the person. The UPN is an
     * Internet-style login name for the person based on the Internet standard
     * RFC 822. By convention, this should map to the person's email name. The
     * general format is alias@domain.
     */
    @JsonProperty(value = "userPrincipalName")
    private String userPrincipalName;

    /*
     * The person's websites.
     */
    @JsonProperty(value = "websites")
    private List<MicrosoftGraphWebsite> websites;

    /*
     * The phonetic Japanese name of the person's company.
     */
    @JsonProperty(value = "yomiCompany")
    private String yomiCompany;

    /*
     * person
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /**
     * Get the birthday property: The person's birthday.
     *
     * @return the birthday value.
     */
    public String birthday() {
        return this.birthday;
    }

    /**
     * Set the birthday property: The person's birthday.
     *
     * @param birthday the birthday value to set.
     * @return the MicrosoftGraphPerson object itself.
     */
    public MicrosoftGraphPerson withBirthday(String birthday) {
        this.birthday = birthday;
        return this;
    }

    /**
     * Get the companyName property: The name of the person's company.
     *
     * @return the companyName value.
     */
    public String companyName() {
        return this.companyName;
    }

    /**
     * Set the companyName property: The name of the person's company.
     *
     * @param companyName the companyName value to set.
     * @return the MicrosoftGraphPerson object itself.
     */
    public MicrosoftGraphPerson withCompanyName(String companyName) {
        this.companyName = companyName;
        return this;
    }

    /**
     * Get the department property: The person's department.
     *
     * @return the department value.
     */
    public String department() {
        return this.department;
    }

    /**
     * Set the department property: The person's department.
     *
     * @param department the department value to set.
     * @return the MicrosoftGraphPerson object itself.
     */
    public MicrosoftGraphPerson withDepartment(String department) {
        this.department = department;
        return this;
    }

    /**
     * Get the displayName property: The person's display name.
     *
     * @return the displayName value.
     */
    public String displayName() {
        return this.displayName;
    }

    /**
     * Set the displayName property: The person's display name.
     *
     * @param displayName the displayName value to set.
     * @return the MicrosoftGraphPerson object itself.
     */
    public MicrosoftGraphPerson withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    /**
     * Get the givenName property: The person's given name.
     *
     * @return the givenName value.
     */
    public String givenName() {
        return this.givenName;
    }

    /**
     * Set the givenName property: The person's given name.
     *
     * @param givenName the givenName value to set.
     * @return the MicrosoftGraphPerson object itself.
     */
    public MicrosoftGraphPerson withGivenName(String givenName) {
        this.givenName = givenName;
        return this;
    }

    /**
     * Get the imAddress property: The instant message voice over IP (VOIP) session initiation protocol (SIP) address
     * for the user. Read-only.
     *
     * @return the imAddress value.
     */
    public String imAddress() {
        return this.imAddress;
    }

    /**
     * Set the imAddress property: The instant message voice over IP (VOIP) session initiation protocol (SIP) address
     * for the user. Read-only.
     *
     * @param imAddress the imAddress value to set.
     * @return the MicrosoftGraphPerson object itself.
     */
    public MicrosoftGraphPerson withImAddress(String imAddress) {
        this.imAddress = imAddress;
        return this;
    }

    /**
     * Get the isFavorite property: true if the user has flagged this person as a favorite.
     *
     * @return the isFavorite value.
     */
    public Boolean isFavorite() {
        return this.isFavorite;
    }

    /**
     * Set the isFavorite property: true if the user has flagged this person as a favorite.
     *
     * @param isFavorite the isFavorite value to set.
     * @return the MicrosoftGraphPerson object itself.
     */
    public MicrosoftGraphPerson withIsFavorite(Boolean isFavorite) {
        this.isFavorite = isFavorite;
        return this;
    }

    /**
     * Get the jobTitle property: The person's job title.
     *
     * @return the jobTitle value.
     */
    public String jobTitle() {
        return this.jobTitle;
    }

    /**
     * Set the jobTitle property: The person's job title.
     *
     * @param jobTitle the jobTitle value to set.
     * @return the MicrosoftGraphPerson object itself.
     */
    public MicrosoftGraphPerson withJobTitle(String jobTitle) {
        this.jobTitle = jobTitle;
        return this;
    }

    /**
     * Get the officeLocation property: The location of the person's office.
     *
     * @return the officeLocation value.
     */
    public String officeLocation() {
        return this.officeLocation;
    }

    /**
     * Set the officeLocation property: The location of the person's office.
     *
     * @param officeLocation the officeLocation value to set.
     * @return the MicrosoftGraphPerson object itself.
     */
    public MicrosoftGraphPerson withOfficeLocation(String officeLocation) {
        this.officeLocation = officeLocation;
        return this;
    }

    /**
     * Get the personNotes property: Free-form notes that the user has taken about this person.
     *
     * @return the personNotes value.
     */
    public String personNotes() {
        return this.personNotes;
    }

    /**
     * Set the personNotes property: Free-form notes that the user has taken about this person.
     *
     * @param personNotes the personNotes value to set.
     * @return the MicrosoftGraphPerson object itself.
     */
    public MicrosoftGraphPerson withPersonNotes(String personNotes) {
        this.personNotes = personNotes;
        return this;
    }

    /**
     * Get the personType property: personType.
     *
     * @return the personType value.
     */
    public MicrosoftGraphPersonType personType() {
        return this.personType;
    }

    /**
     * Set the personType property: personType.
     *
     * @param personType the personType value to set.
     * @return the MicrosoftGraphPerson object itself.
     */
    public MicrosoftGraphPerson withPersonType(MicrosoftGraphPersonType personType) {
        this.personType = personType;
        return this;
    }

    /**
     * Get the phones property: The person's phone numbers.
     *
     * @return the phones value.
     */
    public List<MicrosoftGraphPhone> phones() {
        return this.phones;
    }

    /**
     * Set the phones property: The person's phone numbers.
     *
     * @param phones the phones value to set.
     * @return the MicrosoftGraphPerson object itself.
     */
    public MicrosoftGraphPerson withPhones(List<MicrosoftGraphPhone> phones) {
        this.phones = phones;
        return this;
    }

    /**
     * Get the postalAddresses property: The person's addresses.
     *
     * @return the postalAddresses value.
     */
    public List<MicrosoftGraphLocation> postalAddresses() {
        return this.postalAddresses;
    }

    /**
     * Set the postalAddresses property: The person's addresses.
     *
     * @param postalAddresses the postalAddresses value to set.
     * @return the MicrosoftGraphPerson object itself.
     */
    public MicrosoftGraphPerson withPostalAddresses(List<MicrosoftGraphLocation> postalAddresses) {
        this.postalAddresses = postalAddresses;
        return this;
    }

    /**
     * Get the profession property: The person's profession.
     *
     * @return the profession value.
     */
    public String profession() {
        return this.profession;
    }

    /**
     * Set the profession property: The person's profession.
     *
     * @param profession the profession value to set.
     * @return the MicrosoftGraphPerson object itself.
     */
    public MicrosoftGraphPerson withProfession(String profession) {
        this.profession = profession;
        return this;
    }

    /**
     * Get the scoredEmailAddresses property: The person's email addresses.
     *
     * @return the scoredEmailAddresses value.
     */
    public List<MicrosoftGraphScoredEmailAddress> scoredEmailAddresses() {
        return this.scoredEmailAddresses;
    }

    /**
     * Set the scoredEmailAddresses property: The person's email addresses.
     *
     * @param scoredEmailAddresses the scoredEmailAddresses value to set.
     * @return the MicrosoftGraphPerson object itself.
     */
    public MicrosoftGraphPerson withScoredEmailAddresses(List<MicrosoftGraphScoredEmailAddress> scoredEmailAddresses) {
        this.scoredEmailAddresses = scoredEmailAddresses;
        return this;
    }

    /**
     * Get the surname property: The person's surname.
     *
     * @return the surname value.
     */
    public String surname() {
        return this.surname;
    }

    /**
     * Set the surname property: The person's surname.
     *
     * @param surname the surname value to set.
     * @return the MicrosoftGraphPerson object itself.
     */
    public MicrosoftGraphPerson withSurname(String surname) {
        this.surname = surname;
        return this;
    }

    /**
     * Get the userPrincipalName property: The user principal name (UPN) of the person. The UPN is an Internet-style
     * login name for the person based on the Internet standard RFC 822. By convention, this should map to the person's
     * email name. The general format is alias@domain.
     *
     * @return the userPrincipalName value.
     */
    public String userPrincipalName() {
        return this.userPrincipalName;
    }

    /**
     * Set the userPrincipalName property: The user principal name (UPN) of the person. The UPN is an Internet-style
     * login name for the person based on the Internet standard RFC 822. By convention, this should map to the person's
     * email name. The general format is alias@domain.
     *
     * @param userPrincipalName the userPrincipalName value to set.
     * @return the MicrosoftGraphPerson object itself.
     */
    public MicrosoftGraphPerson withUserPrincipalName(String userPrincipalName) {
        this.userPrincipalName = userPrincipalName;
        return this;
    }

    /**
     * Get the websites property: The person's websites.
     *
     * @return the websites value.
     */
    public List<MicrosoftGraphWebsite> websites() {
        return this.websites;
    }

    /**
     * Set the websites property: The person's websites.
     *
     * @param websites the websites value to set.
     * @return the MicrosoftGraphPerson object itself.
     */
    public MicrosoftGraphPerson withWebsites(List<MicrosoftGraphWebsite> websites) {
        this.websites = websites;
        return this;
    }

    /**
     * Get the yomiCompany property: The phonetic Japanese name of the person's company.
     *
     * @return the yomiCompany value.
     */
    public String yomiCompany() {
        return this.yomiCompany;
    }

    /**
     * Set the yomiCompany property: The phonetic Japanese name of the person's company.
     *
     * @param yomiCompany the yomiCompany value to set.
     * @return the MicrosoftGraphPerson object itself.
     */
    public MicrosoftGraphPerson withYomiCompany(String yomiCompany) {
        this.yomiCompany = yomiCompany;
        return this;
    }

    /**
     * Get the additionalProperties property: person.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: person.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphPerson object itself.
     */
    public MicrosoftGraphPerson withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphPerson withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (personType() != null) {
            personType().validate();
        }
        if (phones() != null) {
            phones().forEach(e -> e.validate());
        }
        if (postalAddresses() != null) {
            postalAddresses().forEach(e -> e.validate());
        }
        if (scoredEmailAddresses() != null) {
            scoredEmailAddresses().forEach(e -> e.validate());
        }
        if (websites() != null) {
            websites().forEach(e -> e.validate());
        }
    }
}
