// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/** multiValueLegacyExtendedProperty. */
@Fluent
public final class MicrosoftGraphMultiValueLegacyExtendedProperty extends MicrosoftGraphEntity {
    /*
     * A collection of property values.
     */
    @JsonProperty(value = "value")
    private List<String> value;

    /*
     * multiValueLegacyExtendedProperty
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /**
     * Get the value property: A collection of property values.
     *
     * @return the value value.
     */
    public List<String> value() {
        return this.value;
    }

    /**
     * Set the value property: A collection of property values.
     *
     * @param value the value value to set.
     * @return the MicrosoftGraphMultiValueLegacyExtendedProperty object itself.
     */
    public MicrosoftGraphMultiValueLegacyExtendedProperty withValue(List<String> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the additionalProperties property: multiValueLegacyExtendedProperty.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: multiValueLegacyExtendedProperty.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphMultiValueLegacyExtendedProperty object itself.
     */
    public MicrosoftGraphMultiValueLegacyExtendedProperty withAdditionalProperties(
        Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphMultiValueLegacyExtendedProperty withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }
}
