// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;

/** messageRule. */
@Fluent
public final class MicrosoftGraphMessageRule extends MicrosoftGraphEntity {
    /*
     * messageRuleActions
     */
    @JsonProperty(value = "actions")
    private MicrosoftGraphMessageRuleActions actions;

    /*
     * messageRulePredicates
     */
    @JsonProperty(value = "conditions")
    private MicrosoftGraphMessageRulePredicates conditions;

    /*
     * The display name of the rule.
     */
    @JsonProperty(value = "displayName")
    private String displayName;

    /*
     * messageRulePredicates
     */
    @JsonProperty(value = "exceptions")
    private MicrosoftGraphMessageRulePredicates exceptions;

    /*
     * Indicates whether the rule is in an error condition. Read-only.
     */
    @JsonProperty(value = "hasError")
    private Boolean hasError;

    /*
     * Indicates whether the rule is enabled to be applied to messages.
     */
    @JsonProperty(value = "isEnabled")
    private Boolean isEnabled;

    /*
     * Indicates if the rule is read-only and cannot be modified or deleted by
     * the rules REST API.
     */
    @JsonProperty(value = "isReadOnly")
    private Boolean isReadOnly;

    /*
     * Indicates the order in which the rule is executed, among other rules.
     */
    @JsonProperty(value = "sequence")
    private Integer sequence;

    /*
     * messageRule
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /**
     * Get the actions property: messageRuleActions.
     *
     * @return the actions value.
     */
    public MicrosoftGraphMessageRuleActions actions() {
        return this.actions;
    }

    /**
     * Set the actions property: messageRuleActions.
     *
     * @param actions the actions value to set.
     * @return the MicrosoftGraphMessageRule object itself.
     */
    public MicrosoftGraphMessageRule withActions(MicrosoftGraphMessageRuleActions actions) {
        this.actions = actions;
        return this;
    }

    /**
     * Get the conditions property: messageRulePredicates.
     *
     * @return the conditions value.
     */
    public MicrosoftGraphMessageRulePredicates conditions() {
        return this.conditions;
    }

    /**
     * Set the conditions property: messageRulePredicates.
     *
     * @param conditions the conditions value to set.
     * @return the MicrosoftGraphMessageRule object itself.
     */
    public MicrosoftGraphMessageRule withConditions(MicrosoftGraphMessageRulePredicates conditions) {
        this.conditions = conditions;
        return this;
    }

    /**
     * Get the displayName property: The display name of the rule.
     *
     * @return the displayName value.
     */
    public String displayName() {
        return this.displayName;
    }

    /**
     * Set the displayName property: The display name of the rule.
     *
     * @param displayName the displayName value to set.
     * @return the MicrosoftGraphMessageRule object itself.
     */
    public MicrosoftGraphMessageRule withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    /**
     * Get the exceptions property: messageRulePredicates.
     *
     * @return the exceptions value.
     */
    public MicrosoftGraphMessageRulePredicates exceptions() {
        return this.exceptions;
    }

    /**
     * Set the exceptions property: messageRulePredicates.
     *
     * @param exceptions the exceptions value to set.
     * @return the MicrosoftGraphMessageRule object itself.
     */
    public MicrosoftGraphMessageRule withExceptions(MicrosoftGraphMessageRulePredicates exceptions) {
        this.exceptions = exceptions;
        return this;
    }

    /**
     * Get the hasError property: Indicates whether the rule is in an error condition. Read-only.
     *
     * @return the hasError value.
     */
    public Boolean hasError() {
        return this.hasError;
    }

    /**
     * Set the hasError property: Indicates whether the rule is in an error condition. Read-only.
     *
     * @param hasError the hasError value to set.
     * @return the MicrosoftGraphMessageRule object itself.
     */
    public MicrosoftGraphMessageRule withHasError(Boolean hasError) {
        this.hasError = hasError;
        return this;
    }

    /**
     * Get the isEnabled property: Indicates whether the rule is enabled to be applied to messages.
     *
     * @return the isEnabled value.
     */
    public Boolean isEnabled() {
        return this.isEnabled;
    }

    /**
     * Set the isEnabled property: Indicates whether the rule is enabled to be applied to messages.
     *
     * @param isEnabled the isEnabled value to set.
     * @return the MicrosoftGraphMessageRule object itself.
     */
    public MicrosoftGraphMessageRule withIsEnabled(Boolean isEnabled) {
        this.isEnabled = isEnabled;
        return this;
    }

    /**
     * Get the isReadOnly property: Indicates if the rule is read-only and cannot be modified or deleted by the rules
     * REST API.
     *
     * @return the isReadOnly value.
     */
    public Boolean isReadOnly() {
        return this.isReadOnly;
    }

    /**
     * Set the isReadOnly property: Indicates if the rule is read-only and cannot be modified or deleted by the rules
     * REST API.
     *
     * @param isReadOnly the isReadOnly value to set.
     * @return the MicrosoftGraphMessageRule object itself.
     */
    public MicrosoftGraphMessageRule withIsReadOnly(Boolean isReadOnly) {
        this.isReadOnly = isReadOnly;
        return this;
    }

    /**
     * Get the sequence property: Indicates the order in which the rule is executed, among other rules.
     *
     * @return the sequence value.
     */
    public Integer sequence() {
        return this.sequence;
    }

    /**
     * Set the sequence property: Indicates the order in which the rule is executed, among other rules.
     *
     * @param sequence the sequence value to set.
     * @return the MicrosoftGraphMessageRule object itself.
     */
    public MicrosoftGraphMessageRule withSequence(Integer sequence) {
        this.sequence = sequence;
        return this;
    }

    /**
     * Get the additionalProperties property: messageRule.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: messageRule.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphMessageRule object itself.
     */
    public MicrosoftGraphMessageRule withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /** {@inheritDoc} */
    @Override
    public MicrosoftGraphMessageRule withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (actions() != null) {
            actions().validate();
        }
        if (conditions() != null) {
            conditions().validate();
        }
        if (exceptions() != null) {
            exceptions().validate();
        }
    }
}
