// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;

/** listInfo. */
@Fluent
public final class MicrosoftGraphListInfo {
    /*
     * If true, indicates that content types are enabled for this list.
     */
    @JsonProperty(value = "contentTypesEnabled")
    private Boolean contentTypesEnabled;

    /*
     * If true, indicates that the list is not normally visible in the
     * SharePoint user experience.
     */
    @JsonProperty(value = "hidden")
    private Boolean hidden;

    /*
     * An enumerated value that represents the base list template used in
     * creating the list. Possible values include documentLibrary, genericList,
     * task, survey, announcements, contacts, and more.
     */
    @JsonProperty(value = "template")
    private String template;

    /*
     * listInfo
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /**
     * Get the contentTypesEnabled property: If true, indicates that content types are enabled for this list.
     *
     * @return the contentTypesEnabled value.
     */
    public Boolean contentTypesEnabled() {
        return this.contentTypesEnabled;
    }

    /**
     * Set the contentTypesEnabled property: If true, indicates that content types are enabled for this list.
     *
     * @param contentTypesEnabled the contentTypesEnabled value to set.
     * @return the MicrosoftGraphListInfo object itself.
     */
    public MicrosoftGraphListInfo withContentTypesEnabled(Boolean contentTypesEnabled) {
        this.contentTypesEnabled = contentTypesEnabled;
        return this;
    }

    /**
     * Get the hidden property: If true, indicates that the list is not normally visible in the SharePoint user
     * experience.
     *
     * @return the hidden value.
     */
    public Boolean hidden() {
        return this.hidden;
    }

    /**
     * Set the hidden property: If true, indicates that the list is not normally visible in the SharePoint user
     * experience.
     *
     * @param hidden the hidden value to set.
     * @return the MicrosoftGraphListInfo object itself.
     */
    public MicrosoftGraphListInfo withHidden(Boolean hidden) {
        this.hidden = hidden;
        return this;
    }

    /**
     * Get the template property: An enumerated value that represents the base list template used in creating the list.
     * Possible values include documentLibrary, genericList, task, survey, announcements, contacts, and more.
     *
     * @return the template value.
     */
    public String template() {
        return this.template;
    }

    /**
     * Set the template property: An enumerated value that represents the base list template used in creating the list.
     * Possible values include documentLibrary, genericList, task, survey, announcements, contacts, and more.
     *
     * @param template the template value to set.
     * @return the MicrosoftGraphListInfo object itself.
     */
    public MicrosoftGraphListInfo withTemplate(String template) {
        this.template = template;
        return this;
    }

    /**
     * Get the additionalProperties property: listInfo.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: listInfo.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphListInfo object itself.
     */
    public MicrosoftGraphListInfo withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
