// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

/** licenseAssignmentState. */
@Fluent
public final class MicrosoftGraphLicenseAssignmentState {
    /*
     * The assignedByGroup property.
     */
    @JsonProperty(value = "assignedByGroup")
    private String assignedByGroup;

    /*
     * The disabledPlans property.
     */
    @JsonProperty(value = "disabledPlans")
    private List<UUID> disabledPlans;

    /*
     * The error property.
     */
    @JsonProperty(value = "error")
    private String error;

    /*
     * The skuId property.
     */
    @JsonProperty(value = "skuId")
    private UUID skuId;

    /*
     * The state property.
     */
    @JsonProperty(value = "state")
    private String state;

    /*
     * licenseAssignmentState
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /**
     * Get the assignedByGroup property: The assignedByGroup property.
     *
     * @return the assignedByGroup value.
     */
    public String assignedByGroup() {
        return this.assignedByGroup;
    }

    /**
     * Set the assignedByGroup property: The assignedByGroup property.
     *
     * @param assignedByGroup the assignedByGroup value to set.
     * @return the MicrosoftGraphLicenseAssignmentState object itself.
     */
    public MicrosoftGraphLicenseAssignmentState withAssignedByGroup(String assignedByGroup) {
        this.assignedByGroup = assignedByGroup;
        return this;
    }

    /**
     * Get the disabledPlans property: The disabledPlans property.
     *
     * @return the disabledPlans value.
     */
    public List<UUID> disabledPlans() {
        return this.disabledPlans;
    }

    /**
     * Set the disabledPlans property: The disabledPlans property.
     *
     * @param disabledPlans the disabledPlans value to set.
     * @return the MicrosoftGraphLicenseAssignmentState object itself.
     */
    public MicrosoftGraphLicenseAssignmentState withDisabledPlans(List<UUID> disabledPlans) {
        this.disabledPlans = disabledPlans;
        return this;
    }

    /**
     * Get the error property: The error property.
     *
     * @return the error value.
     */
    public String error() {
        return this.error;
    }

    /**
     * Set the error property: The error property.
     *
     * @param error the error value to set.
     * @return the MicrosoftGraphLicenseAssignmentState object itself.
     */
    public MicrosoftGraphLicenseAssignmentState withError(String error) {
        this.error = error;
        return this;
    }

    /**
     * Get the skuId property: The skuId property.
     *
     * @return the skuId value.
     */
    public UUID skuId() {
        return this.skuId;
    }

    /**
     * Set the skuId property: The skuId property.
     *
     * @param skuId the skuId value to set.
     * @return the MicrosoftGraphLicenseAssignmentState object itself.
     */
    public MicrosoftGraphLicenseAssignmentState withSkuId(UUID skuId) {
        this.skuId = skuId;
        return this;
    }

    /**
     * Get the state property: The state property.
     *
     * @return the state value.
     */
    public String state() {
        return this.state;
    }

    /**
     * Set the state property: The state property.
     *
     * @param state the state value to set.
     * @return the MicrosoftGraphLicenseAssignmentState object itself.
     */
    public MicrosoftGraphLicenseAssignmentState withState(String state) {
        this.state = state;
        return this;
    }

    /**
     * Get the additionalProperties property: licenseAssignmentState.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: licenseAssignmentState.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphLicenseAssignmentState object itself.
     */
    public MicrosoftGraphLicenseAssignmentState withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
