// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.authorization.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;

/** image. */
@Fluent
public final class MicrosoftGraphImage {
    /*
     * Optional. Height of the image, in pixels. Read-only.
     */
    @JsonProperty(value = "height")
    private Integer height;

    /*
     * Optional. Width of the image, in pixels. Read-only.
     */
    @JsonProperty(value = "width")
    private Integer width;

    /*
     * image
     */
    @JsonIgnore private Map<String, Object> additionalProperties;

    /**
     * Get the height property: Optional. Height of the image, in pixels. Read-only.
     *
     * @return the height value.
     */
    public Integer height() {
        return this.height;
    }

    /**
     * Set the height property: Optional. Height of the image, in pixels. Read-only.
     *
     * @param height the height value to set.
     * @return the MicrosoftGraphImage object itself.
     */
    public MicrosoftGraphImage withHeight(Integer height) {
        this.height = height;
        return this;
    }

    /**
     * Get the width property: Optional. Width of the image, in pixels. Read-only.
     *
     * @return the width value.
     */
    public Integer width() {
        return this.width;
    }

    /**
     * Set the width property: Optional. Width of the image, in pixels. Read-only.
     *
     * @param width the width value to set.
     * @return the MicrosoftGraphImage object itself.
     */
    public MicrosoftGraphImage withWidth(Integer width) {
        this.width = width;
        return this;
    }

    /**
     * Get the additionalProperties property: image.
     *
     * @return the additionalProperties value.
     */
    @JsonAnyGetter
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    /**
     * Set the additionalProperties property: image.
     *
     * @param additionalProperties the additionalProperties value to set.
     * @return the MicrosoftGraphImage object itself.
     */
    public MicrosoftGraphImage withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @JsonAnySetter
    void withAdditionalProperties(String key, Object value) {
        if (additionalProperties == null) {
            additionalProperties = new HashMap<>();
        }
        additionalProperties.put(key, value);
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
